/*
 * Decompiled with CFR 0.152.
 */
package org.fibs.geotag.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GraphicsEnvironment;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class FontChooser
extends JDialog {
    private static final I18n i18n = I18nFactory.getI18n(FontChooser.class);
    private static final int SMALLEST_FONT_SIZE = 6;
    private static final int BIGGEST_FONT_SIZE = 30;
    private Font displayedFont;

    public FontChooser(Frame parent, Font initialFont) {
        super(parent, i18n.tr("Select Font"), true);
        this.displayedFont = initialFont;
        if (this.displayedFont == null) {
            this.displayedFont = this.getFont();
        }
        System.out.println();
        String[] fontList = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        this.setLayout(new BorderLayout());
        String sampleText = "AaBbCcXxYyZz 0123456789";
        final JLabel sampleTextLabel = new JLabel("AaBbCcXxYyZz 0123456789"){

            @Override
            public Dimension getMinimumSize() {
                Font largestFont = new Font(FontChooser.this.getDisplayedFont().getFamily(), 0, 30);
                FontMetrics fontMetrics = this.getFontMetrics(largestFont);
                int minumumWidth = fontMetrics.stringWidth(this.getText());
                int factor = 5;
                int minimumHeight = fontMetrics.getHeight() * 5;
                return new Dimension(minumumWidth, minimumHeight);
            }

            @Override
            public Dimension getPreferredSize() {
                return this.getMinimumSize();
            }

            @Override
            public void paint(Graphics graphics) {
                int width = this.getWidth();
                int height = this.getHeight();
                int centreLine = height / 2;
                FontMetrics fontMetrics = this.getFontMetrics(FontChooser.this.getDisplayedFont());
                int stringWidth = fontMetrics.stringWidth("AaBbCcXxYyZz 0123456789");
                int x = (width - stringWidth) / 2;
                int y = (int)((double)centreLine - (double)fontMetrics.getHeight() / 2.0);
                graphics.setColor(this.getForeground());
                graphics.drawString("AaBbCcXxYyZz 0123456789", x, y);
                Font boldFont = FontChooser.this.getDisplayedFont().deriveFont(1);
                graphics.setFont(boldFont);
                fontMetrics = this.getFontMetrics(boldFont);
                stringWidth = fontMetrics.stringWidth("AaBbCcXxYyZz 0123456789");
                x = (width - stringWidth) / 2;
                y = (int)((double)centreLine + (double)fontMetrics.getHeight() * 1.5);
                graphics.drawString("AaBbCcXxYyZz 0123456789", x, y);
            }
        };
        sampleTextLabel.setFont(this.displayedFont);
        this.add((Component)sampleTextLabel, "Center");
        JPanel fontSelectionPanel = new JPanel(new GridLayout(1, 2));
        final JComboBox<String> fontNamesComboBox = new JComboBox<String>(fontList);
        fontNamesComboBox.setSelectedItem(this.displayedFont.getFamily());
        fontSelectionPanel.add(fontNamesComboBox);
        SpinnerNumberModel spinnerModel = new SpinnerNumberModel(this.displayedFont.getSize(), 6, 30, 1);
        final JSpinner fontSizesSpinner = new JSpinner(spinnerModel);
        fontSelectionPanel.add(fontSizesSpinner);
        ItemListener itemListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                String fontName = (String)fontNamesComboBox.getSelectedItem();
                String fontSize = ((Integer)fontSizesSpinner.getValue()).toString();
                FontChooser.this.setDisplayedFont(new Font(fontName, 0, Integer.parseInt(fontSize)));
                sampleTextLabel.setFont(FontChooser.this.getDisplayedFont());
                sampleTextLabel.repaint();
            }
        };
        fontNamesComboBox.addItemListener(itemListener);
        ChangeListener changeListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                String fontName = (String)fontNamesComboBox.getSelectedItem();
                String fontSize = ((Integer)fontSizesSpinner.getValue()).toString();
                FontChooser.this.setDisplayedFont(new Font(fontName, 0, Integer.parseInt(fontSize)));
                sampleTextLabel.setFont(FontChooser.this.getDisplayedFont());
                sampleTextLabel.repaint();
            }
        };
        fontSizesSpinner.addChangeListener(changeListener);
        this.add((Component)fontSelectionPanel, "North");
        JPanel buttonPanel = new JPanel(new GridLayout(1, 2));
        JButton okButton = new JButton(i18n.tr("OK"));
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FontChooser.this.dispose();
            }
        });
        buttonPanel.add(okButton);
        JButton cancelButton = new JButton(i18n.tr("Cancel"));
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FontChooser.this.setDisplayedFont(null);
                FontChooser.this.dispose();
            }
        });
        buttonPanel.add(cancelButton);
        this.add((Component)buttonPanel, "South");
        this.pack();
        this.setSize(this.getPreferredSize());
        this.setLocationRelativeTo(parent);
    }

    public Font showDialog() {
        this.setVisible(true);
        return this.getSelectedFont();
    }

    public Font getSelectedFont() {
        return this.displayedFont;
    }

    Font getDisplayedFont() {
        return this.displayedFont;
    }

    void setDisplayedFont(Font displayedFont) {
        this.displayedFont = displayedFont;
    }
}

