/*
 * Decompiled with CFR 0.152.
 */
package org.fibs.geotag.gui.menus.actions;

import java.util.ArrayList;
import org.fibs.geotag.data.ImageInfo;
import org.fibs.geotag.gui.menus.MenuConstants;
import org.fibs.geotag.gui.menus.actions.MenuAction;
import org.fibs.geotag.table.ImagesTable;
import org.fibs.geotag.table.ImagesTableModel;
import org.fibs.geotag.tasks.SetOffsetTask;
import org.fibs.geotag.tasks.TaskExecutor;

public class CopyOffsetToAllAction
implements MenuAction,
MenuConstants {
    private ImageInfo fromImage;
    private ImagesTable imagesTable;

    public CopyOffsetToAllAction(ImageInfo fromImage, ImagesTable imagesTable) {
        this.fromImage = fromImage;
        this.imagesTable = imagesTable;
    }

    @Override
    public void perform() {
        int offset = this.fromImage.getOffset();
        ArrayList<ImageInfo> imageList = new ArrayList<ImageInfo>();
        ImagesTableModel tableModel = (ImagesTableModel)this.imagesTable.getModel();
        int index = 0;
        while (index < tableModel.getRowCount()) {
            ImageInfo image = tableModel.getImageInfo(index);
            imageList.add(image);
            ++index;
        }
        TaskExecutor.execute(new SetOffsetTask(COPY_TIME_OFFSET, COPY_TIME_OFFSET_ALL, tableModel, offset, imageList));
    }
}

