/*
 * Decompiled with CFR 0.152.
 */
package org.fibs.geotag.table;

import org.fibs.geotag.Settings;
import org.fibs.geotag.util.Units;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public final class ImagesTableColumns {
    private static final I18n i18n = I18nFactory.getI18n(ImagesTableColumns.class);

    private ImagesTableColumns() {
    }

    public static String getDescription(COLUMN column) {
        switch (column) {
            case IMAGE_NAME: {
                return i18n.tr("The name of the image file");
            }
            case GPS_DATE: {
                return i18n.tr("The GPS time in GMT for this image.");
            }
            case TIME_OFFSET: {
                return i18n.tr("The difference between camera time and GPS time");
            }
            case CAMERA_DATE: {
                return i18n.tr("The time recorded by the camera for this image");
            }
            case LATITUDE: {
                return i18n.tr("The latitude (in degrees) associated with this image");
            }
            case LONGITUDE: {
                return i18n.tr("The longitude (in degrees) associated with this image");
            }
            case ALTITUDE: {
                Units.ALTITUDE unit = Units.ALTITUDE.values()[Settings.get(Settings.SETTING.ALTITUDE_UNIT, 0)];
                String unitAbbreviation = Units.getAbbreviation(unit);
                String description = String.format(i18n.tr("The altitude (in %1$s) associated with this image"), unitAbbreviation);
                return description;
            }
            case DIRECTION: {
                return i18n.tr("Image direction in degrees");
            }
            case LOCATION_NAME: {
                return i18n.tr("Location name");
            }
            case CITY_NAME: {
                return i18n.tr("The city name");
            }
            case PROVINCE_NAME: {
                return i18n.tr("Province/State name");
            }
            case COUNTRY_NAME: {
                return i18n.tr("Country name");
            }
            case USER_COMMENT: {
                return i18n.tr("Description");
            }
        }
        return null;
    }

    public static enum COLUMN {
        IMAGE_NAME,
        GPS_DATE,
        TIME_OFFSET,
        CAMERA_DATE,
        LATITUDE,
        LONGITUDE,
        ALTITUDE,
        DIRECTION,
        LOCATION_NAME,
        CITY_NAME,
        PROVINCE_NAME,
        COUNTRY_NAME,
        USER_COMMENT;

    }
}

