/*
 * Decompiled with CFR 0.152.
 */
package org.fibs.geotag.tasks;

import java.util.List;
import org.fibs.geotag.data.ImageInfo;
import org.fibs.geotag.image.ThumbnailGenerator;
import org.fibs.geotag.tasks.BackgroundTask;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class ThumbnailsTask
extends BackgroundTask<ImageInfo> {
    private static final I18n i18n = I18nFactory.getI18n(ThumbnailsTask.class);
    private List<ImageInfo> imageInfos;
    private int currentProgress = 0;

    public ThumbnailsTask(String name, List<ImageInfo> imageInfos) {
        super(name);
        this.imageInfos = imageInfos;
    }

    @Override
    public int getCurrentProgress() {
        return this.currentProgress;
    }

    @Override
    public int getMaxProgress() {
        return this.imageInfos.size();
    }

    @Override
    public int getMinProgress() {
        return 1;
    }

    @Override
    protected String doInBackground() throws Exception {
        for (ImageInfo imageInfo : this.imageInfos) {
            if (this.interruptRequested()) break;
            ++this.currentProgress;
            this.setProgressMessage(i18n.tr("Generating thumbnails:"));
            if (imageInfo.getThumbNailStatus() != ImageInfo.THUMBNAIL_STATUS.UNKNOWN || !ThumbnailGenerator.loadThumbnail(imageInfo)) continue;
            this.publish(imageInfo);
        }
        String result = i18n.tr("Thumbnails generated.");
        return result;
    }
}

