/*
 * Decompiled with CFR 0.152.
 */
package org.fibs.geotag.util;

import java.util.List;
import junit.framework.TestCase;
import org.fibs.geotag.util.CommandLineTokenizer;

public class CommandLineTokenizerTest
extends TestCase {
    private void check(String[] expected, List<String> actual) {
        CommandLineTokenizerTest.assertNotNull(actual);
        CommandLineTokenizerTest.assertEquals((int)expected.length, (int)actual.size());
        int index = 0;
        while (index < expected.length) {
            CommandLineTokenizerTest.assertEquals((String)expected[index], (String)actual.get(index));
            ++index;
        }
    }

    public void testTokenizer() {
        String input = "my line";
        String[] expected = new String[]{"my", "line"};
        this.check(expected, new CommandLineTokenizer(input).tokenize());
        input = "   my    line   ";
        expected = new String[]{"my", "line"};
        this.check(expected, new CommandLineTokenizer(input).tokenize());
        input = "my \"'sin gle'\"";
        expected = new String[]{"my", "'sin gle'"};
        this.check(expected, new CommandLineTokenizer(input).tokenize());
        input = "my '\"dou ble\"'";
        expected = new String[]{"my", "\"dou ble\""};
        this.check(expected, new CommandLineTokenizer(input).tokenize());
        input = "my' funny line'";
        expected = new String[]{"my funny line"};
        this.check(expected, new CommandLineTokenizer(input).tokenize());
        input = "my\" funny line\"";
        expected = new String[]{"my funny line"};
        this.check(expected, new CommandLineTokenizer(input).tokenize());
    }
}

