/*
 * Decompiled with CFR 0.152.
 */
package org.fibs.geotag.util;

import junit.framework.TestCase;
import org.fibs.geotag.util.Coordinates;

public class CoordinatesTest
extends TestCase {
    private static final double DELTA = 1.0E-7;
    private static final String D = "\u00b0";
    private static final String M = "\u2032";
    private static final String S = "\u2033";

    public void testLatitude() {
        String formatted = Coordinates.format(Coordinates.FORMAT.SIGNED_DEGREES, 51.477222222222224, false);
        CoordinatesTest.assertEquals((String)"51.4772222\u00b0", (String)formatted);
        double parsed = Coordinates.parse(formatted, false);
        CoordinatesTest.assertEquals((double)51.477222222222224, (double)parsed, (double)1.0E-7);
        formatted = Coordinates.format(Coordinates.FORMAT.SIGNED_DEGREES_MINUTES, 51.477222222222224, false);
        CoordinatesTest.assertEquals((String)"51\u00b028.63333\u2032", (String)formatted);
        parsed = Coordinates.parse(formatted, false);
        CoordinatesTest.assertEquals((double)51.477222222222224, (double)parsed, (double)1.0E-7);
        formatted = Coordinates.format(Coordinates.FORMAT.SIGNED_DEGREES_MINUTES_SECONDS, 51.477222222222224, false);
        CoordinatesTest.assertEquals((String)"51\u00b028\u203238.00\u2033", (String)formatted);
        parsed = Coordinates.parse(formatted, false);
        CoordinatesTest.assertEquals((double)51.477222222222224, (double)parsed, (double)1.0E-7);
        formatted = Coordinates.format(Coordinates.FORMAT.DEGREES, 51.477222222222224, false);
        CoordinatesTest.assertEquals((String)"N 51.4772222\u00b0", (String)formatted);
        parsed = Coordinates.parse(formatted, false);
        CoordinatesTest.assertEquals((double)51.477222222222224, (double)parsed, (double)1.0E-7);
        formatted = Coordinates.format(Coordinates.FORMAT.DEGREES_MINUTES, 51.477222222222224, false);
        CoordinatesTest.assertEquals((String)"N 51\u00b028.63333\u2032", (String)formatted);
        parsed = Coordinates.parse(formatted, false);
        CoordinatesTest.assertEquals((double)51.477222222222224, (double)parsed, (double)1.0E-7);
        formatted = Coordinates.format(Coordinates.FORMAT.DEGREES_MINUTES_SECONDS, 51.477222222222224, false);
        CoordinatesTest.assertEquals((String)"N 51\u00b028\u203238.00\u2033", (String)formatted);
        parsed = Coordinates.parse(formatted, false);
        CoordinatesTest.assertEquals((double)51.477222222222224, (double)parsed, (double)1.0E-7);
        formatted = Coordinates.format(Coordinates.FORMAT.SIGNED_DEGREES, -51.477222222222224, false);
        CoordinatesTest.assertEquals((String)"-51.4772222\u00b0", (String)formatted);
        parsed = Coordinates.parse(formatted, false);
        CoordinatesTest.assertEquals((double)-51.477222222222224, (double)parsed, (double)1.0E-7);
        formatted = Coordinates.format(Coordinates.FORMAT.SIGNED_DEGREES_MINUTES, -51.477222222222224, false);
        CoordinatesTest.assertEquals((String)"-51\u00b028.63333\u2032", (String)formatted);
        parsed = Coordinates.parse(formatted, false);
        CoordinatesTest.assertEquals((double)-51.477222222222224, (double)parsed, (double)1.0E-7);
        formatted = Coordinates.format(Coordinates.FORMAT.SIGNED_DEGREES_MINUTES_SECONDS, -51.477222222222224, false);
        CoordinatesTest.assertEquals((String)"-51\u00b028\u203238.00\u2033", (String)formatted);
        parsed = Coordinates.parse(formatted, false);
        CoordinatesTest.assertEquals((double)-51.477222222222224, (double)parsed, (double)1.0E-7);
        formatted = Coordinates.format(Coordinates.FORMAT.DEGREES, -51.477222222222224, false);
        CoordinatesTest.assertEquals((String)"S 51.4772222\u00b0", (String)formatted);
        parsed = Coordinates.parse(formatted, false);
        CoordinatesTest.assertEquals((double)-51.477222222222224, (double)parsed, (double)1.0E-7);
        formatted = Coordinates.format(Coordinates.FORMAT.DEGREES_MINUTES, -51.477222222222224, false);
        CoordinatesTest.assertEquals((String)"S 51\u00b028.63333\u2032", (String)formatted);
        parsed = Coordinates.parse(formatted, false);
        CoordinatesTest.assertEquals((double)-51.477222222222224, (double)parsed, (double)1.0E-7);
        formatted = Coordinates.format(Coordinates.FORMAT.DEGREES_MINUTES_SECONDS, -51.477222222222224, false);
        CoordinatesTest.assertEquals((String)"S 51\u00b028\u203238.00\u2033", (String)formatted);
        parsed = Coordinates.parse(formatted, false);
        CoordinatesTest.assertEquals((double)-51.477222222222224, (double)parsed, (double)1.0E-7);
    }

    public void testLongitude() {
        String formatted = Coordinates.format(Coordinates.FORMAT.SIGNED_DEGREES, 51.477222222222224, true);
        CoordinatesTest.assertEquals((String)"51.4772222\u00b0", (String)formatted);
        double parsed = Coordinates.parse(formatted, true);
        CoordinatesTest.assertEquals((double)51.477222222222224, (double)parsed, (double)1.0E-7);
        formatted = Coordinates.format(Coordinates.FORMAT.SIGNED_DEGREES_MINUTES, 51.477222222222224, true);
        CoordinatesTest.assertEquals((String)"51\u00b028.63333\u2032", (String)formatted);
        parsed = Coordinates.parse(formatted, true);
        CoordinatesTest.assertEquals((double)51.477222222222224, (double)parsed, (double)1.0E-7);
        formatted = Coordinates.format(Coordinates.FORMAT.SIGNED_DEGREES_MINUTES_SECONDS, 51.477222222222224, true);
        CoordinatesTest.assertEquals((String)"51\u00b028\u203238.00\u2033", (String)formatted);
        parsed = Coordinates.parse(formatted, true);
        CoordinatesTest.assertEquals((double)51.477222222222224, (double)parsed, (double)1.0E-7);
        formatted = Coordinates.format(Coordinates.FORMAT.DEGREES, 51.477222222222224, true);
        CoordinatesTest.assertEquals((String)"E 51.4772222\u00b0", (String)formatted);
        parsed = Coordinates.parse(formatted, true);
        CoordinatesTest.assertEquals((double)51.477222222222224, (double)parsed, (double)1.0E-7);
        formatted = Coordinates.format(Coordinates.FORMAT.DEGREES_MINUTES, 51.477222222222224, true);
        CoordinatesTest.assertEquals((String)"E 51\u00b028.63333\u2032", (String)formatted);
        parsed = Coordinates.parse(formatted, true);
        CoordinatesTest.assertEquals((double)51.477222222222224, (double)parsed, (double)1.0E-7);
        formatted = Coordinates.format(Coordinates.FORMAT.DEGREES_MINUTES_SECONDS, 51.477222222222224, true);
        CoordinatesTest.assertEquals((String)"E 51\u00b028\u203238.00\u2033", (String)formatted);
        parsed = Coordinates.parse(formatted, true);
        CoordinatesTest.assertEquals((double)51.477222222222224, (double)parsed, (double)1.0E-7);
        formatted = Coordinates.format(Coordinates.FORMAT.SIGNED_DEGREES, -51.477222222222224, true);
        CoordinatesTest.assertEquals((String)"-51.4772222\u00b0", (String)formatted);
        parsed = Coordinates.parse(formatted, true);
        CoordinatesTest.assertEquals((double)-51.477222222222224, (double)parsed, (double)1.0E-7);
        formatted = Coordinates.format(Coordinates.FORMAT.SIGNED_DEGREES_MINUTES, -51.477222222222224, true);
        CoordinatesTest.assertEquals((String)"-51\u00b028.63333\u2032", (String)formatted);
        parsed = Coordinates.parse(formatted, true);
        CoordinatesTest.assertEquals((double)-51.477222222222224, (double)parsed, (double)1.0E-7);
        formatted = Coordinates.format(Coordinates.FORMAT.SIGNED_DEGREES_MINUTES_SECONDS, -51.477222222222224, true);
        CoordinatesTest.assertEquals((String)"-51\u00b028\u203238.00\u2033", (String)formatted);
        parsed = Coordinates.parse(formatted, true);
        CoordinatesTest.assertEquals((double)-51.477222222222224, (double)parsed, (double)1.0E-7);
        formatted = Coordinates.format(Coordinates.FORMAT.DEGREES, -51.477222222222224, true);
        CoordinatesTest.assertEquals((String)"W 51.4772222\u00b0", (String)formatted);
        parsed = Coordinates.parse(formatted, true);
        CoordinatesTest.assertEquals((double)-51.477222222222224, (double)parsed, (double)1.0E-7);
        formatted = Coordinates.format(Coordinates.FORMAT.DEGREES_MINUTES, -51.477222222222224, true);
        CoordinatesTest.assertEquals((String)"W 51\u00b028.63333\u2032", (String)formatted);
        parsed = Coordinates.parse(formatted, true);
        CoordinatesTest.assertEquals((double)-51.477222222222224, (double)parsed, (double)1.0E-7);
        formatted = Coordinates.format(Coordinates.FORMAT.DEGREES_MINUTES_SECONDS, -51.477222222222224, true);
        CoordinatesTest.assertEquals((String)"W 51\u00b028\u203238.00\u2033", (String)formatted);
        parsed = Coordinates.parse(formatted, true);
        CoordinatesTest.assertEquals((double)-51.477222222222224, (double)parsed, (double)1.0E-7);
    }

    public void testNaN() {
        String formatted = Coordinates.format(Coordinates.FORMAT.SIGNED_DEGREES_MINUTES_SECONDS, -51.477222222222224, true);
        CoordinatesTest.assertEquals((String)"-51\u00b028\u203238.00\u2033", (String)formatted);
        double parsed = Coordinates.parse("~" + formatted, true);
        CoordinatesTest.assertEquals((double)Double.NaN, (double)parsed, (double)1.0E-7);
        parsed = Coordinates.parse(String.valueOf(formatted) + "~", true);
        CoordinatesTest.assertEquals((double)Double.NaN, (double)parsed, (double)1.0E-7);
    }
}

