/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.decorator;

import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JLabel;
import org.jdesktop.swingx.decorator.AbstractHighlighter;
import org.jdesktop.swingx.decorator.ComponentAdapter;
import org.jdesktop.swingx.decorator.HighlightPredicate;
import org.jdesktop.swingx.renderer.IconAware;

public class IconHighlighter
extends AbstractHighlighter {
    private Icon icon;

    public IconHighlighter() {
        this((HighlightPredicate)null);
    }

    public IconHighlighter(HighlightPredicate predicate) {
        this(predicate, null);
    }

    public IconHighlighter(Icon icon) {
        this(null, icon);
    }

    public IconHighlighter(HighlightPredicate predicate, Icon icon) {
        super(predicate);
        this.setIcon(icon);
    }

    public void setIcon(Icon icon) {
        if (this.areEqual(icon, this.getIcon())) {
            return;
        }
        this.icon = icon;
        this.fireStateChanged();
    }

    public Icon getIcon() {
        return this.icon;
    }

    @Override
    protected Component doHighlight(Component component, ComponentAdapter adapter) {
        if (this.getIcon() != null) {
            if (component instanceof IconAware) {
                ((IconAware)((Object)component)).setIcon(this.getIcon());
            } else if (component instanceof JLabel) {
                ((JLabel)component).setIcon(this.getIcon());
            }
        }
        return component;
    }

    @Override
    protected boolean canHighlight(Component component, ComponentAdapter adapter) {
        return component instanceof IconAware || component instanceof JLabel;
    }
}

