/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.cj.core.conf.url;

import com.mysql.cj.api.conf.ConnectionPropertiesTransform;
import com.mysql.cj.api.conf.DatabaseUrlContainer;
import com.mysql.cj.core.Messages;
import com.mysql.cj.core.conf.url.ConnectionUrlParser;
import com.mysql.cj.core.conf.url.FailoverConnectionUrl;
import com.mysql.cj.core.conf.url.HostInfo;
import com.mysql.cj.core.conf.url.LoadbalanceConnectionUrl;
import com.mysql.cj.core.conf.url.ReplicationConnectionUrl;
import com.mysql.cj.core.conf.url.SingleConnectionUrl;
import com.mysql.cj.core.conf.url.XDevAPIConnectionUrl;
import com.mysql.cj.core.exceptions.CJException;
import com.mysql.cj.core.exceptions.ExceptionFactory;
import com.mysql.cj.core.exceptions.InvalidConnectionAttributeException;
import com.mysql.cj.core.exceptions.WrongArgumentException;
import com.mysql.cj.core.io.NamedPipeSocketFactory;
import com.mysql.cj.core.util.LRUCache;
import com.mysql.cj.core.util.StringUtils;
import com.mysql.cj.core.util.Util;
import com.mysql.cj.jdbc.Driver;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;

public abstract class ConnectionUrl
implements DatabaseUrlContainer {
    private static final String DEFAULT_HOST = "localhost";
    private static final int DEFAULT_PORT = 3306;
    protected Type type;
    protected String originalConnStr;
    protected String originalDatabase;
    protected List<HostInfo> hosts = new ArrayList<HostInfo>();
    protected Map<String, String> properties = new HashMap<String, String>();
    ConnectionPropertiesTransform propertiesTransformer;
    private static final LRUCache connectionUrlCache = new LRUCache(100);
    private static final ReadWriteLock rwLock = new ReentrantReadWriteLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ConnectionUrl getConnectionUrlInstance(String connString, Properties info) {
        if (connString == null) {
            throw ExceptionFactory.createException(WrongArgumentException.class, Messages.getString("ConnectionString.0"));
        }
        String connStringCacheKey = ConnectionUrl.buildConnectionStringCacheKey(connString, info);
        rwLock.readLock().lock();
        ConnectionUrl connectionString = (ConnectionUrl)connectionUrlCache.get(connStringCacheKey);
        if (connectionString == null) {
            rwLock.readLock().unlock();
            rwLock.writeLock().lock();
            try {
                connectionString = (ConnectionUrl)connectionUrlCache.get(connStringCacheKey);
                if (connectionString == null) {
                    ConnectionUrlParser connStrParser = ConnectionUrlParser.parseConnectionString(connString);
                    try {
                        Type.fromValue(connStrParser.getScheme(), -1);
                    }
                    catch (WrongArgumentException e) {
                        ConnectionUrl connectionUrl = new ConnectionUrl(connString){};
                        rwLock.writeLock().unlock();
                        return connectionUrl;
                    }
                    switch (Type.fromValue(connStrParser.getScheme(), connStrParser.getHosts().size())) {
                        case SINGLE_CONNECTION: {
                            connectionString = new SingleConnectionUrl(connStrParser, info);
                            break;
                        }
                        case FAILOVER_CONNECTION: {
                            connectionString = new FailoverConnectionUrl(connStrParser, info);
                            break;
                        }
                        case LOADBALANCE_CONNECTION: {
                            connectionString = new LoadbalanceConnectionUrl(connStrParser, info);
                            break;
                        }
                        case REPLICATION_CONNECTION: {
                            connectionString = new ReplicationConnectionUrl(connStrParser, info);
                            break;
                        }
                        case XDEVAPI_SESSION: {
                            connectionString = new XDevAPIConnectionUrl(connStrParser, info);
                            break;
                        }
                        default: {
                            ConnectionUrl connectionUrl = new ConnectionUrl(connString){};
                            return connectionUrl;
                        }
                    }
                    connectionUrlCache.put(connStringCacheKey, connectionString);
                }
                rwLock.readLock().lock();
            }
            finally {
                rwLock.writeLock().unlock();
            }
        }
        rwLock.readLock().unlock();
        return connectionString;
    }

    private static String buildConnectionStringCacheKey(String connString, Properties info) {
        StringBuilder sbKey = new StringBuilder(connString);
        sbKey.append("??");
        sbKey.append(info == null ? null : info.stringPropertyNames().stream().map(k -> k + "=" + info.getProperty((String)k)).collect(Collectors.joining(", ", "{", "}")));
        return sbKey.toString();
    }

    public static boolean acceptsUrl(String connString) {
        if (connString == null) {
            throw ExceptionFactory.createException(WrongArgumentException.class, Messages.getString("ConnectionString.0"));
        }
        try {
            ConnectionUrlParser connStringParser = ConnectionUrlParser.parseConnectionString(connString);
            Type.fromValue(connStringParser.getScheme(), -1);
        }
        catch (Throwable t) {
            return false;
        }
        return true;
    }

    protected ConnectionUrl() {
    }

    public ConnectionUrl(String origUrl) {
        this.originalConnStr = origUrl;
    }

    protected ConnectionUrl(ConnectionUrlParser connStrParser, Properties info) {
        this.originalConnStr = connStrParser.getDatabaseUrl();
        this.originalDatabase = connStrParser.getPath() == null ? "" : connStrParser.getPath();
        this.collectProperties(connStrParser, info);
        this.collectHostsInfo(connStrParser);
    }

    protected void collectProperties(ConnectionUrlParser connStrParser, Properties info) {
        this.properties.putAll(connStrParser.getProperties());
        if (info != null) {
            info.stringPropertyNames().stream().forEach(k -> this.properties.put((String)k, info.getProperty((String)k)));
        }
        this.processColdFusionAutoConfiguration();
        this.setupPropertiesTransformer();
        this.expandPropertiesFromConfigFiles(this.properties);
        this.injectPerTypeProperties(this.properties);
    }

    protected void processColdFusionAutoConfiguration() {
        String autoConfigCf;
        if (Util.isColdFusion() && ((autoConfigCf = this.properties.get("autoConfigureForColdFusion")) == null || autoConfigCf.equalsIgnoreCase("TRUE") || autoConfigCf.equalsIgnoreCase("YES"))) {
            String currentConfigFiles = this.properties.get("useConfigs");
            StringBuilder newConfigFiles = new StringBuilder();
            if (currentConfigFiles != null) {
                newConfigFiles.append(currentConfigFiles).append(",");
            }
            newConfigFiles.append("coldFusion");
            this.properties.put("useConfigs", newConfigFiles.toString());
        }
    }

    protected void setupPropertiesTransformer() {
        String propertiesTransformClassName = this.properties.get("propertiesTransform");
        if (!StringUtils.isNullOrEmpty(propertiesTransformClassName)) {
            try {
                this.propertiesTransformer = (ConnectionPropertiesTransform)Class.forName(propertiesTransformClassName).newInstance();
            }
            catch (CJException | ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                throw ExceptionFactory.createException(InvalidConnectionAttributeException.class, Messages.getString("ConnectionString.9", new Object[]{propertiesTransformClassName, e.toString()}), e);
            }
        }
    }

    protected void expandPropertiesFromConfigFiles(Map<String, String> props) {
        String configFiles = props.get("useConfigs");
        if (!StringUtils.isNullOrEmpty(configFiles)) {
            Properties configProps = ConnectionUrl.getPropertiesFromConfigFiles(configFiles);
            configProps.stringPropertyNames().stream().filter(k -> !props.containsKey(k)).forEach(k -> props.put((String)k, configProps.getProperty((String)k)));
        }
    }

    public static Properties getPropertiesFromConfigFiles(String configFiles) {
        Properties configProps = new Properties();
        for (String configFile : configFiles.split(",")) {
            try (InputStream configAsStream = Driver.class.getResourceAsStream("../configurations/" + configFile + ".properties");){
                if (configAsStream == null) {
                    throw ExceptionFactory.createException(InvalidConnectionAttributeException.class, Messages.getString("ConnectionString.10", new Object[]{configFile}));
                }
                configProps.load(configAsStream);
            }
            catch (IOException e) {
                throw ExceptionFactory.createException(InvalidConnectionAttributeException.class, Messages.getString("ConnectionString.11", new Object[]{configFile}), e);
            }
        }
        return configProps;
    }

    protected void injectPerTypeProperties(Map<String, String> props) {
    }

    protected void collectHostsInfo(ConnectionUrlParser connStrParser) {
        connStrParser.getHosts().stream().map(this::fixHostInfo).forEach(this.hosts::add);
    }

    protected HostInfo fixHostInfo(HostInfo hi) {
        Map<String, String> hostProps = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        hostProps.putAll(this.properties);
        hostProps.putAll(hi.getHostProperties());
        hostProps.put("DBNAME", this.getDatabase());
        hostProps = this.preprocessPerTypeHostProperties(hostProps);
        String host = hostProps.remove("HOST");
        if (!StringUtils.isNullOrEmpty(hi.getHost())) {
            host = hi.getHost();
        } else if (StringUtils.isNullOrEmpty(host)) {
            host = this.getDefaultHost();
        }
        String portAsString = hostProps.remove("PORT");
        int port = hi.getPort();
        if (port == -1 && !StringUtils.isNullOrEmpty(portAsString)) {
            try {
                port = Integer.valueOf(portAsString);
            }
            catch (NumberFormatException e) {
                throw ExceptionFactory.createException(WrongArgumentException.class, Messages.getString("ConnectionString.7", new Object[]{hostProps.get("PORT")}), e);
            }
        }
        if (port == -1) {
            port = this.getDefaultPort();
        }
        String user = hostProps.remove("user");
        if (!StringUtils.isNullOrEmpty(hi.getUser())) {
            user = hi.getUser();
        } else if (StringUtils.isNullOrEmpty(user)) {
            user = this.getDefaultUser();
        }
        String password = hostProps.remove("password");
        if (!StringUtils.isNullOrEmpty(hi.getPassword())) {
            password = hi.getPassword();
        } else if (StringUtils.isNullOrEmpty(password)) {
            password = this.getDefaultPassword();
        }
        this.expandPropertiesFromConfigFiles(hostProps);
        this.fixKeysCase(hostProps);
        this.fixProtocolDependencies(hostProps);
        return this.buildHostInfo(host, port, user, password, hostProps);
    }

    protected Map<String, String> preprocessPerTypeHostProperties(Map<String, String> hostProps) {
        return hostProps;
    }

    public String getDefaultHost() {
        return DEFAULT_HOST;
    }

    public int getDefaultPort() {
        return 3306;
    }

    public String getDefaultUser() {
        String user = this.properties.get("user");
        return StringUtils.isNullOrEmpty(user) ? "" : user;
    }

    public String getDefaultPassword() {
        String password = this.properties.get("password");
        return StringUtils.isNullOrEmpty(password) ? "" : password;
    }

    protected void fixKeysCase(Map<String, String> hostProps) {
        for (String key : Arrays.asList("PROTOCOL", "PATH", "TYPE", "ADDRESS", "PRIORITY")) {
            if (!hostProps.containsKey(key)) continue;
            hostProps.put(key, hostProps.remove(key));
        }
    }

    protected void fixProtocolDependencies(Map<String, String> hostProps) {
        String protocol = hostProps.get("PROTOCOL");
        if (!StringUtils.isNullOrEmpty(protocol) && protocol.equalsIgnoreCase("PIPE")) {
            if (!hostProps.containsKey("socketFactory")) {
                hostProps.put("socketFactory", NamedPipeSocketFactory.class.getName());
            }
            if (hostProps.containsKey("PATH") && !hostProps.containsKey("namedPipePath")) {
                hostProps.put("namedPipePath", hostProps.get("PATH"));
            }
        }
    }

    public Type getType() {
        return this.type;
    }

    @Override
    public String getDatabaseUrl() {
        return this.originalConnStr;
    }

    public String getDatabase() {
        return this.properties.containsKey("DBNAME") ? this.properties.get("DBNAME") : this.originalDatabase;
    }

    public int hostsCount() {
        return this.hosts.size();
    }

    public HostInfo getMainHost() {
        return this.hosts.isEmpty() ? null : this.hosts.get(0);
    }

    public List<HostInfo> getHostsList() {
        return Collections.unmodifiableList(this.hosts);
    }

    public HostInfo getHostOrSpawnIsolated(String hostPortPair) {
        return this.getHostOrSpawnIsolated(hostPortPair, this.hosts);
    }

    public HostInfo getHostOrSpawnIsolated(String hostPortPair, List<HostInfo> hostsList) {
        for (HostInfo hi : hostsList) {
            if (!hostPortPair.equals(hi.getHostPortPair())) continue;
            return hi;
        }
        ConnectionUrlParser.Pair<String, Integer> hostAndPort = ConnectionUrlParser.parseHostPortPair(hostPortPair);
        String host = (String)hostAndPort.left;
        Integer port = (Integer)hostAndPort.right;
        String user = this.getDefaultUser();
        String password = this.getDefaultPassword();
        return this.buildHostInfo(host, port, user, password, this.properties);
    }

    private HostInfo buildHostInfo(String host, int port, String user, String password, Map<String, String> hostProps) {
        if (this.propertiesTransformer != null) {
            Properties props = new Properties();
            props.putAll(hostProps);
            props.setProperty("HOST", host);
            props.setProperty("PORT", String.valueOf(port));
            props.setProperty("user", user);
            props.setProperty("password", password);
            Properties transformedProps = this.propertiesTransformer.transformProperties(props);
            host = transformedProps.getProperty("HOST");
            try {
                port = Integer.parseInt(transformedProps.getProperty("PORT"));
            }
            catch (NumberFormatException e) {
                throw ExceptionFactory.createException(WrongArgumentException.class, Messages.getString("ConnectionString.8", new Object[]{"PORT", transformedProps.getProperty("PORT")}), e);
            }
            user = transformedProps.getProperty("user");
            password = transformedProps.getProperty("password");
            List<String> surplusKeys = Arrays.asList("HOST", "PORT", "user", "password");
            TreeMap<String, String> transformedHostProps = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
            transformedProps.stringPropertyNames().stream().filter(k -> !surplusKeys.contains(k)).forEach(k -> transformedHostProps.put((String)k, transformedProps.getProperty((String)k)));
            hostProps = transformedHostProps;
        }
        return new HostInfo(this, host, port, user, password, hostProps);
    }

    public Map<String, String> getOriginalProperties() {
        return Collections.unmodifiableMap(this.properties);
    }

    public Properties getConnectionArgumentsAsProperties() {
        Properties props = new Properties();
        if (this.properties != null) {
            props.putAll(this.properties);
        }
        return this.propertiesTransformer != null ? this.propertiesTransformer.transformProperties(props) : props;
    }

    public String toString() {
        StringBuilder asStr = new StringBuilder(super.toString());
        asStr.append(String.format(" :: {type: \"%s\", hosts: %s, database: \"%s\", properties: %s, propertiesTransformer: %s}", new Object[]{this.type, this.hosts, this.originalDatabase, this.properties, this.propertiesTransformer}));
        return asStr.toString();
    }

    public static enum Type {
        SINGLE_CONNECTION("jdbc:mysql:", HostsCardinality.SINGLE),
        FAILOVER_CONNECTION("jdbc:mysql:", HostsCardinality.MULTIPLE),
        LOADBALANCE_CONNECTION("jdbc:mysql:loadbalance:", HostsCardinality.ONE_OR_MORE),
        REPLICATION_CONNECTION("jdbc:mysql:replication:", HostsCardinality.ONE_OR_MORE),
        XDEVAPI_SESSION("mysqlx:", HostsCardinality.ONE_OR_MORE);

        private String protocol;
        private HostsCardinality cardinality;

        private Type(String protocol, HostsCardinality cardinality) {
            this.protocol = protocol;
            this.cardinality = cardinality;
        }

        public String getProtocol() {
            return this.protocol;
        }

        public HostsCardinality getCardinality() {
            return this.cardinality;
        }

        public static Type fromValue(String protocol, int n) {
            for (Type t : Type.values()) {
                if (!t.getProtocol().equalsIgnoreCase(protocol) || n >= 0 && !t.getCardinality().assertSize(n)) continue;
                return t;
            }
            if (n < 0) {
                throw ExceptionFactory.createException(WrongArgumentException.class, Messages.getString("ConnectionString.5", new Object[]{protocol}));
            }
            throw ExceptionFactory.createException(WrongArgumentException.class, Messages.getString("ConnectionString.6", new Object[]{protocol, n}));
        }
    }

    public static enum HostsCardinality {
        SINGLE{

            @Override
            public boolean assertSize(int n) {
                return n == 1;
            }
        }
        ,
        MULTIPLE{

            @Override
            public boolean assertSize(int n) {
                return n > 1;
            }
        }
        ,
        ONE_OR_MORE{

            @Override
            public boolean assertSize(int n) {
                return n >= 1;
            }
        };


        public abstract boolean assertSize(int var1);
    }
}

