/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.io.importer.plugin.file;

import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gephi.io.importer.api.ColumnDraft;
import org.gephi.io.importer.api.ContainerLoader;
import org.gephi.io.importer.api.EdgeDraft;
import org.gephi.io.importer.api.ImportUtils;
import org.gephi.io.importer.api.Issue;
import org.gephi.io.importer.api.NodeDraft;
import org.gephi.io.importer.api.Report;
import org.gephi.io.importer.spi.FileImporter;
import org.gephi.utils.longtask.spi.LongTask;
import org.gephi.utils.progress.Progress;
import org.gephi.utils.progress.ProgressTicket;

public class ImporterVNA
implements FileImporter,
LongTask {
    private Reader reader;
    private ContainerLoader container;
    private Report report;
    private ProgressTicket progressTicket;
    private boolean cancel = false;
    private EdgeWidthFunction edgeWidthFunction;
    Pattern pattern;
    private ColumnDraft[] nodeDataColumns;
    private ColumnDraft[] tieDataColumns;
    private String[] nodePropertiesLabels;
    private Attributes[] nodeDataAttributes;
    private Attributes[] tieAttributes;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(ContainerLoader container) {
        this.container = container;
        this.report = new Report();
        LineNumberReader lineReader = ImportUtils.getTextReader((Reader)this.reader);
        try {
            this.importData(lineReader);
        }
        catch (Exception e) {
            this.report.logIssue(new Issue((Throwable)e, Issue.Level.SEVERE));
        }
        finally {
            try {
                lineReader.close();
            }
            catch (IOException iOException) {}
        }
        return !this.cancel;
    }

    private void importData(LineNumberReader reader) throws Exception {
        ArrayList<String> lines = new ArrayList<String>();
        while (reader.ready()) {
            String line = reader.readLine();
            if (line == null || line.isEmpty()) continue;
            lines.add(line);
        }
        State state = State.DEFAULT;
        Progress.start((ProgressTicket)this.progressTicket, (int)lines.size());
        Pattern nodeDataPattern = Pattern.compile("^\\*node data\\s*", 2);
        Pattern nodePropertiesPattern = Pattern.compile("^\\*node properties\\s*", 2);
        Pattern tieDataPattern = Pattern.compile("^\\*tie data\\s*", 2);
        for (String line : lines) {
            if (this.cancel) {
                return;
            }
            if (nodeDataPattern.matcher(line).matches()) {
                state = State.NODE_DATA_DEF;
                continue;
            }
            if (nodePropertiesPattern.matcher(line).matches()) {
                state = State.NODE_PROPERTIES_DEF;
                continue;
            }
            if (tieDataPattern.matcher(line).matches()) {
                state = State.TIE_DATA_DEF;
                continue;
            }
            switch (state) {
                case NODE_DATA_DEF: {
                    String[] nodeDataLabels = line.split("[\\s,]+");
                    this.nodeDataColumns = new ColumnDraft[nodeDataLabels.length];
                    for (int i = 1; i < nodeDataLabels.length; ++i) {
                        this.nodeDataColumns[i] = this.container.addNodeColumn(nodeDataLabels[i], String.class);
                    }
                    state = State.NODE_DATA;
                    break;
                }
                case NODE_PROPERTIES_DEF: {
                    this.nodePropertiesLabels = line.split("[\\s,]+");
                    this.nodeDataAttributes = new Attributes[this.nodePropertiesLabels.length];
                    for (int i = 1; i < this.nodePropertiesLabels.length; ++i) {
                        if (this.nodePropertiesLabels[i].equalsIgnoreCase("x")) {
                            this.nodeDataAttributes[i] = Attributes.NODE_X;
                            continue;
                        }
                        if (this.nodePropertiesLabels[i].equalsIgnoreCase("y")) {
                            this.nodeDataAttributes[i] = Attributes.NODE_Y;
                            continue;
                        }
                        if (this.nodePropertiesLabels[i].equalsIgnoreCase("color")) {
                            this.nodeDataAttributes[i] = Attributes.NODE_COLOR;
                            continue;
                        }
                        if (this.nodePropertiesLabels[i].equalsIgnoreCase("size")) {
                            this.nodeDataAttributes[i] = Attributes.NODE_SIZE;
                            continue;
                        }
                        if (this.nodePropertiesLabels[i].equalsIgnoreCase("shortlabel")) {
                            this.nodeDataAttributes[i] = Attributes.NODE_SHORT_LABEL;
                            continue;
                        }
                        if (this.nodePropertiesLabels[i].equalsIgnoreCase("shape")) {
                            this.nodeDataAttributes[i] = Attributes.NODE_SHAPE;
                            continue;
                        }
                        throw new RuntimeException("Unexpected node parameter at line '" + line + "';");
                    }
                    state = State.NODE_PROPERTIES;
                    break;
                }
                case TIE_DATA_DEF: {
                    String[] tieDataLabels = line.split("[\\s,]+");
                    this.tieDataColumns = new ColumnDraft[tieDataLabels.length];
                    this.tieAttributes = new Attributes[this.tieDataColumns.length];
                    if (this.tieDataColumns.length < 2) {
                        throw new RuntimeException("Edge data labels definition does not contain two necessary variables ('from' and 'to').");
                    }
                    for (int i = 2; i < this.tieDataColumns.length; ++i) {
                        if (tieDataLabels[i].equalsIgnoreCase("strength")) {
                            this.tieAttributes[i] = Attributes.EDGE_STRENGTH;
                            continue;
                        }
                        this.tieAttributes[i] = Attributes.OTHER;
                        this.tieDataColumns[i] = this.container.addEdgeColumn(tieDataLabels[i], String.class);
                    }
                    state = State.TIE_DATA;
                    break;
                }
                case NODE_DATA: {
                    String[] split = this.split(line);
                    if (split.length != this.nodeDataColumns.length) {
                        this.report.logIssue(new Issue("Number of labels and number of data mismatch in: '" + line + "'", Issue.Level.WARNING));
                        break;
                    }
                    this.addNode(split);
                    break;
                }
                case NODE_PROPERTIES: {
                    String[] split = this.split(line);
                    if (split.length != this.nodePropertiesLabels.length) {
                        this.report.logIssue(new Issue("Number of labels and number of data mismatch in: '" + line + "'", Issue.Level.WARNING));
                        break;
                    }
                    this.addNodeProperties(split);
                    break;
                }
                case TIE_DATA: {
                    String[] split = this.split(line);
                    if (split.length != this.tieDataColumns.length) {
                        this.report.logIssue(new Issue("Number of labels and number of data mismatch in: '" + line + "'", Issue.Level.WARNING));
                        break;
                    }
                    this.addEdge(split);
                }
            }
            Progress.progress((ProgressTicket)this.progressTicket);
        }
    }

    private String[] split(String line) {
        if (this.pattern == null) {
            this.pattern = Pattern.compile("[^\\s\"]+|\"([^\"]*)\"");
        }
        ArrayList<String> tokens = new ArrayList<String>();
        Matcher patternMatcher = this.pattern.matcher(line);
        while (patternMatcher.find()) {
            if (patternMatcher.group(1) != null) {
                tokens.add(patternMatcher.group(1));
                continue;
            }
            tokens.add(patternMatcher.group());
        }
        return tokens.toArray(new String[0]);
    }

    private void addNode(String[] nodeData) {
        NodeDraft node;
        String id = nodeData[0];
        if (!this.container.nodeExists(id)) {
            node = this.container.factory().newNodeDraft(id);
            this.container.addNode(node);
        } else {
            node = this.container.getNode(id);
        }
        for (int i = 1; i < this.nodeDataColumns.length; ++i) {
            node.parseAndSetValue(this.nodeDataColumns[i].getId(), nodeData[i]);
        }
    }

    private void addNodeProperties(String[] nodeProperties) {
        NodeDraft node;
        String id = nodeProperties[0];
        if (!this.container.nodeExists(id)) {
            node = this.container.factory().newNodeDraft(id);
            this.container.addNode(node);
        } else {
            node = this.container.getNode(id);
        }
        int i = 0;
        try {
            block9: for (i = 1; i < nodeProperties.length; ++i) {
                switch (this.nodeDataAttributes[i]) {
                    case NODE_X: {
                        node.setX(Float.parseFloat(nodeProperties[i]));
                        continue block9;
                    }
                    case NODE_Y: {
                        node.setY(Float.parseFloat(nodeProperties[i]));
                        continue block9;
                    }
                    case NODE_COLOR: {
                        node.setColor(nodeProperties[i]);
                        continue block9;
                    }
                    case NODE_SIZE: {
                        node.setSize(Float.parseFloat(nodeProperties[i]));
                        continue block9;
                    }
                    case NODE_SHORT_LABEL: {
                        node.setLabel(nodeProperties[i]);
                    }
                }
            }
        }
        catch (NumberFormatException e) {
            this.report.logIssue(new Issue("Error parsing numerical value at '" + nodeProperties[i] + "'.", Issue.Level.WARNING));
        }
    }

    private void addEdge(String[] edgeData) {
        NodeDraft targetNode;
        NodeDraft sourceNode;
        if (!this.container.nodeExists(edgeData[0])) {
            sourceNode = this.container.factory().newNodeDraft(edgeData[0]);
            this.container.addNode(sourceNode);
        } else {
            sourceNode = this.container.getNode(edgeData[0]);
        }
        if (!this.container.nodeExists(edgeData[1])) {
            targetNode = this.container.factory().newNodeDraft(edgeData[1]);
            this.container.addNode(targetNode);
        } else {
            targetNode = this.container.getNode(edgeData[1]);
        }
        EdgeDraft edge = this.container.factory().newEdgeDraft();
        edge.setSource(sourceNode);
        edge.setTarget(targetNode);
        int i = 0;
        try {
            block6: for (i = 2; i < edgeData.length; ++i) {
                switch (this.tieAttributes[i]) {
                    case EDGE_STRENGTH: {
                        float weight = Float.parseFloat(edgeData[i]);
                        if (this.edgeWidthFunction != null) {
                            weight = this.edgeWidthFunction.computeTransformation(weight);
                        }
                        edge.setWeight((double)weight);
                        continue block6;
                    }
                    case OTHER: {
                        edge.parseAndSetValue(this.tieDataColumns[i].getId(), edgeData[i]);
                    }
                }
            }
        }
        catch (NumberFormatException e) {
            this.report.logIssue(new Issue("Error parsing numerical value at '" + edgeData[i] + "'.", Issue.Level.WARNING));
        }
        this.container.addEdge(edge);
    }

    public void setEdgeWidthFunction(EdgeWidthFunction function) {
        this.edgeWidthFunction = function;
    }

    public void setReader(Reader reader) {
        this.reader = reader;
    }

    public ContainerLoader getContainer() {
        return this.container;
    }

    public Report getReport() {
        return this.report;
    }

    public boolean cancel() {
        this.cancel = true;
        return true;
    }

    public void setProgressTicket(ProgressTicket progressTicket) {
        this.progressTicket = progressTicket;
    }

    public static class EdgeWidthFunction {
        public final Function function;
        public final float coefficient;

        public EdgeWidthFunction(Function function, float coefficient) {
            this.function = function;
            this.coefficient = coefficient;
        }

        public float computeTransformation(float value) {
            switch (this.function) {
                case LINEAR: {
                    return value * this.coefficient;
                }
                case LOGARITHMIC: {
                    return (float)Math.log(value + 10.0f);
                }
                case SQUARE_ROOT: {
                    return (float)Math.sqrt(value);
                }
            }
            return 0.0f;
        }

        public String toString() {
            switch (this.function) {
                case LINEAR: {
                    return "Linear";
                }
                case LOGARITHMIC: {
                    return "Logartihmic";
                }
                case SQUARE_ROOT: {
                    return "Square root";
                }
            }
            return null;
        }

        public static enum Function {
            LINEAR,
            SQUARE_ROOT,
            LOGARITHMIC;

        }
    }

    private static enum Attributes {
        OTHER,
        NODE_X,
        NODE_Y,
        NODE_COLOR,
        NODE_SIZE,
        NODE_SHAPE,
        NODE_SHORT_LABEL,
        EDGE_STRENGTH;

    }

    private static enum State {
        DEFAULT,
        NODE_DATA,
        NODE_PROPERTIES,
        TIE_DATA,
        NODE_DATA_DEF,
        NODE_PROPERTIES_DEF,
        TIE_DATA_DEF;

    }
}

