/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.ui.importer.plugin;

import javax.swing.JPanel;
import org.gephi.io.database.drivers.SQLDriver;
import org.gephi.io.importer.api.Database;
import org.gephi.io.importer.plugin.database.ImporterEdgeList;
import org.gephi.io.importer.spi.DatabaseImporter;
import org.gephi.io.importer.spi.Importer;
import org.gephi.io.importer.spi.ImporterUI;
import org.gephi.ui.importer.plugin.EdgeListPanel;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class EdgeListDatabaseImporterUI
implements ImporterUI {
    private EdgeListPanel panel;
    private DatabaseImporter[] importers;

    public void setup(Importer[] importers) {
        this.importers = (DatabaseImporter[])importers;
        if (this.panel == null) {
            this.panel = new EdgeListPanel();
        }
        SQLDriver[] driverArray = new SQLDriver[]{};
        driverArray = Lookup.getDefault().lookupAll(SQLDriver.class).toArray(driverArray);
        this.panel.setSQLDrivers(driverArray);
        this.panel.setup();
    }

    public JPanel getPanel() {
        if (this.panel == null) {
            this.panel = new EdgeListPanel();
        }
        return EdgeListPanel.createValidationPanel(this.panel);
    }

    public void unsetup(boolean update) {
        if (update) {
            Database database = this.panel.getSelectedDatabase();
            for (DatabaseImporter importer : this.importers) {
                importer.setDatabase(database);
            }
        }
        this.panel = null;
        this.importers = null;
    }

    public String getDisplayName() {
        return NbBundle.getMessage(this.getClass(), (String)"EdgeListBuilder.displayName");
    }

    public String getIdentifier() {
        return "edgelist";
    }

    public boolean isUIForImporter(Importer importer) {
        return importer instanceof ImporterEdgeList;
    }
}

