/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.visualization.selection;

import com.jogamp.opengl.GL2;
import com.jogamp.opengl.glu.GLU;
import org.gephi.lib.gleem.linalg.Vecf;
import org.gephi.visualization.VizController;
import org.gephi.visualization.VizModel;
import org.gephi.visualization.api.selection.SelectionArea;
import org.gephi.visualization.api.selection.SelectionManager;
import org.gephi.visualization.apiimpl.GraphDrawable;
import org.gephi.visualization.apiimpl.GraphIO;
import org.gephi.visualization.model.node.NodeModel;

public class Cylinder
implements SelectionArea {
    private final GraphIO graphIO;
    private final GraphDrawable drawable;
    private final SelectionManager selectionManager;
    private final VizModel vizModel;
    private static final float[] RECT_POINT = new float[]{1.0f, 1.0f};
    private final float[] rectangle = new float[2];

    public Cylinder() {
        this.graphIO = VizController.getInstance().getGraphIO();
        this.drawable = VizController.getInstance().getDrawable();
        this.selectionManager = VizController.getInstance().getSelectionManager();
        this.vizModel = VizController.getInstance().getVizModel();
    }

    @Override
    public float[] getSelectionAreaRectancle() {
        float diameter = this.selectionManager.getMouseSelectionDiameter();
        if (diameter == 1.0f) {
            return RECT_POINT;
        }
        float size = this.selectionManager.isMouseSelectionZoomProportionnal() ? diameter * (float)Math.abs(this.drawable.getDraggingMarkerX()) : diameter;
        this.rectangle[0] = size;
        this.rectangle[1] = size;
        return this.rectangle;
    }

    @Override
    public float[] getSelectionAreaCenter() {
        return null;
    }

    @Override
    public boolean mouseTest(Vecf distanceFromMouse, NodeModel nodeModel) {
        float diameter = this.selectionManager.getMouseSelectionDiameter();
        if (diameter == 1.0f) {
            return nodeModel.selectionTest(distanceFromMouse, 0.0f);
        }
        if (this.selectionManager.isMouseSelectionZoomProportionnal()) {
            return nodeModel.selectionTest(distanceFromMouse, diameter);
        }
        return nodeModel.selectionTest(distanceFromMouse, (float)((double)diameter / -this.drawable.getDraggingMarkerX()));
    }

    @Override
    public void drawArea(GL2 gl, GLU glu) {
        float diameter = this.selectionManager.getMouseSelectionDiameter();
        if (diameter != 1.0f) {
            float radius = this.selectionManager.isMouseSelectionZoomProportionnal() ? (float)((double)diameter * Math.abs(this.drawable.getDraggingMarkerX())) : diameter;
            float[] mousePosition = this.graphIO.getMousePosition();
            float vectorX1 = mousePosition[0];
            float vectorY1 = mousePosition[1];
            gl.glColor4f(0.0f, 0.0f, 0.0f, 0.2f);
            gl.glBegin(4);
            for (int i = 0; i <= 360; ++i) {
                double angle = (float)i / 57.29578f;
                float vectorX = mousePosition[0] + radius * (float)Math.sin(angle);
                float vectorY = mousePosition[1] + radius * (float)Math.cos(angle);
                gl.glVertex2f(mousePosition[0], mousePosition[1]);
                gl.glVertex2f(vectorX1, vectorY1);
                gl.glVertex2f(vectorX, vectorY);
                vectorY1 = vectorY;
                vectorX1 = vectorX;
            }
            gl.glEnd();
        }
    }

    @Override
    public boolean isEnabled() {
        return this.selectionManager.isSelectionEnabled();
    }

    @Override
    public boolean blockSelection() {
        return false;
    }
}

