/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.desktop.datalab.tables.popup;

import java.awt.Point;
import java.util.List;
import javax.swing.JPopupMenu;
import org.gephi.datalab.api.DataLaboratoryHelper;
import org.gephi.datalab.spi.nodes.NodesManipulator;
import org.gephi.desktop.datalab.tables.AbstractElementsDataTable;
import org.gephi.desktop.datalab.tables.popup.AbstractPopupAdapter;
import org.gephi.desktop.datalab.utils.PopupMenuUtils;
import org.gephi.graph.api.Column;
import org.gephi.graph.api.Element;
import org.gephi.graph.api.Node;

public class NodesPopupAdapter
extends AbstractPopupAdapter<Node> {
    public NodesPopupAdapter(AbstractElementsDataTable<Node> elementsDataTable) {
        super(elementsDataTable);
    }

    @Override
    protected JPopupMenu createPopup(Point p) {
        List<Node> selectedElements = this.elementsDataTable.getElementsFromSelectedRows();
        Node clickedElement = (Node)this.elementsDataTable.getElementFromRow(this.table.rowAtPoint(p));
        JPopupMenu contextMenu = new JPopupMenu();
        DataLaboratoryHelper dlh = DataLaboratoryHelper.getDefault();
        Integer lastManipulatorType = null;
        for (NodesManipulator em : dlh.getNodesManipulators()) {
            em.setup(selectedElements.toArray(new Node[0]), clickedElement);
            if (lastManipulatorType == null) {
                lastManipulatorType = em.getType();
            }
            if (lastManipulatorType.intValue() != em.getType()) {
                contextMenu.addSeparator();
            }
            lastManipulatorType = em.getType();
            if (!em.isAvailable()) continue;
            contextMenu.add(PopupMenuUtils.createMenuItemFromNodesManipulator(em, clickedElement, selectedElements.toArray(new Node[0])));
        }
        Column column = this.elementsDataTable.getColumnAtIndex(this.table.columnAtPoint(p));
        if (column != null) {
            contextMenu.add(PopupMenuUtils.createSubMenuFromRowColumn((Element)clickedElement, column));
        }
        return contextMenu;
    }
}

