/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.desktop.datalab.utils.componentproviders;

import java.util.ArrayList;
import org.gephi.desktop.datalab.utils.GraphModelProvider;
import org.gephi.desktop.datalab.utils.componentproviders.AbstractSparklinesGraphicsComponentProvider;
import org.gephi.graph.api.Interval;
import org.gephi.graph.api.TimeFormat;
import org.gephi.graph.api.types.IntervalMap;
import org.jdesktop.swingx.JXTable;
import org.joda.time.DateTimeZone;

public class IntervalMapSparklinesGraphicsComponentProvider
extends AbstractSparklinesGraphicsComponentProvider {
    public IntervalMapSparklinesGraphicsComponentProvider(GraphModelProvider graphModelProvider, JXTable table) {
        super(graphModelProvider, table);
    }

    @Override
    public String getTextFromValue(Object value) {
        if (value == null) {
            return null;
        }
        TimeFormat timeFormat = this.graphModelProvider.getGraphModel().getTimeFormat();
        DateTimeZone timeZone = this.graphModelProvider.getGraphModel().getTimeZone();
        return ((IntervalMap)value).toString(timeFormat, timeZone);
    }

    @Override
    public Number[][] getSparklinesXAndYNumbers(Object value) {
        IntervalMap intervalMap = (IntervalMap)value;
        ArrayList<Double> xValues = new ArrayList<Double>();
        ArrayList<Number> yValues = new ArrayList<Number>();
        if (intervalMap == null) {
            return new Number[2][0];
        }
        Interval[] intervals = intervalMap.toKeysArray();
        Object[] values = intervalMap.toValuesArray();
        for (int i = 0; i < intervals.length; ++i) {
            Number n = (Number)values[i];
            if (n == null) continue;
            xValues.add(intervals[i].getLow());
            yValues.add(n);
        }
        return new Number[][]{xValues.toArray(new Number[0]), yValues.toArray(new Number[0])};
    }
}

