/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.updater;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.ResourceBundle;
import org.netbeans.updater.UpdateTracking;
import org.netbeans.updater.XMLUtil;

class Localization {
    private static final String FILE_SEPARATOR = System.getProperty("file.separator");
    private static final String LOCALE_DIR = "modules" + FILE_SEPARATOR + "ext" + FILE_SEPARATOR + "locale";
    private static final String BUNDLE_NAME = "org/netbeans/updater/Bundle";
    private static final String BUNDLE_EXT = ".properties";
    private static final String UPDATER_JAR = "updater";
    private static final String UPDATER_JAR_EXT = ".jar";
    private static ClassLoader brandedLoader = null;
    private static String brandingToken = null;
    private static Map<String, ResourceBundle> bundleCache = new HashMap<String, ResourceBundle>();

    Localization() {
    }

    public static String getBranding() {
        if (brandingToken != null) {
            Localization.init();
        }
        return brandingToken;
    }

    public static String getBrandedString(String key) {
        Localization.init();
        LocaleIterator li = new LocaleIterator(Locale.getDefault());
        while (li.hasNext()) {
            try {
                String brandedString;
                ResourceBundle bundle = Localization.findBrandedBundle((String)li.next());
                if (bundle == null || (brandedString = bundle.getString(key)) == null) continue;
                return brandedString;
            }
            catch (MissingResourceException missingResourceException) {
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ResourceBundle findBrandedBundle(String loc) {
        ResourceBundle bundle = bundleCache.get(loc);
        if (bundle != null) {
            return bundle;
        }
        InputStream is = brandedLoader.getResourceAsStream(BUNDLE_NAME + loc + BUNDLE_EXT);
        if (is != null) {
            ResourceBundle resourceBundle;
            try {
                Properties p = new Properties();
                p.load(is);
                bundle = new PBundle(p, new Locale(""));
                bundleCache.put(loc, bundle);
                resourceBundle = bundle;
            }
            catch (Throwable throwable) {
                try {
                    is.close();
                    throw throwable;
                }
                catch (IOException e) {
                    return null;
                }
            }
            is.close();
            return resourceBundle;
        }
        return null;
    }

    public static URL getBrandedResource(String base, String ext) {
        Localization.init();
        LocaleIterator li = new LocaleIterator(Locale.getDefault());
        while (li.hasNext()) {
            URL url = brandedLoader.getResource(base + li.next() + ext);
            if (url == null) continue;
            return url;
        }
        return null;
    }

    public static InputStream getBrandedResourceAsStream(String base, String ext) {
        Localization.init();
        LocaleIterator li = new LocaleIterator(Locale.getDefault());
        while (li.hasNext()) {
            InputStream is = brandedLoader.getResourceAsStream(base + li.next() + ext);
            if (is == null) continue;
            return is;
        }
        return null;
    }

    public static void setBranding(String branding) {
        brandingToken = branding;
    }

    private static synchronized void init() {
        if (brandingToken == null) {
            brandingToken = Localization.initBranding();
        }
        if (brandedLoader == null) {
            brandedLoader = Localization.class.getClassLoader();
            ArrayList<URL> locJarURLs = new ArrayList<URL>();
            LocaleIterator li = new LocaleIterator(Locale.getDefault());
            while (li.hasNext()) {
                String localeName = li.next().toString();
                for (File cluster : UpdateTracking.clusters(true)) {
                    File locJar = new File(cluster.getPath() + FILE_SEPARATOR + LOCALE_DIR + FILE_SEPARATOR + UPDATER_JAR + localeName + UPDATER_JAR_EXT);
                    if (!locJar.exists()) continue;
                    try {
                        locJarURLs.add(locJar.toURI().toURL());
                    }
                    catch (MalformedURLException malformedURLException) {}
                }
            }
            if (!locJarURLs.isEmpty()) {
                URL[] urls = new URL[locJarURLs.size()];
                locJarURLs.toArray(urls);
                brandedLoader = new URLClassLoader(urls, brandedLoader);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String initBranding() {
        BufferedReader in = null;
        String s = null;
        try {
            if (UpdateTracking.getPlatformDir() == null) {
                String string = s;
                return string;
            }
            File brandf = new File(UpdateTracking.getPlatformDir(), "lib" + FILE_SEPARATOR + "branding");
            in = new BufferedReader(new FileReader(brandf));
            if (in.ready()) {
                XMLUtil.LOG.warning("It's obsolete. Use --branding <branding> instead 'branding' file.");
                s = in.readLine();
            }
        }
        catch (IOException iOException) {
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
        return s;
    }

    private static final class PBundle
    extends ResourceBundle {
        private final Map<String, String> m;
        private final Locale locale;

        public PBundle(Map m, Locale locale) {
            this.m = m;
            this.locale = locale;
        }

        @Override
        public Enumeration<String> getKeys() {
            return Collections.enumeration(this.m.keySet());
        }

        @Override
        protected Object handleGetObject(String key) {
            return this.m.get(key);
        }

        @Override
        public Locale getLocale() {
            return this.locale;
        }
    }

    private static class LocaleIterator
    implements Iterator {
        private boolean defaultInProgress = false;
        private boolean empty = false;
        private Locale locale;
        private Locale initLocale;
        private String current;
        private String branding;

        public LocaleIterator(Locale locale) {
            this.locale = this.initLocale = locale;
            if (locale.equals(Locale.getDefault())) {
                this.defaultInProgress = true;
            }
            this.current = '_' + locale.toString();
            this.branding = brandingToken == null ? null : "_" + brandingToken;
        }

        public Object next() throws NoSuchElementException {
            if (this.current == null) {
                throw new NoSuchElementException();
            }
            String ret = this.branding == null ? this.current : this.branding + this.current;
            int lastUnderbar = this.current.lastIndexOf(95);
            if (lastUnderbar == 0) {
                if (this.empty) {
                    this.reset();
                } else {
                    this.current = "";
                    this.empty = true;
                }
            } else if (lastUnderbar == -1) {
                if (this.defaultInProgress) {
                    this.reset();
                } else {
                    this.locale = Locale.getDefault();
                    this.current = '_' + this.locale.toString();
                    this.defaultInProgress = true;
                }
            } else {
                this.current = this.current.substring(0, lastUnderbar);
            }
            return ret;
        }

        private void reset() {
            if (this.branding != null) {
                this.current = '_' + this.initLocale.toString();
                int idx = this.branding.lastIndexOf(95);
                this.branding = idx == 0 ? null : this.branding.substring(0, idx);
                this.empty = false;
            } else {
                this.current = null;
            }
        }

        @Override
        public boolean hasNext() {
            return this.current != null;
        }

        @Override
        public void remove() throws UnsupportedOperationException {
            throw new UnsupportedOperationException();
        }
    }
}

