/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.ui.components;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.gephi.ui.components.SnippetPanel;
import org.gephi.ui.utils.UIUtils;

public class JSqueezeBoxPanel
extends JPanel {
    private static final Color CP_BACKGROUND_COLOR = UIUtils.getProfilerResultsBackground();
    private final GridBagConstraints gbc = new GridBagConstraints();
    private final JScrollPane scrollPane;
    private final JPanel scrollPanel = new JPanel();
    private final Map<JPanel, SnippetPanel> panelMap = new HashMap<JPanel, SnippetPanel>();

    public JSqueezeBoxPanel() {
        this.setName("JSqueezeBoxPanel");
        this.setLayout(new BorderLayout());
        SnippetPanel.Padding padding = new SnippetPanel.Padding();
        this.scrollPanel.setLayout(new VerticalLayout());
        this.gbc.gridwidth = 0;
        this.gbc.fill = 1;
        this.gbc.weightx = 1.0;
        this.gbc.weighty = 1.0;
        this.scrollPanel.add((Component)padding, this.gbc);
        this.scrollPane = new JScrollPane(this.scrollPanel, 20, 30);
        this.scrollPane.setBorder(BorderFactory.createEmptyBorder());
        this.scrollPane.getViewport().setBackground(CP_BACKGROUND_COLOR);
        this.scrollPane.getVerticalScrollBar().setUnitIncrement(50);
        this.scrollPane.getHorizontalScrollBar().setUnitIncrement(50);
        this.add((Component)this.scrollPane, "Center");
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                JSqueezeBoxPanel.this.scrollPane.getVerticalScrollBar().setBlockIncrement((int)((float)JSqueezeBoxPanel.this.scrollPane.getVerticalScrollBar().getModel().getExtent() * 0.95f));
                JSqueezeBoxPanel.this.scrollPane.getHorizontalScrollBar().setBlockIncrement((int)((float)JSqueezeBoxPanel.this.scrollPane.getHorizontalScrollBar().getModel().getExtent() * 0.95f));
            }
        });
        this.setFocusable(true);
        this.setRequestFocusEnabled(true);
    }

    private void configureSnippetPanel(JPanel panel) {
        panel.setOpaque(true);
        panel.setBackground(CP_BACKGROUND_COLOR);
    }

    public void addPanel(JPanel panel, String name) {
        if (this.panelMap.containsKey(panel)) {
            return;
        }
        panel.setName(name);
        this.configureSnippetPanel(panel);
        SnippetPanel snippetPanel = new SnippetPanel(panel.getName(), panel);
        this.panelMap.put(panel, snippetPanel);
        this.scrollPanel.add((Component)snippetPanel, this.gbc);
        this.scrollPanel.revalidate();
    }

    public void removePanel(JPanel panel) {
        if (!this.panelMap.containsKey(panel)) {
            return;
        }
        SnippetPanel snippetPanel = this.panelMap.remove(panel);
        this.scrollPanel.remove(snippetPanel);
        this.scrollPanel.revalidate();
    }

    public void cleanPanels() {
        for (SnippetPanel snippetPanel : this.panelMap.values()) {
            this.scrollPanel.remove(snippetPanel);
        }
        this.panelMap.clear();
        this.scrollPanel.revalidate();
    }

    public static final class VerticalLayout
    implements LayoutManager {
        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void layoutContainer(Container parent) {
            Insets insets = parent.getInsets();
            int posX = insets.left;
            int posY = insets.top;
            int width = parent.getWidth() - insets.left - insets.right;
            Component[] comps = parent.getComponents();
            for (int i = 0; i < comps.length; ++i) {
                Component comp = comps[i];
                if (!comp.isVisible()) continue;
                int height = comp.getPreferredSize().height;
                if (i == comps.length - 1 && posY + height < parent.getHeight() - insets.bottom) {
                    height = parent.getHeight() - insets.bottom - posY;
                }
                comp.setBounds(posX, posY, width, height);
                posY += height;
            }
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            Dimension d = new Dimension(parent.getInsets().left + parent.getInsets().right, parent.getInsets().top + parent.getInsets().bottom);
            int maxWidth = 0;
            int height = 0;
            Component[] comps = parent.getComponents();
            for (int i = 0; i < comps.length; ++i) {
                Component comp = comps[i];
                if (!comp.isVisible()) continue;
                Dimension size = comp.getMinimumSize();
                maxWidth = Math.max(maxWidth, size.width);
                height += size.height;
            }
            d.width += maxWidth;
            d.height += height;
            return d;
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            Dimension d = new Dimension(parent.getInsets().left + parent.getInsets().right, parent.getInsets().top + parent.getInsets().bottom);
            int maxWidth = 0;
            int height = 0;
            Component[] comps = parent.getComponents();
            for (int i = 0; i < comps.length; ++i) {
                Component comp = comps[i];
                if (!comp.isVisible()) continue;
                Dimension size = comp.getPreferredSize();
                maxWidth = Math.max(maxWidth, size.width);
                height += size.height;
            }
            d.width += maxWidth;
            d.height += height;
            return d;
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }
    }
}

