/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.startup.logging;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.logging.Handler;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.netbeans.core.startup.logging.DispatchingHandler;
import org.netbeans.core.startup.logging.MessagesHandler;

public final class NbLogging {
    public static final PrintStream DEBUG;
    static final Pattern unwantedMessages;

    public static boolean wantsMessage(String s) {
        return unwantedMessages == null || !unwantedMessages.matcher(s).find();
    }

    public static Handler createDispatchHandler(Handler handler, int flushDelay) {
        return new DispatchingHandler(handler, flushDelay);
    }

    public static Handler createMessagesHandler(File dir) {
        return new MessagesHandler(dir);
    }

    public static void close(Handler h) {
        if (h == null) {
            return;
        }
        if (h instanceof DispatchingHandler) {
            ((DispatchingHandler)h).doClose();
        } else {
            h.close();
        }
    }

    static {
        PrintStream _D = null;
        String uMS = System.getProperty("TopLogging.unwantedMessages");
        if (uMS != null || Boolean.getBoolean("TopLogging.DEBUG")) {
            try {
                File debugLog = new File(System.getProperty("java.io.tmpdir"), "TopLogging.log");
                System.err.println("Logging sent to: " + debugLog);
                _D = new PrintStream(new FileOutputStream(debugLog), true);
            }
            catch (FileNotFoundException x) {
                x.printStackTrace();
            }
        }
        DEBUG = _D;
        Pattern uMP = null;
        if (uMS != null) {
            try {
                uMP = Pattern.compile(uMS);
                DEBUG.println("On the lookout for log messages matching: " + uMS);
            }
            catch (PatternSyntaxException x) {
                x.printStackTrace();
            }
        }
        unwantedMessages = uMP;
    }
}

