

  {extends file="main.tpl"}
    <!DOCTYPE head PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd"><head xmlns="http://www.w3.org/1999/xhtml">
  {block name=title}GPSBabel development:FAI/IGC Flight Recorder Data Format (igc){/block}
  {block name=body}{literal}
                       
  <div xmlns="http://www.w3.org/1999/xhtml" class="navheader"><table width="100%" summary="Navigation header"><tr><th colspan="3" align="center">FAI/IGC Flight Recorder Data Format (igc)</th></tr><tr><td width="20%" align="left"><a accesskey="p" href="fmt_f90g.html">Prev</a> </td><th width="60%" align="center">Chapter 3. The Formats</th><td width="20%" align="right"> <a accesskey="n" href="fmt_garmin_fit.html">Next</a></td></tr></table><hr /></div><div xmlns="http://www.w3.org/1999/xhtml" class="section"><div class="titlepage"><div><div><h2 class="title" ><a id="fmt_igc"></a>FAI/IGC Flight Recorder Data Format (igc)</h2></div></div></div><p class="fmtcapshdr">
    This format can...
    </p><div class="itemizedlist"><ul class="itemizedlist" style="list-style-type: disc; "><li class="listitem"><p class="fmtcapsitem">
          read and write tracks
        </p></li><li class="listitem"><p class="fmtcapsitem">
          read and write routes
        </p></li></ul></div><p>This format has the following options: <a class="link" href="fmt_igc.html#fmt_igc_o_timeadj" title="timeadj option">timeadj</a> .</p><p>
FAI/IGC Data File -- Used by the international gliding
community to record gliding flights.  IGC files can be converted to
and from tracks representing recorded flights, and routes representing
task declarations in other formats.
</p><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="fmt_igc_notes"></a>IGC Data Format Notes</h3></div></div></div><p>
Refer to Appendix 1 of 
<a class="ulink" href="http://www.fai.org:81/gliding/gnss/tech_spec_gnss.asp" target="_top">http://www.fai.org:81/gliding/gnss/tech_spec_gnss.asp</a>
for the specification of the IGC data format.
</p><p>
A sample list of software applications that use data in IGC format can be
found at 
<a class="ulink" href="http://www.fai.org:81/gliding/gnss/gnss_analysis_software.pdf" target="_top">http://www.fai.org:81/gliding/gnss/gnss_analysis_software.pdf</a>
</p><p>
GPSBabel can be used to translate data in IGC format to and from various other
formats.
</p><p>
Routes in other formats are used to represent IGC task declarations.
</p><p>
Tracks in other formats are used to represent IGC recorded flights.
</p></div><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="fmt_igc_convto"></a>Converting to IGC format</h3></div></div></div><p>
IGC files generated by GPSBabel will NOT pass security validation tests since
the data they contain cannot be proven to originate from an approved flight
recorder.  For most software applications that use IGC files this is not an
issue but for competition scoring, record and badge claims the generated files
will not be accepted as proof of a flight.
</p><p>
A track stored in another format (GPX for example) representing a recorded
flight can be converted into an IGC file:
</p><p><strong class="userinput"><code>gpsbabel -i gpx -f mytrk.gpx -o igc -F myflight.igc</code></strong></p><p>
If multiple track segments are provided in the input file, the one with the
most points will be used.
</p><p>
A route stored in another format representing a task declaration can be
converted into an IGC file:
</p><p><strong class="userinput"><code>gpsbabel -i gpx -f myrte.gpx -o igc -F mytask.igc</code></strong></p><p>
A route and a track in other formats can be included into a single IGC file:
</p><p><strong class="userinput"><code>gpsbabel -i gpx -f mytrk.gpx -f myrte.gpx -o igc -F myflight.igc</code></strong></p><p>
A similar result can be obtained by downloading the track log and routes
directly from a GPS device connected to a PC.  For example to create an IGC
file from data recorded in a Garmin GPS connected to the first serial port of
a PC running Linux:
</p><p><strong class="userinput"><code>gpsbabel -t -r -i garmin -f /dev/ttyS0 -o igc -F myflight.igc</code></strong></p><p>
For Windows operating systems:
</p><p><strong class="userinput"><code>gpsbabel -t -r -i garmin -f com1 -o igc -F myflight.igc</code></strong></p><p>
A waypoint file in another format containing a waypoint whose short name is
"PILOT" can be merged into an IGC file.  The description field of the waypoint
will be used for the pilot name in the IGC file header:
</p><p><strong class="userinput"><code>gpsbabel -i gpx -f mytrk.gpx -f myrte.gpx -f mywpt.gpx -o igc -F myflight.igc
gpsbabel -w -t -r -i garmin -f /dev/ttyS0 -o igc -F myflight.igc</code></strong></p><p>
Some formats such as GPX allow routes, tracks and waypoints to exist in the
same file and can be used to fully populate an IGC file:
</p><p><strong class="userinput"><code>gpsbabel -i gpx -f myall.gpx -o igc -F myflight.igc</code></strong></p></div><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="fmt_igc_convfrom"></a>Converting from IGC format</h3></div></div></div><p>
Data in an IGC file can be converted into other formats.  For example to
generate OziExplorer files containing tracks representing the recorded
flight (myozi.plt) and routes representing declared tasks (myozi.rte):
</p><p><strong class="userinput"><code>gpsbabel -i igc -f myflight.igc -o ozi -F myozi</code></strong></p><p>
Or to GPX format:
</p><p><strong class="userinput"><code>gpsbabel -i igc -f myflight.igc -o gpx -F myflight.gpx</code></strong></p><p>
Header information from the IGC file will be written to the description field
of the track(s).
</p><p>
If both pressure altitude and GNSS altitude are recorded in the IGC file, two
tracks will be written to the new track file, representing the two altitude
tracks.  The latitude, longitude and timestamps in the tracks will be identical.
</p></div><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="fmt_igc_merge"></a>Merging into IGC format</h3></div></div></div><p>
A route stored in another format can be merged with an existing IGC file that
has no task declaration, to generate a new IGC file with a task declaration:
</p><p><strong class="userinput"><code>gpsbabel -i igc -f myflight.igc -i gpx -f myrte.gpx -o igc -F mynew.igc</code></strong></p><p>
A two dimensional (lat/lon) track recorded during a flight by a GPS receiver
can be merged with a one dimensional (altitude) track recorded during the same
flight by a barograph instrument.  The result is a three dimensional IGC file
representing the flight:
</p><p><strong class="userinput"><code>gpsbabel -i gpx -f baro.gpx -i igc -f my2D.igc -o igc -F my3D.igc</code></strong></p><p>
The same can be achieved by downloading directly from a barograph instrument
supported by GPSBabel.  For example with a Brauniger IQ Comp GPS variometer:
</p><p><strong class="userinput"><code>gpsbabel -i baroiq -f /dev/ttyS0 -i igc -f my2D.igc -o igc,timeadj=auto -F my3D.igc</code></strong></p><p>
or:
</p><p><strong class="userinput"><code>gpsbabel -i baroiq -f com1 -i igc -f my2D.igc -o igc,timeadj=auto -F my3D.igc</code></strong></p><p>
(Documentation contributed by Chris Jones, Aug 2004)
</p></div><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="fmt_igc_o_timeadj"></a><code class="option">timeadj</code> option</h3></div></div></div><p>
      (integer sec or 'auto') Barograph to GPS time diff.
    </p><p>
Sometimes there is a discrepancy between the internal clock in the barograph
instrument and GPS time which can result in the altitude and ground positions
not correlating correctly.  This can be corrected manually by passing the time
difference in seconds between the two time domains through the "timeadj"
parameter.  This can be any positive or negative integer:
</p><p><strong class="userinput"><code>gpsbabel -i gpx -f baro.gpx -i igc -f my2D.igc -o igc,timeadj=27 -F my3D.igc</code></strong></p><p>
GPSBabel can also attempt to deduce the time difference automatically.  This
is done by comparing the time that it thinks that you landed on the GPS track
and the barograph and adjusting accordingly:
</p><p><strong class="userinput"><code>gpsbabel -i gpx -f baro.gpx -i igc -f my2D.igc -o igc,timeadj=auto -F my3D.igc</code></strong></p></div></div><div xmlns="http://www.w3.org/1999/xhtml" class="navfooter"><hr /><table width="100%" summary="Navigation footer"><tr><td width="40%" align="left"><a accesskey="p" href="fmt_f90g.html">Prev</a> </td><td width="20%" align="center"><a accesskey="u" href="The_Formats.html">Up</a></td><td width="40%" align="right"> <a accesskey="n" href="fmt_garmin_fit.html">Next</a></td></tr><tr><td width="40%" align="left" valign="top">F90G Automobile DVR GPS log file (f90g) </td><td width="20%" align="center"><a accesskey="h" href="index.html">Home</a></td><td width="40%" align="right" valign="top"> Flexible and Interoperable Data Transfer (FIT) Activity file (garmin_fit)</td></tr></table></div>
  
      {/literal}{/block}
  