/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.daemon.context;

import org.gradle.api.internal.specs.ExplainingSpec;
import org.gradle.internal.FileUtils;
import org.gradle.launcher.daemon.context.DaemonContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DaemonCompatibilitySpec
implements ExplainingSpec<DaemonContext> {
    private final DaemonContext desiredContext;

    public DaemonCompatibilitySpec(DaemonContext desiredContext) {
        this.desiredContext = desiredContext;
    }

    public boolean isSatisfiedBy(DaemonContext potentialContext) {
        return this.whyUnsatisfied(potentialContext) == null;
    }

    public String whyUnsatisfied(DaemonContext context) {
        if (!this.javaHomeMatches(context)) {
            return "Java home is different.\n" + this.description(context);
        }
        if (!this.daemonOptsMatch(context)) {
            return "At least one daemon option is different.\n" + this.description(context);
        }
        return null;
    }

    private String description(DaemonContext context) {
        return "Wanted: " + this + "\n" + "Actual: " + context + "\n";
    }

    private boolean daemonOptsMatch(DaemonContext potentialContext) {
        return potentialContext.getDaemonOpts().containsAll(this.desiredContext.getDaemonOpts()) && potentialContext.getDaemonOpts().size() == this.desiredContext.getDaemonOpts().size();
    }

    private boolean javaHomeMatches(DaemonContext potentialContext) {
        return FileUtils.canonicalize(potentialContext.getJavaHome()).equals(FileUtils.canonicalize(this.desiredContext.getJavaHome()));
    }

    public String toString() {
        return this.desiredContext.toString();
    }
}

