/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.consumer.connection;

import org.gradle.tooling.internal.adapter.ProtocolToModelAdapter;
import org.gradle.tooling.internal.consumer.connection.HasCompatibilityMapping;
import org.gradle.tooling.internal.consumer.connection.ModelProducer;
import org.gradle.tooling.internal.consumer.converters.GradleBuildConverter;
import org.gradle.tooling.internal.consumer.parameters.ConsumerOperationParameters;
import org.gradle.tooling.internal.gradle.DefaultGradleBuild;
import org.gradle.tooling.model.GradleProject;
import org.gradle.tooling.model.gradle.GradleBuild;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GradleBuildAdapterProducer
implements ModelProducer {
    private final ProtocolToModelAdapter adapter;
    private final ModelProducer delegate;
    private final HasCompatibilityMapping mappingProvider;

    public GradleBuildAdapterProducer(ProtocolToModelAdapter adapter, ModelProducer delegate, HasCompatibilityMapping mappingProvider) {
        this.adapter = adapter;
        this.delegate = delegate;
        this.mappingProvider = mappingProvider;
    }

    @Override
    public <T> T produceModel(Class<T> type, ConsumerOperationParameters operationParameters) {
        if (type.equals(GradleBuild.class)) {
            GradleProject gradleProject = this.delegate.produceModel(GradleProject.class, operationParameters);
            DefaultGradleBuild convert = new GradleBuildConverter().convert(gradleProject);
            return this.mappingProvider.applyCompatibilityMapping(this.adapter.builder(type), operationParameters).build(convert);
        }
        return this.delegate.produceModel(type, operationParameters);
    }
}

