/*
 * Decompiled with CFR 0.152.
 */
package javaslang.collection;

import java.io.Serializable;
import java.util.Comparator;
import java.util.NoSuchElementException;
import java.util.Objects;
import javaslang.collection.Iterator;
import javaslang.collection.RedBlackTree;
import javaslang.collection.SortedSet;
import javaslang.control.Option;

public final class TreeSet<T>
implements Serializable,
SortedSet<T> {
    private final RedBlackTree<T> tree;

    TreeSet(RedBlackTree<T> tree) {
        this.tree = tree;
    }

    public static <T> TreeSet<T> empty(Comparator<? super T> comparator) {
        Objects.requireNonNull(comparator, "comparator is null");
        return new TreeSet<T>(RedBlackTree.empty(comparator));
    }

    @Override
    public TreeSet<T> add(T element) {
        return this.contains(element) ? this : new TreeSet<T>(this.tree.insert(element));
    }

    @Override
    public boolean contains(T element) {
        return this.tree.contains(element);
    }

    @Override
    public T head() {
        if (this.isEmpty()) {
            throw new NoSuchElementException("head of empty TreeSet");
        }
        return this.tree.min().get();
    }

    @Override
    public boolean isEmpty() {
        return this.tree.isEmpty();
    }

    @Override
    public boolean isTraversableAgain() {
        return true;
    }

    @Override
    public Iterator<T> iterator() {
        return this.tree.iterator();
    }

    @Override
    public int length() {
        return this.tree.size();
    }

    @Override
    public Option<T> max() {
        return this.tree.max();
    }

    @Override
    public TreeSet<T> tail() {
        if (this.isEmpty()) {
            throw new UnsupportedOperationException("tail of empty TreeSet");
        }
        return new TreeSet<T>(this.tree.delete(this.tree.min().get()));
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof TreeSet) {
            TreeSet that = (TreeSet)o;
            return this.tree.equals(that.tree);
        }
        return false;
    }

    public int hashCode() {
        return this.tree.hashCode();
    }

    @Override
    public String stringPrefix() {
        return "TreeSet";
    }

    @Override
    public String toString() {
        return this.mkString(this.stringPrefix() + "(", ", ", ")");
    }
}

