/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.lexer;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.lexer.LexerPosition;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;

public abstract class Lexer {
    public abstract void start(@NotNull CharSequence var1, int var2, int var3, int var4);

    public final void start(@NotNull CharSequence buf, int start, int end) {
        if (buf == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buf", "org/jetbrains/kotlin/com/intellij/lexer/Lexer", "start"));
        }
        this.start(buf, start, end, 0);
    }

    public final void start(@NotNull CharSequence buf) {
        if (buf == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buf", "org/jetbrains/kotlin/com/intellij/lexer/Lexer", "start"));
        }
        this.start(buf, 0, buf.length(), 0);
    }

    @NotNull
    public CharSequence getTokenSequence() {
        CharSequence charSequence = this.getBufferSequence().subSequence(this.getTokenStart(), this.getTokenEnd());
        if (charSequence == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/lexer/Lexer", "getTokenSequence"));
        }
        return charSequence;
    }

    @NotNull
    public String getTokenText() {
        String string = this.getTokenSequence().toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/lexer/Lexer", "getTokenText"));
        }
        return string;
    }

    public abstract int getState();

    @Nullable
    public abstract IElementType getTokenType();

    public abstract int getTokenStart();

    public abstract int getTokenEnd();

    public abstract void advance();

    @NotNull
    public abstract LexerPosition getCurrentPosition();

    public abstract void restore(@NotNull LexerPosition var1);

    @NotNull
    public abstract CharSequence getBufferSequence();

    public abstract int getBufferEnd();
}

