/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.openapi.editor;

import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.openapi.editor.event.DocumentListener;
import org.jetbrains.kotlin.com.intellij.openapi.util.UserDataHolder;

public interface Document
extends UserDataHolder {
    public static final Document[] EMPTY_ARRAY = new Document[0];

    @NotNull
    @Contract(pure=true)
    default public String getText() {
        String string = this.getImmutableCharSequence().toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/openapi/editor/Document", "getText"));
        }
        return string;
    }

    @Contract(pure=true)
    @NotNull
    default public CharSequence getCharsSequence() {
        CharSequence charSequence = this.getImmutableCharSequence();
        if (charSequence == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/openapi/editor/Document", "getCharsSequence"));
        }
        return charSequence;
    }

    @NotNull
    @Contract(pure=true)
    public CharSequence getImmutableCharSequence();

    @Contract(pure=true)
    default public int getTextLength() {
        return this.getImmutableCharSequence().length();
    }

    @Contract(pure=true)
    public int getLineCount();

    @Contract(pure=true)
    public int getLineNumber(int var1);

    @Contract(pure=true)
    public int getLineStartOffset(int var1);

    @Contract(pure=true)
    public int getLineEndOffset(int var1);

    public void replaceString(int var1, int var2, @NotNull CharSequence var3);

    @Contract(pure=true)
    public boolean isWritable();

    @Contract(pure=true)
    public long getModificationStamp();

    default public void addDocumentListener(@NotNull DocumentListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "org/jetbrains/kotlin/com/intellij/openapi/editor/Document", "addDocumentListener"));
        }
    }

    default public void removeDocumentListener(@NotNull DocumentListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "org/jetbrains/kotlin/com/intellij/openapi/editor/Document", "removeDocumentListener"));
        }
    }

    default public void setReadOnly(boolean isReadOnly) {
    }

    public void setText(@NotNull CharSequence var1);
}

