/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve;

import java.lang.ref.ReferenceQueue;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.application.ApplicationManager;
import org.jetbrains.kotlin.com.intellij.openapi.components.ServiceManager;
import org.jetbrains.kotlin.com.intellij.openapi.progress.ProgressIndicatorProvider;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.openapi.util.Pair;
import org.jetbrains.kotlin.com.intellij.openapi.util.RecursionGuard;
import org.jetbrains.kotlin.com.intellij.openapi.util.RecursionManager;
import org.jetbrains.kotlin.com.intellij.openapi.util.Trinity;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiPolyVariantReference;
import org.jetbrains.kotlin.com.intellij.psi.PsiReference;
import org.jetbrains.kotlin.com.intellij.psi.ResolveResult;
import org.jetbrains.kotlin.com.intellij.psi.impl.AnyPsiChangeListener;
import org.jetbrains.kotlin.com.intellij.psi.impl.PsiManagerImpl;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiUtilCore;
import org.jetbrains.kotlin.com.intellij.util.containers.ConcurrentWeakKeySoftValueHashMap;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;
import org.jetbrains.kotlin.com.intellij.util.messages.MessageBus;

public class ResolveCache {
    private final ConcurrentMap[] myMaps;
    private final RecursionGuard myGuard;
    private static final Object NULL_RESULT = new Object();
    private static final StrongValueReference NULL_VALUE_REFERENCE = new StrongValueReference(NULL_RESULT);
    private static final StrongValueReference EMPTY_RESOLVE_RESULT = new StrongValueReference(ResolveResult.EMPTY_ARRAY);

    public static ResolveCache getInstance(Project project) {
        ProgressIndicatorProvider.checkCanceled();
        return ServiceManager.getService(project, ResolveCache.class);
    }

    public ResolveCache(@NotNull MessageBus messageBus) {
        if (messageBus == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "messageBus", "org/jetbrains/kotlin/com/intellij/psi/impl/source/resolve/ResolveCache", "<init>"));
        }
        this.myMaps = new ConcurrentMap[8];
        this.myGuard = RecursionManager.createGuard("resolveCache");
        for (int i = 0; i < this.myMaps.length; ++i) {
            this.myMaps[i] = ResolveCache.createWeakMap();
        }
        messageBus.connect().subscribe(PsiManagerImpl.ANY_PSI_CHANGE_TOPIC, new AnyPsiChangeListener.Adapter(){

            @Override
            public void beforePsiChanged(boolean isPhysical) {
                ResolveCache.this.clearCache(isPhysical);
            }
        });
    }

    @NotNull
    private static <K, V> ConcurrentMap<K, V> createWeakMap() {
        ConcurrentWeakKeySoftValueHashMap concurrentWeakKeySoftValueHashMap = new ConcurrentWeakKeySoftValueHashMap<K, V>(100, 0.75f, Runtime.getRuntime().availableProcessors(), ContainerUtil.canonicalStrategy()){

            @Override
            @NotNull
            protected ConcurrentWeakKeySoftValueHashMap.ValueReference<K, V> createValueReference(@NotNull V value, @NotNull ReferenceQueue<V> queue) {
                if (value == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/kotlin/com/intellij/psi/impl/source/resolve/ResolveCache$2", "createValueReference"));
                }
                if (queue == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "queue", "org/jetbrains/kotlin/com/intellij/psi/impl/source/resolve/ResolveCache$2", "createValueReference"));
                }
                ConcurrentWeakKeySoftValueHashMap.ValueReference result2 = value == NULL_RESULT || value instanceof Object[] && ((Object[])value).length == 0 ? ResolveCache.createStrongReference(value) : super.createValueReference(value, queue);
                StrongValueReference strongValueReference = result2;
                if (strongValueReference == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/resolve/ResolveCache$2", "createValueReference"));
                }
                return strongValueReference;
            }

            @Override
            public V get(@NotNull Object key) {
                if (key == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "org/jetbrains/kotlin/com/intellij/psi/impl/source/resolve/ResolveCache$2", "get"));
                }
                Object v = super.get(key);
                return v == NULL_RESULT ? null : (Object)v;
            }
        };
        if (concurrentWeakKeySoftValueHashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/resolve/ResolveCache", "createWeakMap"));
        }
        return concurrentWeakKeySoftValueHashMap;
    }

    public void clearCache(boolean isPhysical) {
        int startIndex;
        for (int i = startIndex = isPhysical ? 0 : 1; i < 2; ++i) {
            for (int j = 0; j < 2; ++j) {
                for (int k = 0; k < 2; ++k) {
                    this.myMaps[i * 4 + j * 2 + k].clear();
                }
            }
        }
    }

    @Nullable
    private <TRef extends PsiReference, TResult> TResult resolve(@NotNull TRef ref, @NotNull AbstractResolver<TRef, TResult> resolver2, boolean needToPreventRecursion, boolean incompleteCode, boolean isPoly, boolean isPhysical) {
        int index2;
        ConcurrentMap<TRef, TResult> map2;
        Object result2;
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "org/jetbrains/kotlin/com/intellij/psi/impl/source/resolve/ResolveCache", "resolve"));
        }
        if (resolver2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolver", "org/jetbrains/kotlin/com/intellij/psi/impl/source/resolve/ResolveCache", "resolve"));
        }
        ProgressIndicatorProvider.checkCanceled();
        if (isPhysical) {
            ApplicationManager.getApplication().assertReadAccessAllowed();
        }
        if ((result2 = (map2 = this.getMap(index2 = ResolveCache.getIndex(isPhysical, incompleteCode, isPoly))).get(ref)) != null) {
            return (TResult)result2;
        }
        RecursionGuard.StackStamp stamp = this.myGuard.markStack();
        Object object = result2 = needToPreventRecursion ? this.myGuard.doPreventingRecursion(Trinity.create(ref, incompleteCode, isPoly), true, () -> {
            if (resolver2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolver", "org/jetbrains/kotlin/com/intellij/psi/impl/source/resolve/ResolveCache", "lambda$resolve$0"));
            }
            if (ref == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "org/jetbrains/kotlin/com/intellij/psi/impl/source/resolve/ResolveCache", "lambda$resolve$0"));
            }
            return resolver2.resolve(ref, incompleteCode);
        }) : resolver2.resolve(ref, incompleteCode);
        if (result2 instanceof ResolveResult) {
            ResolveCache.ensureValidPsi((ResolveResult)result2);
        }
        if (stamp.mayCacheNow()) {
            ResolveCache.cache(ref, map2, result2);
        }
        return (TResult)result2;
    }

    @NotNull
    public <T extends PsiPolyVariantReference> ResolveResult[] resolveWithCaching(@NotNull T ref, @NotNull PolyVariantResolver<T> resolver2, boolean needToPreventRecursion, boolean incompleteCode) {
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "org/jetbrains/kotlin/com/intellij/psi/impl/source/resolve/ResolveCache", "resolveWithCaching"));
        }
        if (resolver2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolver", "org/jetbrains/kotlin/com/intellij/psi/impl/source/resolve/ResolveCache", "resolveWithCaching"));
        }
        ResolveResult[] resolveResultArray = this.resolveWithCaching(ref, resolver2, needToPreventRecursion, incompleteCode, ref.getElement().getContainingFile());
        if (resolveResultArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/resolve/ResolveCache", "resolveWithCaching"));
        }
        return resolveResultArray;
    }

    @NotNull
    public <T extends PsiPolyVariantReference> ResolveResult[] resolveWithCaching(@NotNull T ref, @NotNull PolyVariantResolver<T> resolver2, boolean needToPreventRecursion, boolean incompleteCode, @NotNull PsiFile containingFile) {
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "org/jetbrains/kotlin/com/intellij/psi/impl/source/resolve/ResolveCache", "resolveWithCaching"));
        }
        if (resolver2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolver", "org/jetbrains/kotlin/com/intellij/psi/impl/source/resolve/ResolveCache", "resolveWithCaching"));
        }
        if (containingFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingFile", "org/jetbrains/kotlin/com/intellij/psi/impl/source/resolve/ResolveCache", "resolveWithCaching"));
        }
        ResolveResult[] result2 = (ResolveResult[])this.resolve(ref, resolver2, needToPreventRecursion, incompleteCode, true, containingFile.isPhysical());
        ResolveResult[] resolveResultArray = result2 == null ? ResolveResult.EMPTY_ARRAY : result2;
        if (resolveResultArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/resolve/ResolveCache", "resolveWithCaching"));
        }
        return resolveResultArray;
    }

    @NotNull
    public <T extends PsiPolyVariantReference> ResolveResult[] resolveWithCaching(@NotNull T ref, @NotNull PolyVariantContextResolver<T> resolver2, boolean needToPreventRecursion, boolean incompleteCode, @NotNull PsiFile containingFile) {
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "org/jetbrains/kotlin/com/intellij/psi/impl/source/resolve/ResolveCache", "resolveWithCaching"));
        }
        if (resolver2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolver", "org/jetbrains/kotlin/com/intellij/psi/impl/source/resolve/ResolveCache", "resolveWithCaching"));
        }
        if (containingFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingFile", "org/jetbrains/kotlin/com/intellij/psi/impl/source/resolve/ResolveCache", "resolveWithCaching"));
        }
        ProgressIndicatorProvider.checkCanceled();
        ApplicationManager.getApplication().assertReadAccessAllowed();
        int index2 = ResolveCache.getIndex(containingFile.isPhysical(), incompleteCode, true);
        ConcurrentMap map2 = this.getMap(index2);
        ResolveResult[] result2 = (ResolveResult[])map2.get(ref);
        if (result2 != null) {
            if (result2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/resolve/ResolveCache", "resolveWithCaching"));
            }
            return result2;
        }
        RecursionGuard.StackStamp stamp = this.myGuard.markStack();
        ResolveResult[] resolveResultArray = result2 = needToPreventRecursion ? this.myGuard.doPreventingRecursion(Pair.create(ref, incompleteCode), true, () -> {
            if (resolver2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolver", "org/jetbrains/kotlin/com/intellij/psi/impl/source/resolve/ResolveCache", "lambda$resolveWithCaching$1"));
            }
            if (ref == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "org/jetbrains/kotlin/com/intellij/psi/impl/source/resolve/ResolveCache", "lambda$resolveWithCaching$1"));
            }
            if (containingFile == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingFile", "org/jetbrains/kotlin/com/intellij/psi/impl/source/resolve/ResolveCache", "lambda$resolveWithCaching$1"));
            }
            return resolver2.resolve(ref, containingFile, incompleteCode);
        }) : resolver2.resolve(ref, containingFile, incompleteCode);
        if (result2 != null) {
            for (ResolveResult resolveResult : result2) {
                ResolveCache.ensureValidPsi(resolveResult);
            }
        }
        if (stamp.mayCacheNow()) {
            ResolveCache.cache(ref, map2, result2);
        }
        ResolveResult[] resolveResultArray2 = result2 == null ? ResolveResult.EMPTY_ARRAY : result2;
        if (resolveResultArray2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/resolve/ResolveCache", "resolveWithCaching"));
        }
        return resolveResultArray2;
    }

    private static void ensureValidPsi(ResolveResult resolveResult) {
        PsiElement element = resolveResult.getElement();
        if (element != null) {
            PsiUtilCore.ensureValid(element);
        }
    }

    @Nullable
    public <T extends PsiPolyVariantReference> ResolveResult[] getCachedResults(@NotNull T ref, boolean physical, boolean incompleteCode, boolean isPoly) {
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "org/jetbrains/kotlin/com/intellij/psi/impl/source/resolve/ResolveCache", "getCachedResults"));
        }
        ConcurrentMap map2 = this.getMap(ResolveCache.getIndex(physical, incompleteCode, isPoly));
        return (ResolveResult[])map2.get(ref);
    }

    @Nullable
    public <TRef extends PsiReference, TResult> TResult resolveWithCaching(@NotNull TRef ref, @NotNull AbstractResolver<TRef, TResult> resolver2, boolean needToPreventRecursion, boolean incompleteCode) {
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "org/jetbrains/kotlin/com/intellij/psi/impl/source/resolve/ResolveCache", "resolveWithCaching"));
        }
        if (resolver2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolver", "org/jetbrains/kotlin/com/intellij/psi/impl/source/resolve/ResolveCache", "resolveWithCaching"));
        }
        return this.resolve(ref, resolver2, needToPreventRecursion, incompleteCode, false, ref.getElement().isPhysical());
    }

    @NotNull
    private <TRef extends PsiReference, TResult> ConcurrentMap<TRef, TResult> getMap(int index2) {
        ConcurrentMap concurrentMap = this.myMaps[index2];
        if (concurrentMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/resolve/ResolveCache", "getMap"));
        }
        return concurrentMap;
    }

    private static int getIndex(boolean physical, boolean incompleteCode, boolean isPoly) {
        return (physical ? 0 : 1) * 4 + (incompleteCode ? 0 : 1) * 2 + (isPoly ? 0 : 1);
    }

    private static <TRef extends PsiReference, TResult> void cache(@NotNull TRef ref, @NotNull ConcurrentMap<TRef, TResult> map2, TResult result2) {
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "org/jetbrains/kotlin/com/intellij/psi/impl/source/resolve/ResolveCache", "cache"));
        }
        if (map2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "map", "org/jetbrains/kotlin/com/intellij/psi/impl/source/resolve/ResolveCache", "cache"));
        }
        Object cached = map2.get(ref);
        if (cached != null && cached == result2) {
            return;
        }
        cached = result2 == null ? NULL_RESULT : result2;
        map2.put(ref, cached);
    }

    @NotNull
    private static <K, V> StrongValueReference<K, V> createStrongReference(@NotNull V value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/kotlin/com/intellij/psi/impl/source/resolve/ResolveCache", "createStrongReference"));
        }
        StrongValueReference strongValueReference = value == NULL_RESULT ? NULL_VALUE_REFERENCE : (value == ResolveResult.EMPTY_ARRAY ? EMPTY_RESOLVE_RESULT : new StrongValueReference(value));
        if (strongValueReference == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/resolve/ResolveCache", "createStrongReference"));
        }
        return strongValueReference;
    }

    private static class StrongValueReference<K, V>
    implements ConcurrentWeakKeySoftValueHashMap.ValueReference<K, V> {
        private final V myValue;

        public StrongValueReference(@NotNull V value) {
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/kotlin/com/intellij/psi/impl/source/resolve/ResolveCache$StrongValueReference", "<init>"));
            }
            this.myValue = value;
        }

        @Override
        @NotNull
        public ConcurrentWeakKeySoftValueHashMap.KeyReference<K, V> getKeyReference() {
            throw new UnsupportedOperationException();
        }

        @Override
        public V get() {
            return this.myValue;
        }
    }

    public static interface Resolver
    extends AbstractResolver<PsiReference, PsiElement> {
    }

    public static interface PolyVariantContextResolver<T extends PsiPolyVariantReference> {
        @NotNull
        public ResolveResult[] resolve(@NotNull T var1, @NotNull PsiFile var2, boolean var3);
    }

    public static interface PolyVariantResolver<T extends PsiPolyVariantReference>
    extends AbstractResolver<T, ResolveResult[]> {
        @Override
        @NotNull
        public ResolveResult[] resolve(@NotNull T var1, boolean var2);
    }

    public static interface AbstractResolver<TRef extends PsiReference, TResult> {
        public TResult resolve(@NotNull TRef var1, boolean var2);
    }
}

