/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.source.tree;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.openapi.progress.ProgressIndicator;
import org.jetbrains.kotlin.com.intellij.openapi.util.Comparing;
import org.jetbrains.kotlin.com.intellij.psi.PsiErrorElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.CompositeElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.ForeignLeafPsiElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LazyParseableElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LeafElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.RecursiveTreeElementWalkingVisitor;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.TreeElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.TreeUtil;
import org.jetbrains.kotlin.com.intellij.util.ThreeState;
import org.jetbrains.kotlin.com.intellij.util.diff.ShallowNodeComparator;

public class ASTShallowComparator
implements ShallowNodeComparator<ASTNode, ASTNode> {
    private final ProgressIndicator myIndicator;

    public ASTShallowComparator(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/ASTShallowComparator", "<init>"));
        }
        this.myIndicator = indicator;
    }

    @Override
    @NotNull
    public ThreeState deepEqual(@NotNull ASTNode oldNode, @NotNull ASTNode newNode) {
        if (oldNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldNode", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/ASTShallowComparator", "deepEqual"));
        }
        if (newNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newNode", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/ASTShallowComparator", "deepEqual"));
        }
        ThreeState threeState = this.textMatches(oldNode, newNode);
        if (threeState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/ASTShallowComparator", "deepEqual"));
        }
        return threeState;
    }

    private ThreeState textMatches(ASTNode oldNode, ASTNode newNode) {
        String newText;
        this.myIndicator.checkCanceled();
        String oldText = TreeUtil.isCollapsedChameleon(oldNode) ? oldNode.getText() : null;
        String string = newText = TreeUtil.isCollapsedChameleon(newNode) ? newNode.getText() : null;
        if (oldText != null && newText != null) {
            return oldText.equals(newText) ? ThreeState.YES : ThreeState.UNSURE;
        }
        if (oldText != null) {
            return this.compareTreeToText((TreeElement)newNode, oldText) ? ThreeState.YES : ThreeState.UNSURE;
        }
        if (newText != null) {
            return this.compareTreeToText((TreeElement)oldNode, newText) ? ThreeState.YES : ThreeState.UNSURE;
        }
        if (oldNode instanceof ForeignLeafPsiElement) {
            return newNode instanceof ForeignLeafPsiElement && oldNode.getText().equals(newNode.getText()) ? ThreeState.YES : ThreeState.NO;
        }
        if (newNode instanceof ForeignLeafPsiElement) {
            return ThreeState.NO;
        }
        if (oldNode instanceof LeafElement) {
            return ((LeafElement)oldNode).textMatches(newNode.getText()) ? ThreeState.YES : ThreeState.NO;
        }
        if (newNode instanceof LeafElement) {
            return ((LeafElement)newNode).textMatches(oldNode.getText()) ? ThreeState.YES : ThreeState.NO;
        }
        if (oldNode instanceof PsiErrorElement && newNode instanceof PsiErrorElement) {
            PsiErrorElement e1 = (PsiErrorElement)((Object)oldNode);
            PsiErrorElement e2 = (PsiErrorElement)((Object)newNode);
            if (!Comparing.equal(e1.getErrorDescription(), e2.getErrorDescription())) {
                return ThreeState.NO;
            }
        }
        return ThreeState.UNSURE;
    }

    private boolean compareTreeToText(@NotNull TreeElement root2, final @NotNull String text2) {
        if (root2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/ASTShallowComparator", "compareTreeToText"));
        }
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/ASTShallowComparator", "compareTreeToText"));
        }
        final int[] curOffset = new int[]{0};
        root2.acceptTree(new RecursiveTreeElementWalkingVisitor(){

            @Override
            public void visitLeaf(LeafElement leaf) {
                this.matchText(leaf);
            }

            private void matchText(TreeElement leaf) {
                curOffset[0] = leaf.textMatches(text2, curOffset[0]);
                if (curOffset[0] < 0) {
                    this.stopWalking();
                }
            }

            @Override
            public void visitComposite(CompositeElement composite) {
                ASTShallowComparator.this.myIndicator.checkCanceled();
                if (composite instanceof LazyParseableElement && !((LazyParseableElement)composite).isParsed()) {
                    this.matchText(composite);
                } else {
                    super.visitComposite(composite);
                }
            }
        });
        return curOffset[0] == text2.length();
    }

    @Override
    public boolean typesEqual(@NotNull ASTNode n1, @NotNull ASTNode n2) {
        if (n1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "n1", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/ASTShallowComparator", "typesEqual"));
        }
        if (n2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "n2", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/ASTShallowComparator", "typesEqual"));
        }
        return n1.getElementType() == n2.getElementType();
    }

    @Override
    public boolean hashCodesEqual(@NotNull ASTNode n1, @NotNull ASTNode n2) {
        if (n1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "n1", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/ASTShallowComparator", "hashCodesEqual"));
        }
        if (n2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "n2", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/ASTShallowComparator", "hashCodesEqual"));
        }
        if (n1 instanceof LeafElement && n2 instanceof LeafElement) {
            return this.textMatches(n1, n2) == ThreeState.YES;
        }
        if (n1 instanceof PsiErrorElement && n2 instanceof PsiErrorElement) {
            PsiErrorElement e1 = (PsiErrorElement)((Object)n1);
            PsiErrorElement e2 = (PsiErrorElement)((Object)n2);
            if (!Comparing.equal(e1.getErrorDescription(), e2.getErrorDescription())) {
                return false;
            }
        }
        return ((TreeElement)n1).hc() == ((TreeElement)n2).hc();
    }
}

