/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.java;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.psi.JavaElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.JavaTokenType;
import org.jetbrains.kotlin.com.intellij.psi.PsiBinaryExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.PsiExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiJavaToken;
import org.jetbrains.kotlin.com.intellij.psi.PsiType;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.JavaResolveCache;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.ChildRole;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.ElementType;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.JavaElementType;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.java.ExpressionPsiElement;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.com.intellij.psi.tree.TokenSet;
import org.jetbrains.kotlin.com.intellij.psi.util.TypeConversionUtil;
import org.jetbrains.kotlin.com.intellij.util.Function;

public class PsiBinaryExpressionImpl
extends ExpressionPsiElement
implements PsiBinaryExpression {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.source.tree.java.PsiBinaryExpressionImpl");
    private static final Function<PsiBinaryExpressionImpl, PsiType> MY_TYPE_EVALUATOR = expression2 -> PsiBinaryExpressionImpl.doGetType(expression2);
    private static final TokenSet OUR_OPERATIONS_BIT_SET = TokenSet.create(JavaTokenType.OROR, JavaTokenType.ANDAND, JavaTokenType.OR, JavaTokenType.XOR, JavaTokenType.AND, JavaTokenType.EQEQ, JavaTokenType.NE, JavaTokenType.LT, JavaTokenType.GT, JavaTokenType.LE, JavaTokenType.GE, JavaTokenType.LTLT, JavaTokenType.GTGT, JavaTokenType.GTGTGT, JavaTokenType.PLUS, JavaTokenType.MINUS, JavaTokenType.ASTERISK, JavaTokenType.DIV, JavaTokenType.PERC);

    public PsiBinaryExpressionImpl() {
        this(JavaElementType.BINARY_EXPRESSION);
    }

    protected PsiBinaryExpressionImpl(@NotNull IElementType elementType) {
        if (elementType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementType", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/java/PsiBinaryExpressionImpl", "<init>"));
        }
        super(elementType);
    }

    @Override
    @NotNull
    public PsiExpression getLOperand() {
        PsiExpression psiExpression = (PsiExpression)this.findChildByRoleAsPsiElement(61);
        if (psiExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/java/PsiBinaryExpressionImpl", "getLOperand"));
        }
        return psiExpression;
    }

    @Override
    public PsiExpression getROperand() {
        return (PsiExpression)this.findChildByRoleAsPsiElement(62);
    }

    @Override
    @NotNull
    public PsiJavaToken getOperationSign() {
        PsiJavaToken psiJavaToken = (PsiJavaToken)this.findChildByRoleAsPsiElement(63);
        if (psiJavaToken == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/java/PsiBinaryExpressionImpl", "getOperationSign"));
        }
        return psiJavaToken;
    }

    @Override
    @NotNull
    public IElementType getOperationTokenType() {
        IElementType iElementType = this.getOperationSign().getTokenType();
        if (iElementType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/java/PsiBinaryExpressionImpl", "getOperationTokenType"));
        }
        return iElementType;
    }

    @Override
    public PsiJavaToken getTokenBeforeOperand(@NotNull PsiExpression operand) {
        if (operand == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operand", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/java/PsiBinaryExpressionImpl", "getTokenBeforeOperand"));
        }
        if (operand != this.getROperand()) {
            return null;
        }
        return this.getOperationSign();
    }

    private static PsiType doGetType(PsiBinaryExpressionImpl param) {
        IElementType sign;
        PsiExpression lOperand = param.getLOperand();
        PsiExpression rOperand = param.getROperand();
        if (rOperand == null) {
            return null;
        }
        PsiType rType = rOperand.getType();
        PsiType type2 = TypeConversionUtil.calcTypeForBinaryExpression(null, rType, sign = param.getOperationTokenType(), false);
        if (type2 != TypeConversionUtil.NULL_TYPE) {
            return type2;
        }
        PsiType lType = lOperand.getType();
        return TypeConversionUtil.calcTypeForBinaryExpression(lType, rType, sign, true);
    }

    @Override
    public PsiType getType() {
        return JavaResolveCache.getInstance(this.getProject()).getType(this, MY_TYPE_EVALUATOR);
    }

    @Override
    public ASTNode findChildByRole(int role) {
        LOG.assertTrue(ChildRole.isUnique(role));
        switch (role) {
            default: {
                return null;
            }
            case 61: {
                return this.getFirstChildNode();
            }
            case 62: {
                return ElementType.EXPRESSION_BIT_SET.contains(this.getLastChildNode().getElementType()) ? this.getLastChildNode() : null;
            }
            case 63: 
        }
        return this.findChildByType(OUR_OPERATIONS_BIT_SET);
    }

    @Override
    public int getChildRole(ASTNode child) {
        LOG.assertTrue(child.getTreeParent() == this);
        if (ElementType.EXPRESSION_BIT_SET.contains(child.getElementType())) {
            if (child == this.getFirstChildNode()) {
                return 61;
            }
            if (child == this.getLastChildNode()) {
                return 62;
            }
            return 0;
        }
        if (OUR_OPERATIONS_BIT_SET.contains(child.getElementType())) {
            return 63;
        }
        return 0;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/java/PsiBinaryExpressionImpl", "accept"));
        }
        if (visitor2 instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor2).visitBinaryExpression(this);
        } else {
            visitor2.visitElement(this);
        }
    }

    @Override
    public String toString() {
        return "PsiBinaryExpression:" + this.getText();
    }

    @Override
    @NotNull
    public PsiExpression[] getOperands() {
        PsiExpression[] psiExpressionArray;
        PsiExpression rOperand = this.getROperand();
        if (rOperand == null) {
            PsiExpression[] psiExpressionArray2 = new PsiExpression[1];
            psiExpressionArray = psiExpressionArray2;
            psiExpressionArray2[0] = this.getLOperand();
        } else {
            PsiExpression[] psiExpressionArray3 = new PsiExpression[2];
            psiExpressionArray3[0] = this.getLOperand();
            psiExpressionArray = psiExpressionArray3;
            psiExpressionArray3[1] = rOperand;
        }
        if (psiExpressionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/java/PsiBinaryExpressionImpl", "getOperands"));
        }
        return psiExpressionArray;
    }
}

