/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.scope.processor;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.util.Key;
import org.jetbrains.kotlin.com.intellij.pom.java.LanguageLevel;
import org.jetbrains.kotlin.com.intellij.psi.PsiCallExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiExpressionList;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiMethod;
import org.jetbrains.kotlin.com.intellij.psi.PsiSubstitutor;
import org.jetbrains.kotlin.com.intellij.psi.PsiType;
import org.jetbrains.kotlin.com.intellij.psi.filters.ElementFilter;
import org.jetbrains.kotlin.com.intellij.psi.infos.CandidateInfo;
import org.jetbrains.kotlin.com.intellij.psi.scope.ElementClassFilter;
import org.jetbrains.kotlin.com.intellij.psi.scope.ElementClassHint;
import org.jetbrains.kotlin.com.intellij.psi.scope.JavaScopeProcessorEvent;
import org.jetbrains.kotlin.com.intellij.psi.scope.PsiConflictResolver;
import org.jetbrains.kotlin.com.intellij.psi.scope.PsiScopeProcessor;
import org.jetbrains.kotlin.com.intellij.psi.scope.processor.ConflictFilterProcessor;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiUtil;

public abstract class MethodsProcessor
extends ConflictFilterProcessor
implements ElementClassHint {
    private static final ElementFilter ourFilter = ElementClassFilter.METHOD;
    private boolean myStaticScopeFlag;
    private boolean myIsConstructor;
    protected PsiElement myCurrentFileContext;
    protected PsiClass myAccessClass;
    private PsiExpressionList myArgumentList;
    private PsiType[] myTypeArguments;
    private final LanguageLevel myLanguageLevel;

    public MethodsProcessor(@NotNull PsiConflictResolver[] resolvers, @NotNull List<CandidateInfo> container2, @NotNull PsiElement place, @NotNull PsiFile placeFile) {
        if (resolvers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolvers", "org/jetbrains/kotlin/com/intellij/psi/scope/processor/MethodsProcessor", "<init>"));
        }
        if (container2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "container", "org/jetbrains/kotlin/com/intellij/psi/scope/processor/MethodsProcessor", "<init>"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "org/jetbrains/kotlin/com/intellij/psi/scope/processor/MethodsProcessor", "<init>"));
        }
        if (placeFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "placeFile", "org/jetbrains/kotlin/com/intellij/psi/scope/processor/MethodsProcessor", "<init>"));
        }
        super(null, ourFilter, resolvers, container2, place, placeFile);
        this.myLanguageLevel = PsiUtil.getLanguageLevel(placeFile);
    }

    public PsiExpressionList getArgumentList() {
        return this.myArgumentList;
    }

    public void setArgumentList(@Nullable PsiExpressionList argList) {
        this.myArgumentList = argList;
    }

    @NotNull
    public LanguageLevel getLanguageLevel() {
        LanguageLevel languageLevel = this.myLanguageLevel;
        if (languageLevel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/scope/processor/MethodsProcessor", "getLanguageLevel"));
        }
        return languageLevel;
    }

    public void obtainTypeArguments(@NotNull PsiCallExpression callExpression) {
        if (callExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callExpression", "org/jetbrains/kotlin/com/intellij/psi/scope/processor/MethodsProcessor", "obtainTypeArguments"));
        }
        PsiType[] typeArguments2 = callExpression.getTypeArguments();
        if (typeArguments2.length > 0) {
            this.setTypeArguments(typeArguments2);
        }
    }

    protected void setTypeArguments(PsiType[] typeParameters2) {
        this.myTypeArguments = typeParameters2;
    }

    public PsiType[] getTypeArguments() {
        return this.myTypeArguments;
    }

    public boolean isInStaticScope() {
        return this.myStaticScopeFlag;
    }

    @Override
    public void handleEvent(@NotNull PsiScopeProcessor.Event event, Object associated) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/jetbrains/kotlin/com/intellij/psi/scope/processor/MethodsProcessor", "handleEvent"));
        }
        if (event == JavaScopeProcessorEvent.START_STATIC) {
            this.myStaticScopeFlag = true;
        } else if (JavaScopeProcessorEvent.SET_CURRENT_FILE_CONTEXT.equals(event)) {
            this.myCurrentFileContext = (PsiElement)associated;
        }
    }

    public void setAccessClass(PsiClass accessClass) {
        this.myAccessClass = accessClass;
    }

    public boolean isConstructor() {
        return this.myIsConstructor;
    }

    public void setIsConstructor(boolean myIsConstructor) {
        this.myIsConstructor = myIsConstructor;
    }

    public void forceAddResult(@NotNull PsiMethod method) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "org/jetbrains/kotlin/com/intellij/psi/scope/processor/MethodsProcessor", "forceAddResult"));
        }
        this.add(new CandidateInfo(method, PsiSubstitutor.EMPTY, false, false, this.myCurrentFileContext));
    }

    @Override
    public <T> T getHint(@NotNull Key<T> hintKey) {
        if (hintKey == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hintKey", "org/jetbrains/kotlin/com/intellij/psi/scope/processor/MethodsProcessor", "getHint"));
        }
        if (hintKey == ElementClassHint.KEY) {
            return (T)this;
        }
        return super.getHint(hintKey);
    }

    @Override
    public boolean shouldProcess(ElementClassHint.DeclarationKind kind) {
        return kind == ElementClassHint.DeclarationKind.METHOD;
    }
}

