/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.search;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.openapi.util.NotNullLazyKey;
import org.jetbrains.kotlin.com.intellij.psi.search.EverythingGlobalScope;
import org.jetbrains.kotlin.com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.kotlin.com.intellij.psi.search.ProjectScopeBuilder;

public class ProjectScope {
    private static final NotNullLazyKey<GlobalSearchScope, Project> ALL_SCOPE_KEY = NotNullLazyKey.create("ALL_SCOPE_KEY", project -> ProjectScopeBuilder.getInstance(project).buildAllScope());
    private static final NotNullLazyKey<GlobalSearchScope, Project> PROJECT_SCOPE_KEY = NotNullLazyKey.create("PROJECT_SCOPE_KEY", project -> ProjectScopeBuilder.getInstance(project).buildProjectScope());
    private static final NotNullLazyKey<GlobalSearchScope, Project> LIBRARIES_SCOPE_KEY = NotNullLazyKey.create("LIBRARIES_SCOPE_KEY", project -> ProjectScopeBuilder.getInstance(project).buildLibrariesScope());
    private static final NotNullLazyKey<GlobalSearchScope, Project> CONTENT_SCOPE_KEY = NotNullLazyKey.create("CONTENT_SCOPE_KEY", project -> ProjectScopeBuilder.getInstance(project).buildContentScope());
    private static final NotNullLazyKey<EverythingGlobalScope, Project> EVERYTHING_SCOPE_KEY = NotNullLazyKey.create("EVERYTHING_SCOPE_KEY", project -> new EverythingGlobalScope((Project)project){

        @Override
        @NotNull
        public String getDisplayName() {
            if ("All Places" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/search/ProjectScope$1", "getDisplayName"));
            }
            return "All Places";
        }
    });

    private ProjectScope() {
    }

    @NotNull
    public static GlobalSearchScope getAllScope(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/com/intellij/psi/search/ProjectScope", "getAllScope"));
        }
        GlobalSearchScope globalSearchScope = ALL_SCOPE_KEY.getValue(project);
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/search/ProjectScope", "getAllScope"));
        }
        return globalSearchScope;
    }

    @NotNull
    public static GlobalSearchScope getProjectScope(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/com/intellij/psi/search/ProjectScope", "getProjectScope"));
        }
        GlobalSearchScope globalSearchScope = PROJECT_SCOPE_KEY.getValue(project);
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/search/ProjectScope", "getProjectScope"));
        }
        return globalSearchScope;
    }

    @NotNull
    public static GlobalSearchScope getLibrariesScope(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/com/intellij/psi/search/ProjectScope", "getLibrariesScope"));
        }
        GlobalSearchScope globalSearchScope = LIBRARIES_SCOPE_KEY.getValue(project);
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/search/ProjectScope", "getLibrariesScope"));
        }
        return globalSearchScope;
    }

    @NotNull
    public static GlobalSearchScope getContentScope(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/com/intellij/psi/search/ProjectScope", "getContentScope"));
        }
        GlobalSearchScope globalSearchScope = CONTENT_SCOPE_KEY.getValue(project);
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/search/ProjectScope", "getContentScope"));
        }
        return globalSearchScope;
    }

    @NotNull
    public static GlobalSearchScope getEverythingScope(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/com/intellij/psi/search/ProjectScope", "getEverythingScope"));
        }
        GlobalSearchScope globalSearchScope = EVERYTHING_SCOPE_KEY.getValue(project);
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/search/ProjectScope", "getEverythingScope"));
        }
        return globalSearchScope;
    }
}

