/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util;

import javax.swing.Icon;
import org.jetbrains.kotlin.com.intellij.psi.PsiModifierList;
import org.jetbrains.kotlin.com.intellij.ui.RowIcon;
import org.jetbrains.kotlin.com.intellij.util.PlatformIcons;
import org.jetbrains.kotlin.com.intellij.util.ui.EmptyIcon;

public class VisibilityIcons {
    public static void setVisibilityIcon(PsiModifierList modifierList, RowIcon baseIcon) {
        if (modifierList != null) {
            if (modifierList.hasModifierProperty("public")) {
                VisibilityIcons.setVisibilityIcon(4, baseIcon);
            } else if (modifierList.hasModifierProperty("private")) {
                VisibilityIcons.setVisibilityIcon(1, baseIcon);
            } else if (modifierList.hasModifierProperty("protected")) {
                VisibilityIcons.setVisibilityIcon(3, baseIcon);
            } else if (modifierList.hasModifierProperty("packageLocal")) {
                VisibilityIcons.setVisibilityIcon(2, baseIcon);
            } else {
                EmptyIcon emptyIcon = EmptyIcon.create(PlatformIcons.PUBLIC_ICON);
                baseIcon.setIcon(emptyIcon, 1);
            }
        } else if (PlatformIcons.PUBLIC_ICON != null) {
            EmptyIcon emptyIcon = EmptyIcon.create(PlatformIcons.PUBLIC_ICON);
            baseIcon.setIcon(emptyIcon, 1);
        }
    }

    public static void setVisibilityIcon(int accessLevel, RowIcon baseIcon) {
        Icon icon;
        switch (accessLevel) {
            case 4: {
                icon = PlatformIcons.PUBLIC_ICON;
                break;
            }
            case 3: {
                icon = PlatformIcons.PROTECTED_ICON;
                break;
            }
            case 2: {
                icon = PlatformIcons.PACKAGE_LOCAL_ICON;
                break;
            }
            case 1: {
                icon = PlatformIcons.PRIVATE_ICON;
                break;
            }
            default: {
                if (PlatformIcons.PUBLIC_ICON != null) {
                    icon = EmptyIcon.create(PlatformIcons.PUBLIC_ICON);
                    break;
                }
                return;
            }
        }
        baseIcon.setIcon(icon, 1);
    }
}

