/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.ref;

import java.lang.ref.Reference;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.util.Condition;
import org.jetbrains.kotlin.com.intellij.openapi.util.Key;
import org.jetbrains.kotlin.com.intellij.openapi.util.UserDataHolderEx;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.kotlin.com.intellij.util.PairProcessor;
import org.jetbrains.kotlin.com.intellij.util.ReflectionUtil;
import org.jetbrains.kotlin.com.intellij.util.concurrency.AtomicFieldUpdater;
import org.jetbrains.kotlin.com.intellij.util.containers.FList;
import org.jetbrains.kotlin.com.intellij.util.containers.Queue;
import org.jetbrains.kotlin.gnu.trove.THashMap;
import org.jetbrains.kotlin.gnu.trove.TIntHashSet;
import org.jetbrains.kotlin.gnu.trove.TObjectHashingStrategy;
import sun.misc.Unsafe;

public class DebugReflectionUtil {
    private static final Map<Class, Field[]> allFields = new THashMap<Class, Field[]>(new TObjectHashingStrategy<Class>(){

        @Override
        public int computeHashCode(Class aClass2) {
            return aClass2.getName().hashCode();
        }

        @Override
        public boolean equals(Class o1, Class o2) {
            return o1 == o2;
        }
    });
    private static final Field[] EMPTY_FIELD_ARRAY = new Field[0];
    private static final Method Unsafe_shouldBeInitialized = ReflectionUtil.getDeclaredMethod(Unsafe.class, "shouldBeInitialized", Class.class);
    private static final Key<Boolean> REPORTED_LEAKED = Key.create("REPORTED_LEAKED");

    @NotNull
    private static Field[] getAllFields(@NotNull Class aClass2) {
        if (aClass2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "org/jetbrains/kotlin/com/intellij/util/ref/DebugReflectionUtil", "getAllFields"));
        }
        Field[] cached = allFields.get(aClass2);
        if (cached == null) {
            try {
                Field[] declaredFields = aClass2.getDeclaredFields();
                ArrayList<Field> fields2 = new ArrayList<Field>(declaredFields.length + 5);
                for (Field declaredField : declaredFields) {
                    declaredField.setAccessible(true);
                    Class<?> type2 = declaredField.getType();
                    if (DebugReflectionUtil.isTrivial(type2)) continue;
                    fields2.add(declaredField);
                }
                Class superclass = aClass2.getSuperclass();
                if (superclass != null) {
                    for (Field sup : DebugReflectionUtil.getAllFields(superclass)) {
                        if (fields2.contains(sup)) continue;
                        fields2.add(sup);
                    }
                }
                cached = fields2.isEmpty() ? EMPTY_FIELD_ARRAY : fields2.toArray(new Field[fields2.size()]);
            }
            catch (IncompatibleClassChangeError e) {
                cached = EMPTY_FIELD_ARRAY;
            }
            catch (SecurityException e) {
                cached = EMPTY_FIELD_ARRAY;
            }
            catch (NoClassDefFoundError e) {
                cached = EMPTY_FIELD_ARRAY;
            }
            allFields.put(aClass2, cached);
        }
        if (cached == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/ref/DebugReflectionUtil", "getAllFields"));
        }
        return cached;
    }

    private static boolean isTrivial(@NotNull Class<?> type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/com/intellij/util/ref/DebugReflectionUtil", "isTrivial"));
        }
        return type2.isPrimitive() || type2 == String.class || type2 == Class.class || type2.isArray() && DebugReflectionUtil.isTrivial(type2.getComponentType());
    }

    private static boolean isInitialized(@NotNull Class root2) {
        if (root2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "org/jetbrains/kotlin/com/intellij/util/ref/DebugReflectionUtil", "isInitialized"));
        }
        if (Unsafe_shouldBeInitialized == null) {
            return false;
        }
        boolean isInitialized = false;
        try {
            isInitialized = (Boolean)Unsafe_shouldBeInitialized.invoke((Object)AtomicFieldUpdater.getUnsafe(), root2) == false;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return isInitialized;
    }

    public static boolean walkObjects(int maxDepth, @NotNull Collection<Object> startRoots, @NotNull Class<?> lookFor, @NotNull Condition<Object> shouldExamineValue, @NotNull PairProcessor<Object, BackLink> leakProcessor) {
        if (startRoots == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startRoots", "org/jetbrains/kotlin/com/intellij/util/ref/DebugReflectionUtil", "walkObjects"));
        }
        if (lookFor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lookFor", "org/jetbrains/kotlin/com/intellij/util/ref/DebugReflectionUtil", "walkObjects"));
        }
        if (shouldExamineValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "shouldExamineValue", "org/jetbrains/kotlin/com/intellij/util/ref/DebugReflectionUtil", "walkObjects"));
        }
        if (leakProcessor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "leakProcessor", "org/jetbrains/kotlin/com/intellij/util/ref/DebugReflectionUtil", "walkObjects"));
        }
        TIntHashSet visited2 = new TIntHashSet(8000000);
        Queue<BackLink> toVisit = new Queue<BackLink>(1000000);
        for (Object startRoot : startRoots) {
            toVisit.addLast(new BackLink(startRoot, null, null));
        }
        while (!toVisit.isEmpty()) {
            BackLink backLink = (BackLink)toVisit.pullFirst();
            if (backLink.depth > maxDepth) continue;
            Object value = backLink.value;
            if (lookFor.isAssignableFrom(value.getClass()) && DebugReflectionUtil.markLeaked(value) && !leakProcessor.process(value, backLink)) {
                return false;
            }
            if (!visited2.add(System.identityHashCode(value))) continue;
            DebugReflectionUtil.queueStronglyReferencedValues(toVisit, value, shouldExamineValue, backLink);
        }
        return true;
    }

    private static void queueStronglyReferencedValues(Queue<BackLink> queue, @NotNull Object root2, @NotNull Condition<Object> shouldExamineValue, @NotNull BackLink backLink) {
        if (root2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "org/jetbrains/kotlin/com/intellij/util/ref/DebugReflectionUtil", "queueStronglyReferencedValues"));
        }
        if (shouldExamineValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "shouldExamineValue", "org/jetbrains/kotlin/com/intellij/util/ref/DebugReflectionUtil", "queueStronglyReferencedValues"));
        }
        if (backLink == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "backLink", "org/jetbrains/kotlin/com/intellij/util/ref/DebugReflectionUtil", "queueStronglyReferencedValues"));
        }
        Class<?> rootClass = root2.getClass();
        for (Field field : DebugReflectionUtil.getAllFields(rootClass)) {
            Object value;
            String fieldName = field.getName();
            if (root2 instanceof Reference && "referent".equals(fieldName)) continue;
            try {
                value = field.get(root2);
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            DebugReflectionUtil.queue(value, field, backLink, queue, shouldExamineValue);
        }
        if (rootClass.isArray()) {
            try {
                for (Object object : (Object[])root2) {
                    DebugReflectionUtil.queue(object, null, backLink, queue, shouldExamineValue);
                }
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        if (root2 instanceof Class && DebugReflectionUtil.isInitialized((Class)root2)) {
            for (Field field : DebugReflectionUtil.getAllFields((Class)root2)) {
                if ((field.getModifiers() & 8) == 0) continue;
                try {
                    Object value = field.get(null);
                    DebugReflectionUtil.queue(value, field, backLink, queue, shouldExamineValue);
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
            }
        }
    }

    private static void queue(Object value, Field field, @NotNull BackLink backLink, Queue<BackLink> queue, @NotNull Condition<Object> shouldExamineValue) {
        if (backLink == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "backLink", "org/jetbrains/kotlin/com/intellij/util/ref/DebugReflectionUtil", "queue"));
        }
        if (shouldExamineValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "shouldExamineValue", "org/jetbrains/kotlin/com/intellij/util/ref/DebugReflectionUtil", "queue"));
        }
        if (value == null || DebugReflectionUtil.isTrivial(value.getClass())) {
            return;
        }
        if (shouldExamineValue.value(value)) {
            BackLink newBackLink = new BackLink(value, field, backLink);
            queue.addLast(newBackLink);
        }
    }

    private static boolean markLeaked(Object leaked) {
        return !(leaked instanceof UserDataHolderEx) || ((UserDataHolderEx)leaked).replace(REPORTED_LEAKED, null, Boolean.TRUE);
    }

    public static class BackLink {
        @NotNull
        private final Object value;
        private final Field field;
        private final BackLink backLink;
        private final int depth;

        BackLink(@NotNull Object value, @Nullable Field field, @Nullable BackLink backLink) {
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/kotlin/com/intellij/util/ref/DebugReflectionUtil$BackLink", "<init>"));
            }
            this.value = value;
            this.field = field;
            this.backLink = backLink;
            this.depth = backLink == null ? 0 : backLink.depth + 1;
        }

        public String toString() {
            String result2 = "";
            BackLink backLink = this;
            while (backLink != null) {
                String valueStr;
                Object value = backLink.value;
                try {
                    valueStr = value instanceof FList ? "FList (size=" + ((FList)value).size() + ")" : (value instanceof Collection ? "Collection (size=" + ((Collection)value).size() + ")" : String.valueOf(value));
                    valueStr = StringUtil.first(StringUtil.convertLineSeparators(valueStr, "\\n"), 200, true);
                }
                catch (Throwable e) {
                    valueStr = "(" + e.getMessage() + " while computing .toString())";
                }
                Field field = backLink.field;
                String fieldName = field == null ? "?" : field.getDeclaringClass().getName() + "." + field.getName();
                result2 = result2 + "via '" + fieldName + "'; Value: '" + valueStr + "' of " + value.getClass() + "\n";
                backLink = backLink.backLink;
            }
            return result2;
        }
    }
}

