/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FindClassInModuleKt;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ModalityKt;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.impl.AnonymousFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.impl.LocalVariableAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.impl.LocalVariableDescriptor;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperation;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperator;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsConditional;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsInvocation;
import org.jetbrains.kotlin.js.backend.ast.JsLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNullLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsObjectLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsPropertyInitializer;
import org.jetbrains.kotlin.js.backend.ast.JsReturn;
import org.jetbrains.kotlin.js.backend.ast.JsScope;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.JsStringLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsUnaryOperation;
import org.jetbrains.kotlin.js.backend.ast.JsUnaryOperator;
import org.jetbrains.kotlin.js.backend.ast.metadata.BoxingKind;
import org.jetbrains.kotlin.js.backend.ast.metadata.MetadataProperties;
import org.jetbrains.kotlin.js.backend.ast.metadata.SpecialFunction;
import org.jetbrains.kotlin.js.translate.context.Namer;
import org.jetbrains.kotlin.js.translate.context.TemporaryConstVariable;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.expression.InlineMetadata;
import org.jetbrains.kotlin.js.translate.general.Translation;
import org.jetbrains.kotlin.js.translate.reference.ReferenceTranslator;
import org.jetbrains.kotlin.js.translate.utils.AnnotationsUtils;
import org.jetbrains.kotlin.js.translate.utils.BindingUtils;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.js.translate.utils.JsDescriptorUtils;
import org.jetbrains.kotlin.js.translate.utils.PsiUtils;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtOperationExpression;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtUnaryExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingContextUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.inline.InlineUtil;
import org.jetbrains.kotlin.resolve.source.KotlinSourceElementKt;
import org.jetbrains.kotlin.types.DynamicTypesKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;

public final class TranslationUtils {
    private TranslationUtils() {
    }

    @NotNull
    public static JsPropertyInitializer translateFunctionAsEcma5PropertyDescriptor(@NotNull JsFunction function2, @NotNull FunctionDescriptor descriptor2, @NotNull TranslationContext context) {
        if (function2 == null) {
            TranslationUtils.$$$reportNull$$$0(0);
        }
        if (descriptor2 == null) {
            TranslationUtils.$$$reportNull$$$0(1);
        }
        if (context == null) {
            TranslationUtils.$$$reportNull$$$0(2);
        }
        JsExpression functionExpression = function2;
        if (InlineUtil.isInline(descriptor2)) {
            InlineMetadata metadata2 = InlineMetadata.compose(function2, descriptor2, context);
            PsiElement sourceInfo = KotlinSourceElementKt.getPsi(descriptor2.getSource());
            functionExpression = metadata2.functionWithMetadata(context, sourceInfo);
        }
        if (DescriptorUtils.isExtension(descriptor2) || descriptor2 instanceof PropertyAccessorDescriptor && TranslationUtils.shouldAccessViaFunctions(((PropertyAccessorDescriptor)descriptor2).getCorrespondingProperty())) {
            JsPropertyInitializer jsPropertyInitializer = TranslationUtils.translateExtensionFunctionAsEcma5DataDescriptor(functionExpression, descriptor2, context);
            if (jsPropertyInitializer == null) {
                TranslationUtils.$$$reportNull$$$0(3);
            }
            return jsPropertyInitializer;
        }
        JsStringLiteral getOrSet = new JsStringLiteral(TranslationUtils.getAccessorFunctionName(descriptor2));
        JsPropertyInitializer jsPropertyInitializer = new JsPropertyInitializer(getOrSet, functionExpression);
        if (jsPropertyInitializer == null) {
            TranslationUtils.$$$reportNull$$$0(4);
        }
        return jsPropertyInitializer;
    }

    @NotNull
    private static String getAccessorFunctionName(@NotNull FunctionDescriptor descriptor2) {
        if (descriptor2 == null) {
            TranslationUtils.$$$reportNull$$$0(5);
        }
        boolean isGetter = descriptor2 instanceof PropertyGetterDescriptor || descriptor2 instanceof LocalVariableAccessorDescriptor.Getter;
        String string = isGetter ? "get" : "set";
        if (string == null) {
            TranslationUtils.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    public static JsFunction simpleReturnFunction(@NotNull JsScope functionScope, @NotNull JsExpression returnExpression) {
        if (functionScope == null) {
            TranslationUtils.$$$reportNull$$$0(7);
        }
        if (returnExpression == null) {
            TranslationUtils.$$$reportNull$$$0(8);
        }
        JsReturn jsReturn = new JsReturn(returnExpression);
        jsReturn.setSource(returnExpression.getSource());
        JsFunction jsFunction = new JsFunction(functionScope, new JsBlock((JsStatement)jsReturn), "<simpleReturnFunction>");
        if (jsFunction == null) {
            TranslationUtils.$$$reportNull$$$0(9);
        }
        return jsFunction;
    }

    @NotNull
    private static JsPropertyInitializer translateExtensionFunctionAsEcma5DataDescriptor(@NotNull JsExpression functionExpression, @NotNull FunctionDescriptor descriptor2, @NotNull TranslationContext context) {
        if (functionExpression == null) {
            TranslationUtils.$$$reportNull$$$0(10);
        }
        if (descriptor2 == null) {
            TranslationUtils.$$$reportNull$$$0(11);
        }
        if (context == null) {
            TranslationUtils.$$$reportNull$$$0(12);
        }
        JsObjectLiteral meta = JsAstUtils.createDataDescriptor(functionExpression, ModalityKt.isOverridable(descriptor2), false);
        JsPropertyInitializer jsPropertyInitializer = new JsPropertyInitializer(context.getNameForDescriptor(descriptor2).makeRef(), meta);
        if (jsPropertyInitializer == null) {
            TranslationUtils.$$$reportNull$$$0(13);
        }
        return jsPropertyInitializer;
    }

    @NotNull
    public static JsExpression translateExclForBinaryEqualLikeExpr(@NotNull JsBinaryOperation baseBinaryExpression) {
        if (baseBinaryExpression == null) {
            TranslationUtils.$$$reportNull$$$0(14);
        }
        JsBinaryOperator negatedOperator = TranslationUtils.notOperator(baseBinaryExpression.getOperator());
        assert (negatedOperator != null) : "Can't negate operator: " + baseBinaryExpression.getOperator();
        JsBinaryOperation jsBinaryOperation = new JsBinaryOperation(negatedOperator, baseBinaryExpression.getArg1(), baseBinaryExpression.getArg2());
        if (jsBinaryOperation == null) {
            TranslationUtils.$$$reportNull$$$0(15);
        }
        return jsBinaryOperation;
    }

    public static boolean isEqualLikeOperator(@NotNull JsBinaryOperator operator) {
        if (operator == null) {
            TranslationUtils.$$$reportNull$$$0(16);
        }
        return TranslationUtils.notOperator(operator) != null;
    }

    @Nullable
    private static JsBinaryOperator notOperator(@NotNull JsBinaryOperator operator) {
        if (operator == null) {
            TranslationUtils.$$$reportNull$$$0(17);
        }
        switch (operator) {
            case REF_EQ: {
                return JsBinaryOperator.REF_NEQ;
            }
            case REF_NEQ: {
                return JsBinaryOperator.REF_EQ;
            }
            case EQ: {
                return JsBinaryOperator.NEQ;
            }
            case NEQ: {
                return JsBinaryOperator.EQ;
            }
        }
        return null;
    }

    @NotNull
    public static JsBinaryOperation isNullCheck(@NotNull JsExpression expressionToCheck) {
        if (expressionToCheck == null) {
            TranslationUtils.$$$reportNull$$$0(18);
        }
        JsBinaryOperation jsBinaryOperation = TranslationUtils.nullCheck(expressionToCheck, false);
        if (jsBinaryOperation == null) {
            TranslationUtils.$$$reportNull$$$0(19);
        }
        return jsBinaryOperation;
    }

    @NotNull
    private static JsBinaryOperation isNotNullCheck(@NotNull JsExpression expressionToCheck) {
        if (expressionToCheck == null) {
            TranslationUtils.$$$reportNull$$$0(20);
        }
        JsBinaryOperation jsBinaryOperation = TranslationUtils.nullCheck(expressionToCheck, true);
        if (jsBinaryOperation == null) {
            TranslationUtils.$$$reportNull$$$0(21);
        }
        return jsBinaryOperation;
    }

    @NotNull
    public static JsBinaryOperation nullCheck(@NotNull JsExpression expressionToCheck, boolean isNegated) {
        if (expressionToCheck == null) {
            TranslationUtils.$$$reportNull$$$0(22);
        }
        JsBinaryOperator operator = isNegated ? JsBinaryOperator.NEQ : JsBinaryOperator.EQ;
        JsBinaryOperation jsBinaryOperation = new JsBinaryOperation(operator, expressionToCheck, new JsNullLiteral());
        if (jsBinaryOperation == null) {
            TranslationUtils.$$$reportNull$$$0(23);
        }
        return jsBinaryOperation;
    }

    @NotNull
    public static JsConditional notNullConditional(@NotNull JsExpression expression2, @NotNull JsExpression elseExpression, @NotNull TranslationContext context) {
        JsExpression thenExpression;
        JsBinaryOperation testExpression;
        if (expression2 == null) {
            TranslationUtils.$$$reportNull$$$0(24);
        }
        if (elseExpression == null) {
            TranslationUtils.$$$reportNull$$$0(25);
        }
        if (context == null) {
            TranslationUtils.$$$reportNull$$$0(26);
        }
        if (TranslationUtils.isCacheNeeded(expression2)) {
            TemporaryConstVariable tempVar = context.getOrDeclareTemporaryConstVariable(expression2);
            testExpression = TranslationUtils.isNotNullCheck(tempVar.value());
            thenExpression = tempVar.value();
        } else {
            testExpression = TranslationUtils.isNotNullCheck(expression2);
            thenExpression = expression2;
        }
        JsConditional jsConditional = new JsConditional(testExpression, thenExpression, elseExpression);
        if (jsConditional == null) {
            TranslationUtils.$$$reportNull$$$0(27);
        }
        return jsConditional;
    }

    @NotNull
    public static JsNameRef backingFieldReference(@NotNull TranslationContext context, @NotNull PropertyDescriptor descriptor2) {
        DeclarationDescriptor containingDescriptor;
        JsName backingFieldName;
        if (context == null) {
            TranslationUtils.$$$reportNull$$$0(28);
        }
        if (descriptor2 == null) {
            TranslationUtils.$$$reportNull$$$0(29);
        }
        JsName jsName = backingFieldName = (containingDescriptor = descriptor2.getContainingDeclaration()) instanceof PackageFragmentDescriptor ? context.getInnerNameForDescriptor(descriptor2) : context.getNameForDescriptor(descriptor2);
        if (!JsDescriptorUtils.isSimpleFinalProperty(descriptor2) && !(containingDescriptor instanceof PackageFragmentDescriptor)) {
            backingFieldName = context.getNameForBackingField(descriptor2);
        }
        JsExpression receiver = containingDescriptor instanceof PackageFragmentDescriptor ? null : context.getDispatchReceiver(JsDescriptorUtils.getReceiverParameterForDeclaration(containingDescriptor));
        JsNameRef result2 = new JsNameRef(backingFieldName, receiver);
        MetadataProperties.setType(result2, TranslationUtils.getReturnTypeForCoercion(descriptor2));
        JsNameRef jsNameRef = result2;
        if (jsNameRef == null) {
            TranslationUtils.$$$reportNull$$$0(30);
        }
        return jsNameRef;
    }

    @NotNull
    public static JsExpression assignmentToBackingField(@NotNull TranslationContext context, @NotNull PropertyDescriptor descriptor2, @NotNull JsExpression assignTo) {
        if (context == null) {
            TranslationUtils.$$$reportNull$$$0(31);
        }
        if (descriptor2 == null) {
            TranslationUtils.$$$reportNull$$$0(32);
        }
        if (assignTo == null) {
            TranslationUtils.$$$reportNull$$$0(33);
        }
        JsNameRef backingFieldReference = TranslationUtils.backingFieldReference(context, descriptor2);
        JsBinaryOperation jsBinaryOperation = JsAstUtils.assignment(backingFieldReference, assignTo);
        if (jsBinaryOperation == null) {
            TranslationUtils.$$$reportNull$$$0(34);
        }
        return jsBinaryOperation;
    }

    @Nullable
    public static JsExpression translateInitializerForProperty(@NotNull KtProperty declaration, @NotNull TranslationContext context) {
        if (declaration == null) {
            TranslationUtils.$$$reportNull$$$0(35);
        }
        if (context == null) {
            TranslationUtils.$$$reportNull$$$0(36);
        }
        JsExpression jsInitExpression = null;
        KtExpression initializer2 = declaration.getInitializer();
        if (initializer2 != null) {
            jsInitExpression = Translation.translateAsExpression(initializer2, context);
            KotlinType propertyType = BindingContextUtils.getNotNull(context.bindingContext(), BindingContext.VARIABLE, declaration).getType();
            jsInitExpression = TranslationUtils.coerce(context, jsInitExpression, propertyType);
        }
        return jsInitExpression;
    }

    @NotNull
    public static JsExpression translateBaseExpression(@NotNull TranslationContext context, @NotNull KtUnaryExpression expression2) {
        if (context == null) {
            TranslationUtils.$$$reportNull$$$0(37);
        }
        if (expression2 == null) {
            TranslationUtils.$$$reportNull$$$0(38);
        }
        KtExpression baseExpression = PsiUtils.getBaseExpression(expression2);
        JsExpression jsExpression = Translation.translateAsExpression(baseExpression, context);
        if (jsExpression == null) {
            TranslationUtils.$$$reportNull$$$0(39);
        }
        return jsExpression;
    }

    @NotNull
    public static JsExpression translateLeftExpression(@NotNull TranslationContext context, @NotNull KtBinaryExpression expression2, @NotNull JsBlock block) {
        if (context == null) {
            TranslationUtils.$$$reportNull$$$0(40);
        }
        if (expression2 == null) {
            TranslationUtils.$$$reportNull$$$0(41);
        }
        if (block == null) {
            TranslationUtils.$$$reportNull$$$0(42);
        }
        KtExpression left = expression2.getLeft();
        assert (left != null) : "Binary expression should have a left expression: " + expression2.getText();
        JsExpression jsExpression = Translation.translateAsExpression(left, context, block);
        if (jsExpression == null) {
            TranslationUtils.$$$reportNull$$$0(43);
        }
        return jsExpression;
    }

    @NotNull
    public static JsExpression translateRightExpression(@NotNull TranslationContext context, @NotNull KtBinaryExpression expression2, @NotNull JsBlock block) {
        if (context == null) {
            TranslationUtils.$$$reportNull$$$0(44);
        }
        if (expression2 == null) {
            TranslationUtils.$$$reportNull$$$0(45);
        }
        if (block == null) {
            TranslationUtils.$$$reportNull$$$0(46);
        }
        KtExpression rightExpression = expression2.getRight();
        assert (rightExpression != null) : "Binary expression should have a right expression";
        JsExpression jsExpression = Translation.translateAsExpression(rightExpression, context, block);
        if (jsExpression == null) {
            TranslationUtils.$$$reportNull$$$0(47);
        }
        return jsExpression;
    }

    public static boolean hasCorrespondingFunctionIntrinsic(@NotNull TranslationContext context, @NotNull KtOperationExpression expression2) {
        CallableDescriptor operationDescriptor;
        if (context == null) {
            TranslationUtils.$$$reportNull$$$0(48);
        }
        if (expression2 == null) {
            TranslationUtils.$$$reportNull$$$0(49);
        }
        if ((operationDescriptor = BindingUtils.getCallableDescriptorForOperationExpression(context.bindingContext(), expression2)) == null || !(operationDescriptor instanceof FunctionDescriptor)) {
            return true;
        }
        KotlinType returnType = operationDescriptor.getReturnType();
        if (returnType != null && (KotlinBuiltIns.isChar(returnType) || KotlinBuiltIns.isLong(returnType) || KotlinBuiltIns.isInt(returnType))) {
            return false;
        }
        return context.intrinsics().getFunctionIntrinsic((FunctionDescriptor)operationDescriptor).exists();
    }

    @NotNull
    public static List<JsExpression> generateInvocationArguments(@NotNull JsExpression receiver, @NotNull List<? extends JsExpression> arguments2) {
        if (receiver == null) {
            TranslationUtils.$$$reportNull$$$0(50);
        }
        if (arguments2 == null) {
            TranslationUtils.$$$reportNull$$$0(51);
        }
        ArrayList<JsExpression> argumentList2 = new ArrayList<JsExpression>(1 + arguments2.size());
        argumentList2.add(receiver);
        argumentList2.addAll(arguments2);
        ArrayList<JsExpression> arrayList = argumentList2;
        if (arrayList == null) {
            TranslationUtils.$$$reportNull$$$0(52);
        }
        return arrayList;
    }

    public static boolean isCacheNeeded(@NotNull JsExpression expression2) {
        if (expression2 == null) {
            TranslationUtils.$$$reportNull$$$0(53);
        }
        if (expression2 instanceof JsLiteral.JsValueLiteral) {
            return false;
        }
        if (expression2 instanceof JsNameRef && ((JsNameRef)expression2).getQualifier() == null) {
            return false;
        }
        if (expression2 instanceof JsBinaryOperation) {
            JsBinaryOperation operation = (JsBinaryOperation)expression2;
            JsBinaryOperator operator = operation.getOperator();
            if (operator.isAssignment() || operator == JsBinaryOperator.COMMA) {
                return true;
            }
            return TranslationUtils.isCacheNeeded(operation.getArg1()) || TranslationUtils.isCacheNeeded(operation.getArg2());
        }
        if (expression2 instanceof JsUnaryOperation) {
            JsUnaryOperation operation = (JsUnaryOperation)expression2;
            JsUnaryOperator operator = operation.getOperator();
            switch (operator) {
                case BIT_NOT: 
                case NEG: 
                case POS: 
                case NOT: 
                case TYPEOF: 
                case VOID: {
                    return TranslationUtils.isCacheNeeded(operation.getArg());
                }
            }
            return true;
        }
        return true;
    }

    @NotNull
    public static JsConditional sure(@NotNull JsExpression expression2, @NotNull TranslationContext context) {
        JsName name;
        JsInvocation throwNPE;
        JsConditional ensureNotNull;
        JsExpression thenExpression;
        if (expression2 == null) {
            TranslationUtils.$$$reportNull$$$0(54);
        }
        if (context == null) {
            TranslationUtils.$$$reportNull$$$0(55);
        }
        if ((thenExpression = (ensureNotNull = TranslationUtils.notNullConditional(expression2, throwNPE = new JsInvocation(Namer.throwNPEFunctionRef(), new JsExpression[0]), context)).getThenExpression()) instanceof JsNameRef && (name = ((JsNameRef)thenExpression).getName()) != null) {
            context.associateExpressionToLazyValue(ensureNotNull, new TemporaryConstVariable(name, ensureNotNull));
        }
        JsConditional jsConditional = ensureNotNull;
        if (jsConditional == null) {
            TranslationUtils.$$$reportNull$$$0(56);
        }
        return jsConditional;
    }

    public static boolean isSimpleNameExpressionNotDelegatedLocalVar(@Nullable KtExpression expression2, @NotNull TranslationContext context) {
        if (context == null) {
            TranslationUtils.$$$reportNull$$$0(57);
        }
        if (!(expression2 instanceof KtSimpleNameExpression)) {
            return false;
        }
        DeclarationDescriptor descriptor2 = context.bindingContext().get(BindingContext.REFERENCE_TARGET, (KtSimpleNameExpression)expression2);
        return !(descriptor2 instanceof LocalVariableDescriptor && ((LocalVariableDescriptor)descriptor2).isDelegated() || descriptor2 instanceof PropertyDescriptor && TranslationUtils.propertyAccessedByFunctionsInternally((PropertyDescriptor)descriptor2, context));
    }

    private static boolean propertyAccessedByFunctionsInternally(@NotNull PropertyDescriptor p, @NotNull TranslationContext context) {
        if (p == null) {
            TranslationUtils.$$$reportNull$$$0(58);
        }
        if (context == null) {
            TranslationUtils.$$$reportNull$$$0(59);
        }
        return !JsDescriptorUtils.isSimpleFinalProperty(p) && context.isFromCurrentModule(p) || TranslationUtils.shouldAccessViaFunctions(p);
    }

    public static boolean shouldAccessViaFunctions(@NotNull CallableDescriptor descriptor2) {
        if (descriptor2 == null) {
            TranslationUtils.$$$reportNull$$$0(60);
        }
        if (descriptor2 instanceof PropertyDescriptor) {
            return TranslationUtils.shouldAccessViaFunctions((PropertyDescriptor)descriptor2);
        }
        if (descriptor2 instanceof PropertyAccessorDescriptor) {
            return TranslationUtils.shouldAccessViaFunctions(((PropertyAccessorDescriptor)descriptor2).getCorrespondingProperty());
        }
        return false;
    }

    private static boolean shouldAccessViaFunctions(@NotNull PropertyDescriptor property) {
        if (property == null) {
            TranslationUtils.$$$reportNull$$$0(61);
        }
        if (AnnotationsUtils.hasJsNameInAccessors(property)) {
            return true;
        }
        for (PropertyDescriptor propertyDescriptor : property.getOverriddenDescriptors()) {
            if (!TranslationUtils.shouldAccessViaFunctions(propertyDescriptor)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static JsExpression translateContinuationArgument(@NotNull TranslationContext context) {
        if (context == null) {
            TranslationUtils.$$$reportNull$$$0(62);
        }
        VariableDescriptor continuationDescriptor = TranslationUtils.getEnclosingContinuationParameter(context);
        JsExpression jsExpression = ReferenceTranslator.translateAsValueReference(continuationDescriptor, context);
        if (jsExpression == null) {
            TranslationUtils.$$$reportNull$$$0(63);
        }
        return jsExpression;
    }

    @NotNull
    private static VariableDescriptor getEnclosingContinuationParameter(@NotNull TranslationContext context) {
        VariableDescriptor result2;
        if (context == null) {
            TranslationUtils.$$$reportNull$$$0(64);
        }
        if ((result2 = context.getContinuationParameterDescriptor()) == null) {
            assert (context.getParent() != null);
            result2 = TranslationUtils.getEnclosingContinuationParameter(context.getParent());
        }
        VariableDescriptor variableDescriptor = result2;
        if (variableDescriptor == null) {
            TranslationUtils.$$$reportNull$$$0(65);
        }
        return variableDescriptor;
    }

    @NotNull
    public static ClassDescriptor getCoroutineBaseClass(@NotNull TranslationContext context) {
        if (context == null) {
            TranslationUtils.$$$reportNull$$$0(66);
        }
        FqName className2 = DescriptorUtils.COROUTINES_PACKAGE_FQ_NAME.child(Name.identifier("CoroutineImpl"));
        ClassDescriptor descriptor2 = FindClassInModuleKt.findClassAcrossModuleDependencies(context.getCurrentModule(), ClassId.topLevel(className2));
        assert (descriptor2 != null);
        ClassDescriptor classDescriptor = descriptor2;
        if (classDescriptor == null) {
            TranslationUtils.$$$reportNull$$$0(67);
        }
        return classDescriptor;
    }

    @NotNull
    public static PropertyDescriptor getCoroutineProperty(@NotNull TranslationContext context, @NotNull String name) {
        if (context == null) {
            TranslationUtils.$$$reportNull$$$0(68);
        }
        if (name == null) {
            TranslationUtils.$$$reportNull$$$0(69);
        }
        PropertyDescriptor propertyDescriptor = TranslationUtils.getCoroutineBaseClass(context).getUnsubstitutedMemberScope().getContributedVariables(Name.identifier(name), NoLookupLocation.FROM_DESERIALIZATION).iterator().next();
        if (propertyDescriptor == null) {
            TranslationUtils.$$$reportNull$$$0(70);
        }
        return propertyDescriptor;
    }

    @NotNull
    public static FunctionDescriptor getCoroutineDoResumeFunction(@NotNull TranslationContext context) {
        if (context == null) {
            TranslationUtils.$$$reportNull$$$0(71);
        }
        FunctionDescriptor functionDescriptor = TranslationUtils.getCoroutineBaseClass(context).getUnsubstitutedMemberScope().getContributedFunctions(Name.identifier("doResume"), NoLookupLocation.FROM_DESERIALIZATION).iterator().next();
        if (functionDescriptor == null) {
            TranslationUtils.$$$reportNull$$$0(72);
        }
        return functionDescriptor;
    }

    public static boolean isOverridableFunctionWithDefaultParameters(@NotNull FunctionDescriptor descriptor2) {
        if (descriptor2 == null) {
            TranslationUtils.$$$reportNull$$$0(73);
        }
        return DescriptorUtilsKt.hasOrInheritsParametersWithDefaultValue(descriptor2) && !(descriptor2 instanceof ConstructorDescriptor) && descriptor2.getContainingDeclaration() instanceof ClassDescriptor && ModalityKt.isOverridable(descriptor2);
    }

    @NotNull
    public static KotlinType getReturnTypeForCoercion(@NotNull CallableDescriptor descriptor2) {
        if (descriptor2 == null) {
            TranslationUtils.$$$reportNull$$$0(74);
        }
        if (FunctionTypesKt.getFunctionalClassKind(descriptor2 = descriptor2.getOriginal()) != null || descriptor2 instanceof AnonymousFunctionDescriptor) {
            SimpleType simpleType2 = DescriptorUtils.getContainingModule(descriptor2).getBuiltIns().getAnyType();
            if (simpleType2 == null) {
                TranslationUtils.$$$reportNull$$$0(75);
            }
            return simpleType2;
        }
        Collection<? extends CallableDescriptor> overridden = descriptor2.getOverriddenDescriptors();
        if (overridden.isEmpty()) {
            KotlinType kotlinType = descriptor2.getReturnType() != null ? descriptor2.getReturnType() : DescriptorUtils.getContainingModule(descriptor2).getBuiltIns().getAnyType();
            if (kotlinType == null) {
                TranslationUtils.$$$reportNull$$$0(76);
            }
            return kotlinType;
        }
        Set typesFromOverriddenCallables = overridden.stream().map(TranslationUtils::getReturnTypeForCoercion).collect(Collectors.toSet());
        KotlinType kotlinType = typesFromOverriddenCallables.size() == 1 ? (KotlinType)typesFromOverriddenCallables.iterator().next() : DescriptorUtils.getContainingModule(descriptor2).getBuiltIns().getAnyType();
        if (kotlinType == null) {
            TranslationUtils.$$$reportNull$$$0(77);
        }
        return kotlinType;
    }

    @NotNull
    public static KotlinType getDispatchReceiverTypeForCoercion(@NotNull CallableDescriptor descriptor2) {
        if (descriptor2 == null) {
            TranslationUtils.$$$reportNull$$$0(78);
        }
        if ((descriptor2 = descriptor2.getOriginal()).getDispatchReceiverParameter() == null) {
            throw new IllegalArgumentException("This method can only be used for class members; given descriptor is not a member of a class " + descriptor2);
        }
        Collection<? extends CallableDescriptor> overridden = descriptor2.getOverriddenDescriptors();
        if (overridden.isEmpty()) {
            KotlinType kotlinType = descriptor2.getDispatchReceiverParameter().getType();
            if (kotlinType == null) {
                TranslationUtils.$$$reportNull$$$0(79);
            }
            return kotlinType;
        }
        Set typesFromOverriddenCallables = overridden.stream().map(TranslationUtils::getDispatchReceiverTypeForCoercion).collect(Collectors.toSet());
        KotlinType kotlinType = typesFromOverriddenCallables.size() == 1 ? (KotlinType)typesFromOverriddenCallables.iterator().next() : DescriptorUtils.getContainingModule(descriptor2).getBuiltIns().getAnyType();
        if (kotlinType == null) {
            TranslationUtils.$$$reportNull$$$0(80);
        }
        return kotlinType;
    }

    @NotNull
    public static JsExpression coerce(@NotNull TranslationContext context, @NotNull JsExpression value, @NotNull KotlinType to) {
        if (context == null) {
            TranslationUtils.$$$reportNull$$$0(81);
        }
        if (value == null) {
            TranslationUtils.$$$reportNull$$$0(82);
        }
        if (to == null) {
            TranslationUtils.$$$reportNull$$$0(83);
        }
        if (DynamicTypesKt.isDynamic(to)) {
            JsExpression jsExpression = value;
            if (jsExpression == null) {
                TranslationUtils.$$$reportNull$$$0(84);
            }
            return jsExpression;
        }
        KotlinType from = MetadataProperties.getType(value);
        if (from == null) {
            from = context.getCurrentModule().getBuiltIns().getAnyType();
        }
        if (from.equals(to)) {
            JsExpression jsExpression = value;
            if (jsExpression == null) {
                TranslationUtils.$$$reportNull$$$0(85);
            }
            return jsExpression;
        }
        if (KotlinBuiltIns.isCharOrNullableChar(to)) {
            if (!KotlinBuiltIns.isCharOrNullableChar(from) && !(value instanceof JsNullLiteral)) {
                value = TranslationUtils.boxedCharToChar(context, value);
            }
        } else if (KotlinBuiltIns.isUnit(to)) {
            if (!KotlinBuiltIns.isUnit(from)) {
                value = TranslationUtils.unitToVoid(value);
            }
        } else if (KotlinBuiltIns.isCharOrNullableChar(from)) {
            if (!KotlinBuiltIns.isCharOrNullableChar(to) && !(value instanceof JsNullLiteral)) {
                value = TranslationUtils.charToBoxedChar(context, value);
            }
        } else if (KotlinBuiltIns.isUnit(from) && !KotlinBuiltIns.isUnit(to) && !MetadataProperties.isUnit(value)) {
            ClassDescriptor unit = context.getCurrentModule().getBuiltIns().getUnit();
            JsExpression unitRef = ReferenceTranslator.translateAsValueReference(unit, context);
            value = JsAstUtils.newSequence(Arrays.asList(value, unitRef));
        }
        MetadataProperties.setType(value, to);
        JsExpression jsExpression = value;
        if (jsExpression == null) {
            TranslationUtils.$$$reportNull$$$0(86);
        }
        return jsExpression;
    }

    @NotNull
    private static JsExpression unitToVoid(@NotNull JsExpression expression2) {
        JsBinaryOperation binary;
        if (expression2 == null) {
            TranslationUtils.$$$reportNull$$$0(87);
        }
        if (expression2 instanceof JsBinaryOperation && (binary = (JsBinaryOperation)expression2).getOperator() == JsBinaryOperator.COMMA && MetadataProperties.isUnit(binary.getArg2())) {
            JsExpression jsExpression = binary.getArg1();
            if (jsExpression == null) {
                TranslationUtils.$$$reportNull$$$0(88);
            }
            return jsExpression;
        }
        JsExpression jsExpression = expression2;
        if (jsExpression == null) {
            TranslationUtils.$$$reportNull$$$0(89);
        }
        return jsExpression;
    }

    @NotNull
    public static JsExpression charToBoxedChar(@NotNull TranslationContext context, @NotNull JsExpression expression2) {
        if (context == null) {
            TranslationUtils.$$$reportNull$$$0(90);
        }
        if (expression2 == null) {
            TranslationUtils.$$$reportNull$$$0(91);
        }
        if (expression2 instanceof JsInvocation) {
            JsInvocation invocation = (JsInvocation)expression2;
            BoxingKind existingKind = MetadataProperties.getBoxing(invocation);
            switch (existingKind) {
                case UNBOXING: {
                    JsExpression jsExpression = invocation.getArguments().get(0);
                    if (jsExpression == null) {
                        TranslationUtils.$$$reportNull$$$0(92);
                    }
                    return jsExpression;
                }
                case BOXING: {
                    JsExpression jsExpression = expression2;
                    if (jsExpression == null) {
                        TranslationUtils.$$$reportNull$$$0(93);
                    }
                    return jsExpression;
                }
            }
        }
        JsInvocation result2 = TranslationUtils.invokeSpecialFunction(context, SpecialFunction.TO_BOXED_CHAR, expression2);
        result2.setSource(expression2.getSource());
        MetadataProperties.setBoxing(result2, BoxingKind.BOXING);
        JsInvocation jsInvocation = result2;
        if (jsInvocation == null) {
            TranslationUtils.$$$reportNull$$$0(94);
        }
        return jsInvocation;
    }

    @NotNull
    private static JsExpression boxedCharToChar(@NotNull TranslationContext context, @NotNull JsExpression expression2) {
        if (context == null) {
            TranslationUtils.$$$reportNull$$$0(95);
        }
        if (expression2 == null) {
            TranslationUtils.$$$reportNull$$$0(96);
        }
        if (expression2 instanceof JsInvocation) {
            JsInvocation invocation = (JsInvocation)expression2;
            BoxingKind existingKind = MetadataProperties.getBoxing(invocation);
            switch (existingKind) {
                case BOXING: {
                    JsExpression jsExpression = invocation.getArguments().get(0);
                    if (jsExpression == null) {
                        TranslationUtils.$$$reportNull$$$0(97);
                    }
                    return jsExpression;
                }
                case UNBOXING: {
                    JsExpression jsExpression = expression2;
                    if (jsExpression == null) {
                        TranslationUtils.$$$reportNull$$$0(98);
                    }
                    return jsExpression;
                }
            }
        }
        JsInvocation result2 = TranslationUtils.invokeSpecialFunction(context, SpecialFunction.UNBOX_CHAR, expression2);
        result2.setSource(expression2.getSource());
        MetadataProperties.setBoxing(result2, BoxingKind.UNBOXING);
        JsInvocation jsInvocation = result2;
        if (jsInvocation == null) {
            TranslationUtils.$$$reportNull$$$0(99);
        }
        return jsInvocation;
    }

    @NotNull
    private static JsInvocation invokeSpecialFunction(@NotNull TranslationContext context, @NotNull SpecialFunction function2, JsExpression ... arguments2) {
        if (context == null) {
            TranslationUtils.$$$reportNull$$$0(100);
        }
        if (function2 == null) {
            TranslationUtils.$$$reportNull$$$0(101);
        }
        if (arguments2 == null) {
            TranslationUtils.$$$reportNull$$$0(102);
        }
        JsName name = context.getNameForSpecialFunction(function2);
        JsInvocation jsInvocation = new JsInvocation((JsExpression)JsAstUtils.pureFqn(name, null), arguments2);
        if (jsInvocation == null) {
            TranslationUtils.$$$reportNull$$$0(103);
        }
        return jsInvocation;
    }

    @NotNull
    public static String getTagForSpecialFunction(@NotNull SpecialFunction specialFunction) {
        if (specialFunction == null) {
            TranslationUtils.$$$reportNull$$$0(104);
        }
        String string = "special:" + specialFunction.name();
        if (string == null) {
            TranslationUtils.$$$reportNull$$$0(105);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 9: 
            case 13: 
            case 15: 
            case 19: 
            case 21: 
            case 23: 
            case 27: 
            case 30: 
            case 34: 
            case 39: 
            case 43: 
            case 47: 
            case 52: 
            case 56: 
            case 63: 
            case 65: 
            case 67: 
            case 70: 
            case 72: 
            case 75: 
            case 76: 
            case 77: 
            case 79: 
            case 80: 
            case 84: 
            case 85: 
            case 86: 
            case 88: 
            case 89: 
            case 92: 
            case 93: 
            case 94: 
            case 97: 
            case 98: 
            case 99: 
            case 103: 
            case 105: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 9: 
            case 13: 
            case 15: 
            case 19: 
            case 21: 
            case 23: 
            case 27: 
            case 30: 
            case 34: 
            case 39: 
            case 43: 
            case 47: 
            case 52: 
            case 56: 
            case 63: 
            case 65: 
            case 67: 
            case 70: 
            case 72: 
            case 75: 
            case 76: 
            case 77: 
            case 79: 
            case 80: 
            case 84: 
            case 85: 
            case 86: 
            case 88: 
            case 89: 
            case 92: 
            case 93: 
            case 94: 
            case 97: 
            case 98: 
            case 99: 
            case 103: 
            case 105: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 1: 
            case 5: 
            case 11: 
            case 29: 
            case 32: 
            case 60: 
            case 73: 
            case 74: 
            case 78: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 2: 
            case 12: 
            case 26: 
            case 28: 
            case 31: 
            case 36: 
            case 37: 
            case 40: 
            case 44: 
            case 48: 
            case 55: 
            case 57: 
            case 59: 
            case 62: 
            case 64: 
            case 66: 
            case 68: 
            case 71: 
            case 81: 
            case 90: 
            case 95: 
            case 100: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 9: 
            case 13: 
            case 15: 
            case 19: 
            case 21: 
            case 23: 
            case 27: 
            case 30: 
            case 34: 
            case 39: 
            case 43: 
            case 47: 
            case 52: 
            case 56: 
            case 63: 
            case 65: 
            case 67: 
            case 70: 
            case 72: 
            case 75: 
            case 76: 
            case 77: 
            case 79: 
            case 80: 
            case 84: 
            case 85: 
            case 86: 
            case 88: 
            case 89: 
            case 92: 
            case 93: 
            case 94: 
            case 97: 
            case 98: 
            case 99: 
            case 103: 
            case 105: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/js/translate/utils/TranslationUtils";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionScope";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "returnExpression";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionExpression";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseBinaryExpression";
                break;
            }
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operator";
                break;
            }
            case 18: 
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expressionToCheck";
                break;
            }
            case 24: 
            case 38: 
            case 41: 
            case 45: 
            case 49: 
            case 53: 
            case 54: 
            case 87: 
            case 91: 
            case 96: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elseExpression";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "assignTo";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaration";
                break;
            }
            case 42: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "block";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "receiver";
                break;
            }
            case 51: 
            case 102: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arguments";
                break;
            }
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "p";
                break;
            }
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 82: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 83: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
            case 104: {
                objectArray2 = objectArray3;
                objectArray3[0] = "specialFunction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/js/translate/utils/TranslationUtils";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "translateFunctionAsEcma5PropertyDescriptor";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getAccessorFunctionName";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "simpleReturnFunction";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "translateExtensionFunctionAsEcma5DataDescriptor";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "translateExclForBinaryEqualLikeExpr";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "isNullCheck";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "isNotNullCheck";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "nullCheck";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "notNullConditional";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "backingFieldReference";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "assignmentToBackingField";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "translateBaseExpression";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "translateLeftExpression";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "translateRightExpression";
                break;
            }
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "generateInvocationArguments";
                break;
            }
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "sure";
                break;
            }
            case 63: {
                objectArray = objectArray2;
                objectArray2[1] = "translateContinuationArgument";
                break;
            }
            case 65: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnclosingContinuationParameter";
                break;
            }
            case 67: {
                objectArray = objectArray2;
                objectArray2[1] = "getCoroutineBaseClass";
                break;
            }
            case 70: {
                objectArray = objectArray2;
                objectArray2[1] = "getCoroutineProperty";
                break;
            }
            case 72: {
                objectArray = objectArray2;
                objectArray2[1] = "getCoroutineDoResumeFunction";
                break;
            }
            case 75: 
            case 76: 
            case 77: {
                objectArray = objectArray2;
                objectArray2[1] = "getReturnTypeForCoercion";
                break;
            }
            case 79: 
            case 80: {
                objectArray = objectArray2;
                objectArray2[1] = "getDispatchReceiverTypeForCoercion";
                break;
            }
            case 84: 
            case 85: 
            case 86: {
                objectArray = objectArray2;
                objectArray2[1] = "coerce";
                break;
            }
            case 88: 
            case 89: {
                objectArray = objectArray2;
                objectArray2[1] = "unitToVoid";
                break;
            }
            case 92: 
            case 93: 
            case 94: {
                objectArray = objectArray2;
                objectArray2[1] = "charToBoxedChar";
                break;
            }
            case 97: 
            case 98: 
            case 99: {
                objectArray = objectArray2;
                objectArray2[1] = "boxedCharToChar";
                break;
            }
            case 103: {
                objectArray = objectArray2;
                objectArray2[1] = "invokeSpecialFunction";
                break;
            }
            case 105: {
                objectArray = objectArray2;
                objectArray2[1] = "getTagForSpecialFunction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "translateFunctionAsEcma5PropertyDescriptor";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 9: 
            case 13: 
            case 15: 
            case 19: 
            case 21: 
            case 23: 
            case 27: 
            case 30: 
            case 34: 
            case 39: 
            case 43: 
            case 47: 
            case 52: 
            case 56: 
            case 63: 
            case 65: 
            case 67: 
            case 70: 
            case 72: 
            case 75: 
            case 76: 
            case 77: 
            case 79: 
            case 80: 
            case 84: 
            case 85: 
            case 86: 
            case 88: 
            case 89: 
            case 92: 
            case 93: 
            case 94: 
            case 97: 
            case 98: 
            case 99: 
            case 103: 
            case 105: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getAccessorFunctionName";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "simpleReturnFunction";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "translateExtensionFunctionAsEcma5DataDescriptor";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "translateExclForBinaryEqualLikeExpr";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isEqualLikeOperator";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "notOperator";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isNullCheck";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "isNotNullCheck";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "nullCheck";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "notNullConditional";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "backingFieldReference";
                break;
            }
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "assignmentToBackingField";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "translateInitializerForProperty";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "translateBaseExpression";
                break;
            }
            case 40: 
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "translateLeftExpression";
                break;
            }
            case 44: 
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "translateRightExpression";
                break;
            }
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "hasCorrespondingFunctionIntrinsic";
                break;
            }
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "generateInvocationArguments";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "isCacheNeeded";
                break;
            }
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "sure";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "isSimpleNameExpressionNotDelegatedLocalVar";
                break;
            }
            case 58: 
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "propertyAccessedByFunctionsInternally";
                break;
            }
            case 60: 
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "shouldAccessViaFunctions";
                break;
            }
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "translateContinuationArgument";
                break;
            }
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "getEnclosingContinuationParameter";
                break;
            }
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "getCoroutineBaseClass";
                break;
            }
            case 68: 
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "getCoroutineProperty";
                break;
            }
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "getCoroutineDoResumeFunction";
                break;
            }
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "isOverridableFunctionWithDefaultParameters";
                break;
            }
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "getReturnTypeForCoercion";
                break;
            }
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "getDispatchReceiverTypeForCoercion";
                break;
            }
            case 81: 
            case 82: 
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "coerce";
                break;
            }
            case 87: {
                objectArray = objectArray;
                objectArray[2] = "unitToVoid";
                break;
            }
            case 90: 
            case 91: {
                objectArray = objectArray;
                objectArray[2] = "charToBoxedChar";
                break;
            }
            case 95: 
            case 96: {
                objectArray = objectArray;
                objectArray[2] = "boxedCharToChar";
                break;
            }
            case 100: 
            case 101: 
            case 102: {
                objectArray = objectArray;
                objectArray[2] = "invokeSpecialFunction";
                break;
            }
            case 104: {
                objectArray = objectArray;
                objectArray[2] = "getTagForSpecialFunction";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 9: 
            case 13: 
            case 15: 
            case 19: 
            case 21: 
            case 23: 
            case 27: 
            case 30: 
            case 34: 
            case 39: 
            case 43: 
            case 47: 
            case 52: 
            case 56: 
            case 63: 
            case 65: 
            case 67: 
            case 70: 
            case 72: 
            case 75: 
            case 76: 
            case 77: 
            case 79: 
            case 80: 
            case 84: 
            case 85: 
            case 86: 
            case 88: 
            case 89: 
            case 92: 
            case 93: 
            case 94: 
            case 97: 
            case 98: 
            case 99: 
            case 103: 
            case 105: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

