/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.transport;

import java.io.IOException;
import java.util.PriorityQueue;
import org.simpleframework.transport.Packet;
import org.simpleframework.transport.PacketException;
import org.simpleframework.transport.Segment;

class SegmentBuilder {
    private final Queue compact = new Queue();
    private final Queue ready = new Queue();
    private final int limit;

    public SegmentBuilder() {
        this(20480);
    }

    public SegmentBuilder(int limit) {
        this.limit = limit;
    }

    public boolean isReference() {
        for (Packet packet : this.ready) {
            if (!packet.isReference()) continue;
            return true;
        }
        return false;
    }

    public Segment build() throws IOException {
        Packet packet = (Packet)this.ready.peek();
        if (packet == null) {
            return null;
        }
        return this.create(packet);
    }

    private Segment create(Packet packet) throws IOException {
        int length = packet.length();
        if (length <= 0) {
            packet.close();
            this.ready.poll();
            return this.build();
        }
        return new Segment(packet, this.ready);
    }

    public Segment build(Packet packet) throws IOException {
        boolean update = this.ready.offer(packet);
        long sequence = packet.sequence();
        if (!update) {
            throw new PacketException("Could not add packet " + sequence);
        }
        return this.build();
    }

    public void compact() throws IOException {
        Packet packet = (Packet)this.ready.peek();
        while (packet != null) {
            packet = (Packet)this.ready.poll();
            if (packet == null) continue;
            this.compact.offer(packet);
        }
        this.extract();
    }

    private void extract() throws IOException {
        int count = this.limit;
        for (Packet packet : this.compact) {
            int length = packet.length();
            if (length <= count) {
                packet = packet.extract();
                count -= length;
            }
            if (packet == null) continue;
            this.ready.offer(packet);
        }
        this.compact.clear();
    }

    public int length() throws IOException {
        int count = 0;
        for (Packet packet : this.ready) {
            count += packet.length();
        }
        return count;
    }

    public void close() throws IOException {
        for (Packet packet : this.ready) {
            packet.close();
        }
        this.ready.clear();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Queue
    extends PriorityQueue<Packet> {
    }
}

