/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.collection.internal;

import org.gradle.api.Action;
import org.gradle.api.NamedDomainObjectCollection;
import org.gradle.api.Namer;
import org.gradle.api.Transformer;
import org.gradle.api.internal.plugins.DslObject;
import org.gradle.internal.Factory;
import org.gradle.model.internal.core.ModelActionRole;
import org.gradle.model.internal.core.ModelPath;
import org.gradle.model.internal.core.ModelReference;
import org.gradle.model.internal.core.ModelRegistration;
import org.gradle.model.internal.core.ModelRegistrations;
import org.gradle.model.internal.core.MutableModelNode;
import org.gradle.model.internal.core.rule.describe.ModelRuleDescriptor;
import org.gradle.model.internal.core.rule.describe.SimpleModelRuleDescriptor;
import org.gradle.model.internal.type.ModelType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BridgedCollections {
    private static final Logger LOGGER = LoggerFactory.getLogger(BridgedCollections.class);

    private BridgedCollections() {
    }

    public static <I, C extends NamedDomainObjectCollection<I>> ModelRegistrations.Builder registration(ModelReference<C> containerReference, final Transformer<? extends C, ? super MutableModelNode> containerFactory, final Namer<? super I> namer, String descriptor, final Transformer<String, String> itemDescriptorGenerator) {
        final ModelPath containerPath = containerReference.getPath();
        final ModelType containerType = containerReference.getType();
        assert (containerPath != null) : "container reference path cannot be null";
        return ModelRegistrations.of((ModelPath)containerPath).action(ModelActionRole.Create, (Action)new Action<MutableModelNode>(){

            public void execute(final MutableModelNode containerNode) {
                NamedDomainObjectCollection container = (NamedDomainObjectCollection)containerFactory.transform((Object)containerNode);
                containerNode.setPrivateData(containerType, (Object)container);
                container.all(new Action<I>(){

                    public void execute(I item) {
                        final String name = namer.determineName(item);
                        if (!containerNode.isMutable()) {
                            LOGGER.debug("Ignoring element '{}' added to '{}' after it is closed.", (Object)containerPath, (Object)name);
                            return;
                        }
                        if (!containerNode.hasLink(name)) {
                            ModelRegistration itemRegistration = ModelRegistrations.unmanagedInstanceOf((ModelReference)ModelReference.of((ModelPath)containerPath.child(name), (Class)new DslObject(item).getDeclaredType()), new ExtractFromParentContainer(name, containerType)).descriptor((ModelRuleDescriptor)new SimpleModelRuleDescriptor((Factory)new Factory<String>(){

                                public String create() {
                                    return (String)itemDescriptorGenerator.transform((Object)name);
                                }
                            })).build();
                            containerNode.addLink(itemRegistration);
                        }
                    }
                });
                container.whenObjectRemoved(new Action<I>(){

                    public void execute(I item) {
                        String name = namer.determineName(item);
                        containerNode.removeLink(name);
                    }
                });
            }
        }).descriptor(descriptor);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ExtractFromParentContainer<I, C extends NamedDomainObjectCollection<I>>
    implements Transformer<I, MutableModelNode> {
        private final String name;
        private final ModelType<C> containerType;

        public ExtractFromParentContainer(String name, ModelType<C> containerType) {
            this.name = name;
            this.containerType = containerType;
        }

        public I transform(MutableModelNode modelNode) {
            return (I)((NamedDomainObjectCollection)modelNode.getParent().getPrivateData(this.containerType)).getByName(this.name);
        }
    }
}

