/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.toolchain.internal.msvcpp;

import java.io.File;
import net.rubygrapefruit.platform.WindowsRegistry;
import org.gradle.nativeplatform.toolchain.internal.msvcpp.AbstractWindowsKitComponentLocator;
import org.gradle.nativeplatform.toolchain.internal.msvcpp.WindowsKitWindowsSdk;
import org.gradle.util.VersionNumber;

public class WindowsKitWindowsSdkLocator
extends AbstractWindowsKitComponentLocator<WindowsKitWindowsSdk> {
    private static final String COMPONENT_NAME = "um";
    private static final String DISPLAY_NAME = "Windows SDK";
    private static final String RC_EXE = "rc.exe";

    public WindowsKitWindowsSdkLocator(WindowsRegistry windowsRegistry) {
        super(windowsRegistry);
    }

    @Override
    String getComponentName() {
        return COMPONENT_NAME;
    }

    @Override
    String getDisplayName() {
        return DISPLAY_NAME;
    }

    @Override
    boolean isValidComponentBaseDir(File baseDir) {
        for (String platform : PLATFORMS) {
            if (new File(baseDir, "bin/" + platform + "/" + RC_EXE).exists()) continue;
            return false;
        }
        return true;
    }

    @Override
    boolean isValidComponentIncludeDir(File includeDir) {
        return new File(includeDir, "windows.h").exists();
    }

    @Override
    boolean isValidComponentLibDir(File libDir) {
        for (String platform : PLATFORMS) {
            if (new File(libDir, platform + "/kernel32.lib").exists()) continue;
            return false;
        }
        return true;
    }

    @Override
    WindowsKitWindowsSdk newComponent(File baseDir, VersionNumber version, AbstractWindowsKitComponentLocator.DiscoveryType discoveryType) {
        return new WindowsKitWindowsSdk(baseDir, version, this.getVersionedDisplayName(version, discoveryType));
    }
}

