/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.auth.profile.internal;

import com.amazonaws.AmazonClientException;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSSessionCredentials;
import com.amazonaws.auth.profile.internal.securitytoken.RoleInfo;
import com.amazonaws.internal.StaticCredentialsProvider;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.http.annotation.Immutable;

@Immutable
public class Profile {
    static final String AWS_ACCESS_KEY_ID = "aws_access_key_id";
    static final String AWS_SECRET_ACCESS_KEY = "aws_secret_access_key";
    static final String AWS_SESSION_TOKEN = "aws_session_token";
    static final String ROLE_ARN = "role_arn";
    static final String ROLE_SESSION_NAME = "role_session_name";
    static final String EXTERNAL_ID = "external_id";
    static final String SOURCE_PROFILE = "source_profile";
    private final String profileName;
    private final Map<String, String> properties;
    private final AWSCredentialsProvider awsCredentials;

    public Profile(String profileName, AWSCredentials awsCredentials) {
        LinkedHashMap<String, String> properties = new LinkedHashMap<String, String>();
        properties.put(AWS_ACCESS_KEY_ID, awsCredentials.getAWSAccessKeyId());
        properties.put(AWS_SECRET_ACCESS_KEY, awsCredentials.getAWSSecretKey());
        if (awsCredentials instanceof AWSSessionCredentials) {
            AWSSessionCredentials sessionCred = (AWSSessionCredentials)awsCredentials;
            properties.put(AWS_SESSION_TOKEN, sessionCred.getSessionToken());
        }
        this.profileName = profileName;
        this.properties = properties;
        this.awsCredentials = new StaticCredentialsProvider(awsCredentials);
    }

    public Profile(String profileName, String sourceProfile, AWSCredentialsProvider awsCredentials, RoleInfo roleInfo) {
        LinkedHashMap<String, String> properties = new LinkedHashMap<String, String>();
        properties.put(SOURCE_PROFILE, sourceProfile);
        properties.put(ROLE_ARN, roleInfo.getRoleArn());
        if (roleInfo.getRoleSessionName() != null) {
            properties.put(ROLE_SESSION_NAME, roleInfo.getRoleSessionName());
        }
        if (roleInfo.getExternalId() != null) {
            properties.put(EXTERNAL_ID, roleInfo.getExternalId());
        }
        this.profileName = profileName;
        this.properties = properties;
        this.awsCredentials = awsCredentials;
    }

    private Profile(String profileName, Map<String, String> properties, AWSCredentialsProvider awsCredentials) {
        this.profileName = profileName;
        this.properties = properties;
        this.awsCredentials = awsCredentials;
    }

    static Profile createInvalidProfile(final String profileName, final String invalidReason) {
        return new Profile(profileName, null, new AWSCredentialsProvider(){

            @Override
            public AWSCredentials getCredentials() {
                throw this.invalidException();
            }

            @Override
            public void refresh() {
                throw this.invalidException();
            }

            private AmazonClientException invalidException() {
                return new AmazonClientException(String.format("The profile %s is invalid. Reason: %s", profileName, invalidReason));
            }
        });
    }

    public String getProfileName() {
        return this.profileName;
    }

    public AWSCredentials getCredentials() {
        return this.awsCredentials.getCredentials();
    }

    public Map<String, String> getProperties() {
        return new LinkedHashMap<String, String>(this.properties);
    }

    public String getPropertyValue(String propertyName) {
        return this.getProperties().get(propertyName);
    }
}

