/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.incremental;

import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.internal.changedetection.rules.FileChange;
import org.gradle.api.internal.file.FileOperations;
import org.gradle.api.internal.tasks.compile.incremental.ClassChangeProcessor;
import org.gradle.api.internal.tasks.compile.incremental.JavaChangeProcessor;
import org.gradle.api.internal.tasks.compile.incremental.SourceToNameConverter;
import org.gradle.api.internal.tasks.compile.incremental.jar.JarChangeProcessor;
import org.gradle.api.internal.tasks.compile.incremental.jar.JarClasspathSnapshot;
import org.gradle.api.internal.tasks.compile.incremental.jar.JarSnapshot;
import org.gradle.api.internal.tasks.compile.incremental.jar.PreviousCompilation;
import org.gradle.api.internal.tasks.compile.incremental.recomp.RecompilationSpec;
import org.gradle.api.tasks.incremental.IncrementalTaskInputs;
import org.gradle.api.tasks.incremental.InputFileDetails;
import org.gradle.internal.FileUtils;
import org.gradle.internal.file.FileType;
import org.gradle.internal.util.Alignment;

public class RecompilationSpecProvider {
    private final SourceToNameConverter sourceToNameConverter;
    private final FileOperations fileOperations;

    public RecompilationSpecProvider(SourceToNameConverter sourceToNameConverter, FileOperations fileOperations) {
        this.sourceToNameConverter = sourceToNameConverter;
        this.fileOperations = fileOperations;
    }

    public RecompilationSpec provideRecompilationSpec(IncrementalTaskInputs inputs, PreviousCompilation previousCompilation, JarClasspathSnapshot jarClasspathSnapshot) {
        RecompilationSpec spec = new RecompilationSpec();
        JarChangeProcessor jarChangeProcessor = new JarChangeProcessor(this.fileOperations, jarClasspathSnapshot, previousCompilation);
        this.processJarChanges(previousCompilation.getJarSnapshots(), jarClasspathSnapshot, jarChangeProcessor, spec);
        JavaChangeProcessor javaChangeProcessor = new JavaChangeProcessor(previousCompilation, this.sourceToNameConverter);
        ClassChangeProcessor classChangeProcessor = new ClassChangeProcessor(previousCompilation);
        InputChangeAction action = new InputChangeAction(spec, javaChangeProcessor, classChangeProcessor);
        inputs.outOfDate((Action)action);
        if (action.spec.getFullRebuildCause() != null) {
            return action.spec;
        }
        inputs.removed((Action)action);
        return action.spec;
    }

    private void processJarChanges(Map<File, JarSnapshot> previousCompilationJarSnapshots, JarClasspathSnapshot currentJarSnapshots, JarChangeProcessor jarChangeProcessor, RecompilationSpec spec) {
        Set<File> previousCompilationJars = previousCompilationJarSnapshots.keySet();
        Set<File> currentCompilationJars = currentJarSnapshots.getJars();
        List<Alignment<File>> alignment = Alignment.align(currentCompilationJars.toArray(new File[0]), previousCompilationJars.toArray(new File[0]));
        for (Alignment<File> fileAlignment : alignment) {
            switch (fileAlignment.getKind()) {
                case added: {
                    jarChangeProcessor.processChange((InputFileDetails)FileChange.added((String)fileAlignment.getCurrentValue().getAbsolutePath(), (String)"jar", (FileType)FileType.RegularFile), spec);
                    break;
                }
                case removed: {
                    jarChangeProcessor.processChange((InputFileDetails)FileChange.removed((String)fileAlignment.getPreviousValue().getAbsolutePath(), (String)"jar", (FileType)FileType.RegularFile), spec);
                    break;
                }
                case transformed: {
                    spec.setFullRebuildCause("Classpath has been changed", null);
                    return;
                }
                case identical: {
                    File key = fileAlignment.getPreviousValue();
                    JarSnapshot previousSnapshot = previousCompilationJarSnapshots.get(key);
                    JarSnapshot snapshot = currentJarSnapshots.getSnapshot(key);
                    if (snapshot.getHash().equals((Object)previousSnapshot.getHash())) break;
                    jarChangeProcessor.processChange((InputFileDetails)FileChange.modified((String)key.getAbsolutePath(), (String)"jar", (FileType)FileType.RegularFile, (FileType)FileType.RegularFile), spec);
                }
            }
        }
    }

    private static class InputChangeAction
    implements Action<InputFileDetails> {
        private final RecompilationSpec spec;
        private final JavaChangeProcessor javaChangeProcessor;
        private final ClassChangeProcessor classChangeProcessor;

        public InputChangeAction(RecompilationSpec spec, JavaChangeProcessor javaChangeProcessor, ClassChangeProcessor classChangeProcessor) {
            this.spec = spec;
            this.javaChangeProcessor = javaChangeProcessor;
            this.classChangeProcessor = classChangeProcessor;
        }

        public void execute(InputFileDetails input) {
            if (this.spec.getFullRebuildCause() != null) {
                return;
            }
            if (FileUtils.hasExtension((File)input.getFile(), (String)".java")) {
                this.javaChangeProcessor.processChange(input, this.spec);
            } else if (FileUtils.hasExtension((File)input.getFile(), (String)".class")) {
                this.classChangeProcessor.processChange(input, this.spec);
            }
        }
    }
}

