/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder;

import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.DependencyState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.NodeState;

public interface OptionalDependenciesHandler {
    public static final OptionalDependenciesHandler IGNORE = new IgnoreOptionalDependenciesHandler();

    public Visitor start(boolean var1);

    public static class IgnoreOptionalDependenciesHandler
    implements OptionalDependenciesHandler {
        @Override
        public Visitor start(boolean isOptionalConfiguration) {
            return new IgnoreOptionalDependenciesVisitor(isOptionalConfiguration);
        }

        static class IgnoreOptionalDependenciesVisitor
        implements Visitor {
            private final boolean isOptionalConfiguration;

            IgnoreOptionalDependenciesVisitor(boolean isOptionalConfiguration) {
                this.isOptionalConfiguration = isOptionalConfiguration;
            }

            @Override
            public boolean maybeAddAsOptionalDependency(NodeState node, DependencyState dependencyState) {
                return !this.isOptionalConfiguration && dependencyState.getDependencyMetadata().isOptional();
            }

            @Override
            public void complete() {
            }
        }
    }

    public static interface Visitor {
        public boolean maybeAddAsOptionalDependency(NodeState var1, DependencyState var2);

        public void complete();
    }
}

