/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resolve;

import java.io.InterruptedIOException;
import java.util.Collection;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.gradle.internal.resource.transport.http.HttpErrorStatusCodeException;

public class ResolveExceptionAnalyzer {
    public static boolean hasCriticalFailure(Collection<? extends Throwable> failures) {
        for (Throwable throwable : failures) {
            if (!ResolveExceptionAnalyzer.isCriticalFailure(throwable)) continue;
            return true;
        }
        return false;
    }

    public static boolean isCriticalFailure(Throwable throwable) {
        Throwable rootCause = ExceptionUtils.getRootCause((Throwable)throwable);
        return ResolveExceptionAnalyzer.isTimeoutException(rootCause) || ResolveExceptionAnalyzer.isUnrecoverable5xxStatusCode(rootCause);
    }

    private static boolean isTimeoutException(Throwable rootCause) {
        return rootCause instanceof InterruptedIOException;
    }

    private static boolean isUnrecoverable5xxStatusCode(Throwable rootCause) {
        return rootCause instanceof HttpErrorStatusCodeException && ((HttpErrorStatusCodeException)rootCause).isServerError();
    }
}

