/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resource.cached;

import java.io.File;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.Collections;
import java.util.List;
import org.gradle.internal.resource.cached.CachedArtifact;

public class DefaultCachedArtifact
implements CachedArtifact,
Serializable {
    private final File cachedFile;
    private final long cachedAt;
    private final BigInteger descriptorHash;
    private final List<String> attemptedLocations;

    public DefaultCachedArtifact(File cachedFile, long cachedAt, BigInteger descriptorHash) {
        this.cachedFile = cachedFile;
        this.cachedAt = cachedAt;
        this.descriptorHash = descriptorHash;
        this.attemptedLocations = Collections.emptyList();
    }

    public DefaultCachedArtifact(List<String> attemptedLocations, long cachedAt, BigInteger descriptorHash) {
        this.attemptedLocations = attemptedLocations;
        this.cachedAt = cachedAt;
        this.cachedFile = null;
        this.descriptorHash = descriptorHash;
    }

    @Override
    public boolean isMissing() {
        return this.cachedFile == null;
    }

    @Override
    public File getCachedFile() {
        return this.cachedFile;
    }

    @Override
    public long getCachedAt() {
        return this.cachedAt;
    }

    @Override
    public BigInteger getDescriptorHash() {
        return this.descriptorHash;
    }

    @Override
    public List<String> attemptedLocations() {
        return this.attemptedLocations;
    }
}

