/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.nativeplatform.internal;

import java.util.concurrent.Callable;
import org.apache.commons.lang.StringUtils;
import org.gradle.api.Action;
import org.gradle.api.Incubating;
import org.gradle.api.NonNullApi;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.provider.Provider;
import org.gradle.language.base.LanguageSourceSet;
import org.gradle.language.base.internal.LanguageSourceSetInternal;
import org.gradle.language.c.CSourceSet;
import org.gradle.language.cpp.CppSourceSet;
import org.gradle.language.nativeplatform.tasks.AbstractNativeCompileTask;
import org.gradle.language.nativeplatform.tasks.Depend;
import org.gradle.model.ModelMap;
import org.gradle.model.RuleSource;
import org.gradle.nativeplatform.internal.NativeBinarySpecInternal;
import org.gradle.nativeplatform.toolchain.Clang;
import org.gradle.nativeplatform.toolchain.Gcc;
import org.gradle.nativeplatform.toolchain.NativeToolChain;
import org.gradle.platform.base.BinaryTasks;

@Incubating
@NonNullApi
public class DependPlugin
implements Plugin<Project> {
    public void apply(Project project) {
    }

    private static void configureDependTask(Project project, final AbstractNativeCompileTask compile, Depend depend) {
        depend.source(compile.getSource());
        depend.includes(compile.getIncludes());
        depend.getHeaderDependenciesFile().set(project.getLayout().getBuildDirectory().file(depend.getName() + "/" + "inputs.txt"));
        depend.getImportsAreIncludes().set(project.provider((Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                NativeToolChain toolChain = compile.getToolChain();
                return Clang.class.isAssignableFrom(toolChain.getClass()) || Gcc.class.isAssignableFrom(toolChain.getClass());
            }
        }));
        compile.getHeaderDependenciesFile().set((Provider)depend.getHeaderDependenciesFile());
    }

    private static class CreateDependTaskAction
    implements Action<LanguageSourceSet> {
        private final NativeBinarySpecInternal binary;
        private final ModelMap<Task> tasks;

        public CreateDependTaskAction(NativeBinarySpecInternal binary, ModelMap<Task> tasks) {
            this.binary = binary;
            this.tasks = tasks;
        }

        public void execute(LanguageSourceSet cppSourceSet) {
            final String suffix = StringUtils.capitalize((String)this.binary.getProjectScopedName()) + StringUtils.capitalize((String)((LanguageSourceSetInternal)cppSourceSet).getProjectScopedName());
            this.tasks.named("compile" + suffix, (Action)new Action<Task>(){

                public void execute(Task task) {
                    final AbstractNativeCompileTask compileTask = (AbstractNativeCompileTask)task;
                    final Project project = compileTask.getProject();
                    project.getTasks().create("depend" + suffix, Depend.class, (Action)new Action<Depend>(){

                        public void execute(Depend depend) {
                            DependPlugin.configureDependTask(project, compileTask, depend);
                        }
                    });
                }
            });
        }
    }

    static class Rules
    extends RuleSource {
        Rules() {
        }

        @BinaryTasks
        void addDependTask(ModelMap<Task> tasks, NativeBinarySpecInternal binary) {
            CreateDependTaskAction createDependTaskAction = new CreateDependTaskAction(binary, tasks);
            binary.getInputs().withType(CppSourceSet.class, (Action)createDependTaskAction);
            binary.getInputs().withType(CSourceSet.class, (Action)createDependTaskAction);
        }
    }
}

