/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.file;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.gradle.internal.file.FileHierarchySet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultFileHierarchySet {
    private static final EmptyFileHierarchySet EMPTY = new EmptyFileHierarchySet();

    public static FileHierarchySet of() {
        return EMPTY;
    }

    public static FileHierarchySet of(File rootDir) {
        return new PrefixFileSet(rootDir);
    }

    public static FileHierarchySet of(Collection<File> rootDirs) {
        FileHierarchySet set = EMPTY;
        for (File rootDir : rootDirs) {
            set = set.plus(rootDir);
        }
        return set;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Node {
        private final String prefix;
        private final List<Node> children;

        Node(String prefix) {
            this.prefix = prefix;
            this.children = ImmutableList.of();
        }

        public Node(String prefix, List<Node> children) {
            this.prefix = prefix;
            this.children = children;
        }

        Node plus(String path) {
            int maxPos = Math.min(this.prefix.length(), path.length());
            int prefixLen = this.sizeOfCommonPrefix(path, 0);
            if (prefixLen == maxPos) {
                if (this.prefix.length() == path.length()) {
                    if (this.children.isEmpty()) {
                        return this;
                    }
                    return new Node(path);
                }
                if (this.prefix.length() < path.length()) {
                    if (this.children.isEmpty()) {
                        return this;
                    }
                    int startNextSegment = this.prefix.length() + 1;
                    ArrayList<Node> merged = new ArrayList<Node>(this.children.size() + 1);
                    boolean matched = false;
                    for (Node child : this.children) {
                        if (child.sizeOfCommonPrefix(path, startNextSegment) > 0) {
                            merged.add(child.plus(path.substring(startNextSegment)));
                            matched = true;
                            continue;
                        }
                        merged.add(child);
                    }
                    if (!matched) {
                        merged.add(new Node(path.substring(startNextSegment)));
                    }
                    return new Node(this.prefix, merged);
                }
                return new Node(path);
            }
            String commonPrefix = this.prefix.substring(0, prefixLen);
            Node newThis = new Node(this.prefix.substring(prefixLen + 1), this.children);
            Node sibling = new Node(path.substring(prefixLen + 1));
            return new Node(commonPrefix, (List<Node>)ImmutableList.of((Object)newThis, (Object)sibling));
        }

        int sizeOfCommonPrefix(String path, int offset) {
            int pos;
            int lastSeparator = 0;
            int maxPos = Math.min(this.prefix.length(), path.length() - offset);
            for (pos = 0; pos < maxPos && this.prefix.charAt(pos) == path.charAt(pos + offset); ++pos) {
                if (this.prefix.charAt(pos) != File.separatorChar) continue;
                lastSeparator = pos;
            }
            if (pos == maxPos) {
                if (this.prefix.length() == path.length() - offset) {
                    return pos;
                }
                if (pos < this.prefix.length() && this.prefix.charAt(pos) == File.separatorChar) {
                    return pos;
                }
                if (pos < path.length() - offset && path.charAt(pos + offset) == File.separatorChar) {
                    return pos;
                }
            }
            return lastSeparator;
        }

        boolean isChildOfOrThis(String filePath, int offset) {
            if (!filePath.regionMatches(offset, this.prefix, 0, this.prefix.length())) {
                return false;
            }
            int endThisSegment = offset + this.prefix.length();
            return endThisSegment == filePath.length() || filePath.charAt(endThisSegment) == File.separatorChar;
        }

        boolean contains(String filePath, int offset) {
            if (!this.isChildOfOrThis(filePath, offset)) {
                return false;
            }
            if (this.children.isEmpty()) {
                return true;
            }
            int startNextSegment = offset + this.prefix.length() + 1;
            for (Node child : this.children) {
                if (!child.contains(filePath, startNextSegment)) continue;
                return true;
            }
            return false;
        }

        public void collect(int depth, List<String> prefixes) {
            if (depth == 0) {
                prefixes.add(this.prefix);
            } else {
                prefixes.add(depth + ":" + this.prefix.replace(File.separatorChar, '/'));
            }
            for (Node child : this.children) {
                child.collect(depth + 1, prefixes);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PrefixFileSet
    implements FileHierarchySet {
        private final Node rootNode;

        PrefixFileSet(File rootDir) {
            String path = this.toPath(rootDir);
            this.rootNode = new Node(path);
        }

        PrefixFileSet(Node rootNode) {
            this.rootNode = rootNode;
        }

        @VisibleForTesting
        List<String> flatten() {
            ArrayList<String> prefixes = new ArrayList<String>();
            this.rootNode.collect(0, prefixes);
            return prefixes;
        }

        @Override
        public boolean contains(String path) {
            return this.rootNode.contains(path, 0);
        }

        @Override
        public boolean contains(File file) {
            return this.rootNode.contains(file.getPath(), 0);
        }

        @Override
        public FileHierarchySet plus(File rootDir) {
            return new PrefixFileSet(this.rootNode.plus(this.toPath(rootDir)));
        }

        private String toPath(File rootDir) {
            assert (rootDir.isAbsolute());
            String absolutePath = rootDir.getAbsolutePath();
            if (absolutePath.equals("/")) {
                absolutePath = "";
            } else if (absolutePath.endsWith(File.separator)) {
                absolutePath = absolutePath.substring(0, absolutePath.length() - 1);
            }
            return absolutePath;
        }
    }

    private static class EmptyFileHierarchySet
    implements FileHierarchySet {
        private EmptyFileHierarchySet() {
        }

        public boolean contains(File file) {
            return false;
        }

        public boolean contains(String path) {
            return false;
        }

        public FileHierarchySet plus(File rootDir) {
            return new PrefixFileSet(rootDir);
        }
    }
}

