/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.manage.schema.extract;

import com.google.common.collect.ImmutableSet;
import org.gradle.model.Managed;
import org.gradle.model.internal.core.NodeInitializer;
import org.gradle.model.internal.core.NodeInitializerContext;
import org.gradle.model.internal.inspect.StructNodeInitializer;
import org.gradle.model.internal.manage.binding.StructBindings;
import org.gradle.model.internal.manage.binding.StructBindingsStore;
import org.gradle.model.internal.manage.schema.ManagedImplStructSchema;
import org.gradle.model.internal.manage.schema.ModelSchema;
import org.gradle.model.internal.manage.schema.extract.NodeInitializerExtractionStrategy;
import org.gradle.model.internal.type.ModelType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManagedImplStructNodeInitializerExtractionStrategy
implements NodeInitializerExtractionStrategy {
    private final StructBindingsStore bindingsStore;

    public ManagedImplStructNodeInitializerExtractionStrategy(StructBindingsStore bindingsStore) {
        this.bindingsStore = bindingsStore;
    }

    protected boolean isTarget(ModelType<?> type) {
        return type.isAnnotationPresent(Managed.class);
    }

    @Override
    public <T> NodeInitializer extractNodeInitializer(ModelSchema<T> schema, NodeInitializerContext<T> context) {
        if (!(schema instanceof ManagedImplStructSchema)) {
            return null;
        }
        if (!this.isTarget(schema.getType())) {
            return null;
        }
        StructBindings<T> bindings = this.bindingsStore.getBindings(schema.getType());
        return new StructNodeInitializer<T>(bindings);
    }

    @Override
    public Iterable<ModelType<?>> supportedTypes() {
        return ImmutableSet.of();
    }
}

