/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.mapping.core;

import groovy.lang.Closure;
import groovy.lang.GroovySystem;
import groovy.lang.MetaClassRegistry;
import java.util.Map;
import javax.annotation.PreDestroy;
import org.grails.datastore.mapping.cache.TPCacheAdapterRepository;
import org.grails.datastore.mapping.config.Property;
import org.grails.datastore.mapping.core.ConnectionNotFoundException;
import org.grails.datastore.mapping.core.Datastore;
import org.grails.datastore.mapping.core.DatastoreUtils;
import org.grails.datastore.mapping.core.Session;
import org.grails.datastore.mapping.core.SessionCallback;
import org.grails.datastore.mapping.core.SessionCreationEvent;
import org.grails.datastore.mapping.core.StatelessDatastore;
import org.grails.datastore.mapping.model.MappingContext;
import org.grails.datastore.mapping.model.PersistentEntity;
import org.grails.datastore.mapping.model.PersistentProperty;
import org.grails.datastore.mapping.model.PropertyMapping;
import org.grails.datastore.mapping.model.types.BasicTypeConverterRegistrar;
import org.grails.datastore.mapping.reflect.ClassPropertyFetcher;
import org.grails.datastore.mapping.reflect.FieldEntityAccess;
import org.grails.datastore.mapping.services.DefaultServiceRegistry;
import org.grails.datastore.mapping.services.Service;
import org.grails.datastore.mapping.services.ServiceNotFoundException;
import org.grails.datastore.mapping.services.ServiceRegistry;
import org.grails.datastore.mapping.transactions.SessionHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.convert.converter.ConverterRegistry;
import org.springframework.core.env.PropertyResolver;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public abstract class AbstractDatastore
implements Datastore,
StatelessDatastore,
ServiceRegistry {
    protected static final Logger LOG = LoggerFactory.getLogger(AbstractDatastore.class);
    private ApplicationContext applicationContext;
    protected final MappingContext mappingContext;
    protected final ServiceRegistry serviceRegistry;
    protected final PropertyResolver connectionDetails;
    protected final TPCacheAdapterRepository cacheAdapterRepository;

    public AbstractDatastore(MappingContext mappingContext) {
        this(mappingContext, (PropertyResolver)null, null);
    }

    public AbstractDatastore(MappingContext mappingContext, Map<String, Object> connectionDetails, ConfigurableApplicationContext ctx) {
        this(mappingContext, connectionDetails, ctx, null);
    }

    public AbstractDatastore(MappingContext mappingContext, PropertyResolver connectionDetails, ConfigurableApplicationContext ctx) {
        this(mappingContext, connectionDetails, ctx, null);
    }

    public AbstractDatastore(MappingContext mappingContext, PropertyResolver connectionDetails, ConfigurableApplicationContext ctx, TPCacheAdapterRepository cacheAdapterRepository) {
        this.mappingContext = mappingContext;
        this.connectionDetails = connectionDetails;
        this.setApplicationContext((ApplicationContext)ctx);
        this.cacheAdapterRepository = cacheAdapterRepository;
        DefaultServiceRegistry defaultServiceRegistry = new DefaultServiceRegistry(this);
        this.serviceRegistry = defaultServiceRegistry;
        defaultServiceRegistry.initialize();
    }

    public AbstractDatastore(MappingContext mappingContext, Map<String, Object> connectionDetails, ConfigurableApplicationContext ctx, TPCacheAdapterRepository cacheAdapterRepository) {
        this(mappingContext, AbstractDatastore.mapToPropertyResolver(connectionDetails), ctx, cacheAdapterRepository);
    }

    protected static PropertyResolver mapToPropertyResolver(Map<String, Object> connectionDetails) {
        return DatastoreUtils.createPropertyResolver(connectionDetails);
    }

    @Override
    public <T> T getService(Class<T> interfaceType) throws ServiceNotFoundException {
        return this.serviceRegistry.getService(interfaceType);
    }

    @Override
    public <T extends Service> Iterable<T> getServices() {
        return this.serviceRegistry.getServices();
    }

    @PreDestroy
    public void destroy() throws Exception {
        FieldEntityAccess.clearReflectors();
        MetaClassRegistry registry = GroovySystem.getMetaClassRegistry();
        for (PersistentEntity persistentEntity : this.getMappingContext().getPersistentEntities()) {
            Class cls = persistentEntity.getJavaClass();
            try {
                registry.removeMetaClass(cls);
            }
            catch (Exception e) {
                LOG.warn("There was an error shutting down GORM for entity [" + cls.getName() + "]: " + e.getMessage(), (Throwable)e);
            }
        }
        ClassPropertyFetcher.clearCache();
    }

    public void setApplicationContext(ApplicationContext ctx) {
        this.applicationContext = ctx;
    }

    @Override
    public Session connect() {
        return this.connect(this.connectionDetails);
    }

    public final Session connect(PropertyResolver connDetails) {
        Session session = this.createSession(connDetails);
        this.publishSessionCreationEvent(session);
        return session;
    }

    private void publishSessionCreationEvent(Session session) {
        ApplicationEventPublisher applicationEventPublisher = this.getApplicationEventPublisher();
        if (applicationEventPublisher != null) {
            applicationEventPublisher.publishEvent((ApplicationEvent)new SessionCreationEvent(session));
        }
    }

    @Override
    public Session connectStateless() {
        Session session = this.createStatelessSession(this.connectionDetails);
        this.publishSessionCreationEvent(session);
        return session;
    }

    protected abstract Session createSession(PropertyResolver var1);

    protected Session createStatelessSession(PropertyResolver connectionDetails) {
        return this.createSession(connectionDetails);
    }

    @Override
    public Session getCurrentSession() throws ConnectionNotFoundException {
        return DatastoreUtils.doGetSession(this, false);
    }

    @Override
    public boolean hasCurrentSession() {
        return TransactionSynchronizationManager.hasResource((Object)this);
    }

    public static Session retrieveSession() throws ConnectionNotFoundException {
        return AbstractDatastore.retrieveSession(Datastore.class);
    }

    public static Session retrieveSession(Class datastoreClass) throws ConnectionNotFoundException {
        Map resourceMap = TransactionSynchronizationManager.getResourceMap();
        Session session = null;
        if (resourceMap != null && !resourceMap.isEmpty()) {
            for (Object key : resourceMap.keySet()) {
                SessionHolder sessionHolder;
                if (!datastoreClass.isInstance(key) || (sessionHolder = (SessionHolder)((Object)resourceMap.get(key))) == null) continue;
                session = sessionHolder.getSession();
            }
        }
        if (session == null) {
            throw new ConnectionNotFoundException("No datastore session found. Call Datastore.connect(..) before calling Datastore.getCurrentSession()");
        }
        return session;
    }

    @Override
    public MappingContext getMappingContext() {
        return this.mappingContext;
    }

    @Override
    @Deprecated
    public ConfigurableApplicationContext getApplicationContext() {
        return (ConfigurableApplicationContext)this.applicationContext;
    }

    @Override
    public ApplicationEventPublisher getApplicationEventPublisher() {
        return this.getApplicationContext();
    }

    protected void initializeConverters(MappingContext mappingContext) {
        ConverterRegistry conversionService = mappingContext.getConverterRegistry();
        BasicTypeConverterRegistrar registrar = new BasicTypeConverterRegistrar();
        registrar.register(conversionService);
    }

    protected boolean isIndexed(PersistentProperty property) {
        PropertyMapping pm = property.getMapping();
        Object keyValue = pm.getMappedForm();
        return keyValue != null && ((Property)keyValue).isIndex();
    }

    @Override
    public boolean isSchemaless() {
        return false;
    }

    @Override
    public <T> T withSession(final Closure<T> callable) {
        return DatastoreUtils.execute((Datastore)this, new SessionCallback<T>(){

            @Override
            public T doInSession(Session session) {
                return callable.call((Object)session);
            }
        });
    }
}

