module.exports = function(stream) {
    if (stream.readable && typeof stream.resume === 'function') {
        var state = stream._readableState;
        if (!state || state.pipesCount === 0) {
            // Either a classic stream or streams2 that's not piped to another destination
            try {
                stream.resume();
            } catch (err) {
                console.error("Got error: " + err);
                // If we can't, it's not worth dying over
            }
        }
    }
};
