/*
 * Decompiled with CFR 0.152.
 */
package ch.interlis.ili2c.metamodel;

import ch.ehi.basics.logging.EhiLogger;
import ch.interlis.ili2c.metamodel.AbstractLeafElement;
import ch.interlis.ili2c.metamodel.Container;
import ch.interlis.ili2c.metamodel.Element;
import ch.interlis.ili2c.metamodel.Model;
import ch.interlis.ili2c.metamodel.Topic;
import ch.interlis.ili2c.metamodel.Type;
import java.beans.PropertyVetoException;
import java.util.HashSet;
import java.util.Set;

public class Domain
extends AbstractLeafElement {
    protected String name = null;
    protected Type type = null;
    protected boolean _abstract = false;
    protected boolean _final = false;
    protected Domain extending = null;
    protected Set extendedBy = new HashSet(2);
    protected Set aliasedBy = new HashSet(2);
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public Domain() {
    }

    public Domain(String name, Type type, Domain extending, boolean _abstract, boolean _final) {
        Domain.checkNameSanity(name, false);
        this.name = name;
        try {
            this.setAbstract(_abstract);
            this.setType(type);
            this.setFinal(_final);
            this.setExtending(extending);
        }
        catch (PropertyVetoException ex) {
            throw new IllegalStateException(ex.toString());
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) throws PropertyVetoException {
        String oldValue = this.name;
        String newValue = name;
        Domain.checkNameSanity(name, false);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("ch.interlis.ili2c.metamodel.Domain");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.checkNameUniqueness(name, clazz, null, "err_duplicateFunctionName");
        this.fireVetoableChange("name", oldValue, newValue);
        this.name = newValue;
        this.firePropertyChange("name", oldValue, newValue);
    }

    public String getScopedName(Container scope) {
        Topic scopeTopic;
        Model scopeModel;
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("ch.interlis.ili2c.metamodel.Model");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Model enclosingModel = (Model)this.getContainer(clazz);
        Class<?> clazz2 = class$2;
        if (clazz2 == null) {
            try {
                clazz2 = class$2 = Class.forName("ch.interlis.ili2c.metamodel.Topic");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Topic enclosingTopic = (Topic)this.getContainer(clazz2);
        if (enclosingModel == null) {
            return this.getName();
        }
        if (scope != null) {
            Class<?> clazz3 = class$1;
            if (clazz3 == null) {
                try {
                    clazz3 = class$1 = Class.forName("ch.interlis.ili2c.metamodel.Model");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            scopeModel = (Model)scope.getContainerOrSame(clazz3);
            Class<?> clazz4 = class$2;
            if (clazz4 == null) {
                try {
                    clazz4 = class$2 = Class.forName("ch.interlis.ili2c.metamodel.Topic");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            scopeTopic = (Topic)scope.getContainerOrSame(clazz4);
        } else {
            scopeModel = null;
            scopeTopic = null;
        }
        if (enclosingModel == null || enclosingTopic == null && enclosingModel == scopeModel || enclosingTopic != null && enclosingTopic == scopeTopic) {
            return this.getName();
        }
        if (enclosingTopic != null) {
            return String.valueOf(enclosingTopic.getScopedName(scope)) + "." + this.getName();
        }
        return String.valueOf(enclosingModel.getName()) + "." + this.getName();
    }

    public String toString() {
        return "DOMAIN " + this.getScopedName(null);
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) throws PropertyVetoException {
        Type oldValue = this.type;
        Type newValue = type;
        if (newValue == null) {
            throw new IllegalArgumentException(rsrc.getString("err_nullNotAcceptable"));
        }
        if (type != null && type.isAbstract() && !this.isAbstract()) {
            throw new IllegalArgumentException(Domain.formatMessage("err_domainMustBeAbstractDueToType", this.toString()));
        }
        this.fireVetoableChange("type", oldValue, newValue);
        this.type = newValue;
        this.firePropertyChange("type", oldValue, newValue);
    }

    public boolean isAbstract() {
        return this._abstract;
    }

    public void setAbstract(boolean abs) throws PropertyVetoException {
        boolean oldValue = this._abstract;
        boolean newValue = abs;
        if (oldValue == newValue) {
            return;
        }
        if (newValue && this.isFinal()) {
            throw new IllegalArgumentException(rsrc.getString("err_abstractFinal"));
        }
        this.firePropertyChange("abstract", oldValue, newValue);
        this._abstract = newValue;
        this.fireVetoableChange("abstract", oldValue, newValue);
    }

    public boolean isFinal() {
        return this._final;
    }

    public void setFinal(boolean fin) throws PropertyVetoException {
        boolean oldValue = this._final;
        boolean newValue = fin;
        if (oldValue == newValue) {
            return;
        }
        if (newValue && this.isAbstract()) {
            throw new IllegalArgumentException(rsrc.getString("err_abstractFinal"));
        }
        if (fin && !this.extendedBy.isEmpty()) {
            throw new IllegalArgumentException("A type must not be declared FINAL while there exist extending types.");
        }
        this.fireVetoableChange("final", oldValue, newValue);
        this._final = newValue;
        this.firePropertyChange("final", oldValue, newValue);
    }

    public Domain getExtending() {
        return this.extending;
    }

    public boolean isExtendingIndirectly(Domain dd) {
        Domain parent = this;
        while (parent != null) {
            if (parent == dd) {
                return true;
            }
            parent = parent.extending;
        }
        return false;
    }

    public void setExtending(Domain extending) throws PropertyVetoException {
        Domain oldValue = this.extending;
        Domain newValue = extending;
        if (oldValue == newValue) {
            return;
        }
        if (newValue != null && newValue.isFinal()) {
            throw new IllegalArgumentException(Domain.formatMessage("err_cantExtendFinal", newValue.toString()));
        }
        if (newValue != null && newValue.isExtendingIndirectly(this)) {
            throw new IllegalArgumentException(Domain.formatMessage("err_cyclicExtension", this.toString(), newValue.toString()));
        }
        this.fireVetoableChange("extending", oldValue, newValue);
        if (this.type != null) {
            if (extending == null) {
                this.type.setExtending(null);
            } else {
                this.type.setExtending(extending.getType());
            }
        }
        if (oldValue != null) {
            oldValue.extendedBy.remove(this);
        }
        this.extending = newValue;
        if (newValue != null) {
            newValue.extendedBy.add(this);
        }
        this.firePropertyChange("extending", oldValue, newValue);
    }

    public boolean checkStructuralEquivalence(Element with) {
        if (!super.checkStructuralEquivalence(with)) {
            return false;
        }
        Type myType = this.getType();
        Type otherType = ((Domain)with).getType();
        if (myType == null) {
            return otherType == null;
        }
        if (!myType.checkStructuralEquivalence(otherType)) {
            EhiLogger.logError(Domain.formatMessage("err_diff_domainType", this.toString(), with.toString()));
            return false;
        }
        if (this.isAbstract() != ((Domain)with).isAbstract()) {
            EhiLogger.logError(Domain.formatMessage("err_diff_mismatchInAbstractness", this.toString(), with.toString()));
            return false;
        }
        if (this.isFinal() != ((Domain)with).isFinal()) {
            EhiLogger.logError(Domain.formatMessage("err_diff_mismatchInFinality", this.toString(), with.toString()));
            return false;
        }
        return true;
    }
}

