/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.tools;

import java.io.PrintStream;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.EcmaError;
import org.mozilla.javascript.ErrorReporter;
import org.mozilla.javascript.EvaluatorException;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.RhinoException;
import org.mozilla.javascript.WrappedException;

public class ToolErrorReporter
implements ErrorReporter {
    private final String messagePrefix = "js: ";
    private boolean hasReportedErrorFlag;
    private boolean reportWarnings;
    private PrintStream err;

    public ToolErrorReporter(boolean bl) {
        this(bl, System.err);
    }

    public ToolErrorReporter(boolean bl, PrintStream printStream) {
        this.reportWarnings = bl;
        this.err = printStream;
    }

    public static String getMessage(String string) {
        return ToolErrorReporter.getMessage(string, (Object[])null);
    }

    public static String getMessage(String string, String string2) {
        Object[] objectArray = new Object[]{string2};
        return ToolErrorReporter.getMessage(string, objectArray);
    }

    public static String getMessage(String string, Object object, Object object2) {
        Object[] objectArray = new Object[]{object, object2};
        return ToolErrorReporter.getMessage(string, objectArray);
    }

    public static String getMessage(String string, Object[] objectArray) {
        String string2;
        Context context = Context.getCurrentContext();
        Locale locale = context == null ? Locale.getDefault() : context.getLocale();
        ResourceBundle resourceBundle = ResourceBundle.getBundle("org.mozilla.javascript.tools.resources.Messages", locale);
        try {
            string2 = resourceBundle.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            throw new RuntimeException("no message resource found for message property " + string);
        }
        if (objectArray == null) {
            return string2;
        }
        MessageFormat messageFormat = new MessageFormat(string2);
        return messageFormat.format(objectArray);
    }

    private static String getExceptionMessage(RhinoException rhinoException) {
        String string = rhinoException instanceof JavaScriptException ? ToolErrorReporter.getMessage("msg.uncaughtJSException", rhinoException.details()) : (rhinoException instanceof EcmaError ? ToolErrorReporter.getMessage("msg.uncaughtEcmaError", rhinoException.details()) : rhinoException.toString());
        return string;
    }

    public void warning(String string, String string2, int n, String string3, int n2) {
        if (!this.reportWarnings) {
            return;
        }
        this.reportErrorMessage(string, string2, n, string3, n2, true);
    }

    public void error(String string, String string2, int n, String string3, int n2) {
        this.hasReportedErrorFlag = true;
        this.reportErrorMessage(string, string2, n, string3, n2, false);
    }

    public EvaluatorException runtimeError(String string, String string2, int n, String string3, int n2) {
        this.error(string, string2, n, string3, n2);
        return new EvaluatorException(string, string2, n, string3, n2);
    }

    public boolean hasReportedError() {
        return this.hasReportedErrorFlag;
    }

    public boolean isReportingWarnings() {
        return this.reportWarnings;
    }

    public void setIsReportingWarnings(boolean bl) {
        this.reportWarnings = bl;
    }

    public static void reportException(ErrorReporter errorReporter, RhinoException rhinoException) {
        if (errorReporter instanceof ToolErrorReporter) {
            ((ToolErrorReporter)errorReporter).reportException(rhinoException);
        } else {
            String string = ToolErrorReporter.getExceptionMessage(rhinoException);
            errorReporter.error(string, rhinoException.sourceName(), rhinoException.lineNumber(), rhinoException.lineSource(), rhinoException.columnNumber());
        }
    }

    public void reportException(RhinoException rhinoException) {
        if (rhinoException instanceof WrappedException) {
            WrappedException wrappedException = (WrappedException)rhinoException;
            wrappedException.printStackTrace(this.err);
        } else {
            String string = ToolErrorReporter.getExceptionMessage(rhinoException);
            this.reportErrorMessage(string, rhinoException.sourceName(), rhinoException.lineNumber(), rhinoException.lineSource(), rhinoException.columnNumber(), false);
        }
    }

    private void reportErrorMessage(String string, String string2, int n, String string3, int n2, boolean bl) {
        if (n > 0) {
            String string4 = String.valueOf(n);
            if (string2 != null) {
                Object[] objectArray = new Object[]{string2, string4, string};
                string = ToolErrorReporter.getMessage("msg.format3", objectArray);
            } else {
                Object[] objectArray = new Object[]{string4, string};
                string = ToolErrorReporter.getMessage("msg.format2", objectArray);
            }
        } else {
            Object[] objectArray = new Object[]{string};
            string = ToolErrorReporter.getMessage("msg.format1", objectArray);
        }
        if (bl) {
            string = ToolErrorReporter.getMessage("msg.warning", string);
        }
        this.err.println("js: " + string);
        if (null != string3) {
            this.err.println("js: " + string3);
            this.err.println("js: " + this.buildIndicator(n2));
        }
    }

    private String buildIndicator(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n - 1; ++i) {
            stringBuffer.append(".");
        }
        stringBuffer.append("^");
        return stringBuffer.toString();
    }
}

