/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fonts.type1;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.fonts.SingleByteFont;
import org.apache.fop.fonts.type1.AdobeStandardEncoding;
import org.apache.fop.fonts.type1.PFBData;
import org.apache.fop.fonts.type1.PFBParser;
import org.apache.fop.fonts.type1.PostscriptParser;

public class Type1SubsetFile {
    protected static final Log LOG = LogFactory.getLog(Type1SubsetFile.class);
    protected HashMap<String, byte[]> subsetCharStrings;
    protected List<String> charNames;
    protected LinkedHashMap<Integer, byte[]> uniqueSubs;
    private SingleByteFont sbfont;
    protected String eol = "\n";
    protected boolean subsetSubroutines = true;
    private byte[] fullFont;
    protected List<PostscriptParser.PSElement> headerSection;
    protected List<PostscriptParser.PSElement> mainSection;
    protected boolean standardEncoding;
    private static final int OP_SEAC = 6;
    private static final int OP_CALLSUBR = 10;
    private static final int OP_CALLOTHERSUBR = 16;

    public byte[] createSubset(InputStream in, SingleByteFont sbfont) throws IOException {
        this.fullFont = IOUtils.toByteArray(in);
        byte[] subsetFont = this.createSubset(sbfont, true);
        return subsetFont.length == 0 || subsetFont.length > this.fullFont.length ? this.fullFont : subsetFont;
    }

    private byte[] createSubset(SingleByteFont sbfont, boolean subsetSubroutines) throws IOException {
        PostscriptParser.PSElement charStrings;
        boolean result;
        PostscriptParser.PSElement encoding;
        this.subsetSubroutines = subsetSubroutines;
        ByteArrayInputStream in = new ByteArrayInputStream(this.fullFont);
        this.sbfont = sbfont;
        PFBParser pfbParser = new PFBParser();
        PFBData pfbData = pfbParser.parsePFB(in);
        PostscriptParser psParser = new PostscriptParser();
        this.charNames = new ArrayList<String>();
        if (this.headerSection == null) {
            this.headerSection = psParser.parse(pfbData.getHeaderSegment());
        }
        if ((encoding = this.getElement("/Encoding", this.headerSection)).getFoundUnexpected()) {
            return new byte[0];
        }
        List<String> subsetEncodingEntries = this.readEncoding(encoding);
        byte[] decoded = BinaryCoder.decodeBytes(pfbData.getEncryptedSegment(), 55665, 4);
        this.uniqueSubs = new LinkedHashMap();
        this.subsetCharStrings = new HashMap();
        if (this.mainSection == null) {
            this.mainSection = psParser.parse(decoded);
        }
        if (!(result = this.readMainSection(this.mainSection, decoded, subsetEncodingEntries, charStrings = this.getElement("/CharStrings", this.mainSection)))) {
            this.uniqueSubs.clear();
            this.subsetCharStrings.clear();
            this.charNames.clear();
            return this.createSubset(sbfont, false);
        }
        ByteArrayOutputStream boasHeader = this.writeHeader(pfbData, encoding);
        ByteArrayOutputStream boasMain = this.writeMainSection(decoded, this.mainSection, charStrings);
        byte[] mainSectionBytes = boasMain.toByteArray();
        mainSectionBytes = BinaryCoder.encodeBytes(mainSectionBytes, 55665, 4);
        boasMain.reset();
        boasMain.write(mainSectionBytes);
        ByteArrayOutputStream baosTrailer = new ByteArrayOutputStream();
        baosTrailer.write(pfbData.getTrailerSegment(), 0, pfbData.getTrailerSegment().length);
        return this.stitchFont(boasHeader, boasMain, baosTrailer);
    }

    public byte[] stitchFont(ByteArrayOutputStream boasHeader, ByteArrayOutputStream boasMain, ByteArrayOutputStream boasTrailer) throws IOException {
        int headerLength = boasHeader.size();
        int mainLength = boasMain.size();
        boasMain.write(128);
        boasMain.write(1);
        this.updateSectionSize(boasTrailer.size()).writeTo(boasMain);
        boasTrailer.write(128);
        boasTrailer.write(3);
        boasTrailer.writeTo(boasMain);
        boasHeader.write(128);
        boasHeader.write(2);
        this.updateSectionSize(mainLength).writeTo(boasHeader);
        boasMain.writeTo(boasHeader);
        ByteArrayOutputStream fullFont = new ByteArrayOutputStream();
        fullFont.write(128);
        fullFont.write(1);
        this.updateSectionSize(headerLength).writeTo(fullFont);
        boasHeader.writeTo(fullFont);
        return fullFont.toByteArray();
    }

    private List<String> readEncoding(PostscriptParser.PSElement encoding) {
        Map<Integer, Integer> usedGlyphs = this.sbfont.getUsedGlyphs();
        ArrayList<Integer> glyphs = new ArrayList<Integer>(usedGlyphs.keySet());
        Collections.sort(glyphs);
        ArrayList<String> subsetEncodingEntries = new ArrayList<String>();
        if (encoding instanceof PostscriptParser.PSFixedArray) {
            PostscriptParser.PSFixedArray encodingArray = (PostscriptParser.PSFixedArray)encoding;
            Iterator i$ = glyphs.iterator();
            while (i$.hasNext()) {
                int glyph = (Integer)i$.next();
                List<String> matches = this.searchEntries(encodingArray.getEntries(), glyph);
                if (matches.size() == 0) {
                    matches.clear();
                    if (glyph == 0) {
                        matches.add("dup 0 /.notdef put");
                    } else {
                        matches.add(String.format("dup %d /%s put", glyph, this.sbfont.getGlyphName(glyph)));
                    }
                }
                for (String match : matches) {
                    subsetEncodingEntries.add(match);
                    this.addToCharNames(match);
                }
            }
        } else if (encoding instanceof PostscriptParser.PSVariable) {
            if (((PostscriptParser.PSVariable)encoding).getValue().equals("StandardEncoding")) {
                this.standardEncoding = true;
                this.sbfont.mapUsedGlyphName(0, "/.notdef");
                Iterator i$ = glyphs.iterator();
                while (i$.hasNext()) {
                    int glyph = (Integer)i$.next();
                    String name = this.sbfont.getGlyphName(glyph);
                    if (glyph == 0 || name == null || name.trim().equals("")) continue;
                    this.sbfont.mapUsedGlyphName(glyph, "/" + name);
                }
            } else {
                LOG.warn("Only Custom or StandardEncoding is supported when creating a Type 1 subset.");
            }
        }
        return subsetEncodingEntries;
    }

    protected List<String> searchEntries(HashMap<Integer, String> encodingEntries, int glyph) {
        ArrayList<String> matches = new ArrayList<String>();
        for (Map.Entry<Integer, String> entry : encodingEntries.entrySet()) {
            String tag = this.getEntryPart(entry.getValue(), 3);
            String name = this.sbfont.getGlyphName(this.sbfont.getUsedGlyphs().get(glyph));
            if (!name.equals(tag)) continue;
            matches.add(entry.getValue());
        }
        return matches;
    }

    protected ByteArrayOutputStream writeHeader(PFBData pfbData, PostscriptParser.PSElement encoding) throws IOException {
        ByteArrayOutputStream boasHeader = new ByteArrayOutputStream();
        boasHeader.write(pfbData.getHeaderSegment(), 0, encoding.getStartPoint() - 1);
        if (!this.standardEncoding) {
            String encodingArray = this.eol + "/Encoding 256 array" + this.eol + "0 1 255 {1 index exch /.notdef put } for" + this.eol;
            byte[] encodingDefinition = encodingArray.getBytes("ASCII");
            boasHeader.write(encodingDefinition, 0, encodingDefinition.length);
            Set<Map.Entry<Integer, String>> entrySet = this.sbfont.getUsedGlyphNames().entrySet();
            for (Map.Entry<Integer, String> entry : entrySet) {
                String arrayEntry = String.format("dup %d %s put", entry.getKey(), entry.getValue());
                this.writeString(arrayEntry + this.eol, boasHeader);
            }
            this.writeString("readonly def" + this.eol, boasHeader);
        } else {
            String theEncoding = this.eol + "/Encoding StandardEncoding def" + this.eol;
            boasHeader.write(theEncoding.getBytes("ASCII"));
        }
        boasHeader.write(pfbData.getHeaderSegment(), encoding.getEndPoint(), pfbData.getHeaderSegment().length - encoding.getEndPoint());
        return boasHeader;
    }

    ByteArrayOutputStream updateSectionSize(int size) throws IOException {
        ByteArrayOutputStream boas = new ByteArrayOutputStream();
        byte[] lowOrderSize = ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN).putInt(size).array();
        boas.write(lowOrderSize);
        return boas;
    }

    private boolean readMainSection(List<PostscriptParser.PSElement> mainSection, byte[] decoded, List<String> subsetEncodingEntries, PostscriptParser.PSElement charStrings) {
        subsetEncodingEntries.add(0, "dup 0 /.notdef put");
        PostscriptParser.PSDictionary charStringsDict = (PostscriptParser.PSDictionary)charStrings;
        for (String tag : this.sbfont.getUsedGlyphNames().values()) {
            int[] location;
            if (!tag.equals("/.notdef")) {
                this.charNames.add(tag);
            }
            if ((location = charStringsDict.getBinaryEntries().get(tag)) == null) continue;
            byte[] charStringEntry = this.getBinaryEntry(location, decoded);
            int skipBytes = 4;
            PostscriptParser.PSElement element = this.getElement("lenIV", mainSection);
            if (element != null && element instanceof PostscriptParser.PSVariable) {
                PostscriptParser.PSVariable lenIV = (PostscriptParser.PSVariable)element;
                try {
                    skipBytes = Integer.parseInt(lenIV.getValue());
                }
                catch (NumberFormatException ex) {
                    LOG.warn(String.format("Invalid value `%s` for lenIV found in font %s", lenIV.getValue(), this.sbfont.getEmbedFileURI().toString()));
                }
            }
            charStringEntry = BinaryCoder.decodeBytes(charStringEntry, 4330, skipBytes);
            PostscriptParser.PSFixedArray subroutines = (PostscriptParser.PSFixedArray)this.getElement("/Subrs", mainSection);
            if (this.subsetSubroutines) {
                charStringEntry = this.createSubsetCharStrings(decoded, charStringEntry, subroutines, subsetEncodingEntries);
            }
            if (charStringEntry.length == 0) {
                return false;
            }
            charStringEntry = BinaryCoder.encodeBytes(charStringEntry, 4330, skipBytes);
            this.subsetCharStrings.put(tag, charStringEntry);
        }
        return true;
    }

    private byte[] createSubsetCharStrings(byte[] decoded, byte[] data, PostscriptParser.PSFixedArray subroutines, List<String> subsetEncodingEntries) {
        ArrayList<BytesNumber> operands = new ArrayList<BytesNumber>();
        for (int i = 0; i < data.length; ++i) {
            int cur = data[i] & 0xFF;
            if (cur <= 31) {
                int dataLength = data.length;
                if (cur == 10) {
                    if (operands.size() == 0) continue;
                    if (this.uniqueSubs.get(((BytesNumber)operands.get(operands.size() - 1)).getNumber()) == null) {
                        this.uniqueSubs.put(((BytesNumber)operands.get(operands.size() - 1)).getNumber(), new byte[0]);
                        data = this.addSubroutine(subroutines, operands, decoded, subsetEncodingEntries, data, i, 1, -1, ((BytesNumber)operands.get(operands.size() - 1)).getNumber());
                    } else {
                        data = this.addSubroutine(subroutines, operands, decoded, subsetEncodingEntries, data, i, 1, this.getSubrIndex(((BytesNumber)operands.get(operands.size() - 1)).getNumber()), ((BytesNumber)operands.get(operands.size() - 1)).getNumber());
                    }
                } else if (cur == 12) {
                    int next;
                    if ((next = data[++i] & 0xFF) == 6) {
                        int first = ((BytesNumber)operands.get(operands.size() - 2)).getNumber();
                        int second = ((BytesNumber)operands.get(operands.size() - 1)).getNumber();
                        String charFirst = AdobeStandardEncoding.getCharFromCodePoint(first);
                        String charSecond = AdobeStandardEncoding.getCharFromCodePoint(second);
                        subsetEncodingEntries.add(String.format("dup %d /%s put", first, charFirst));
                        subsetEncodingEntries.add(String.format("dup %d /%s put", second, charSecond));
                        this.sbfont.mapUsedGlyphName(first, "/" + charFirst);
                        this.sbfont.mapUsedGlyphName(second, "/" + charSecond);
                    } else if (next == 16) {
                        int[] pattern = new int[]{12, 17, 10};
                        int count = 0;
                        boolean matchesPattern = true;
                        if (data.length > i + 4) {
                            for (int pos = i + 1; pos < i + 4; ++pos) {
                                if (data[pos] == pattern[count++]) continue;
                                matchesPattern = false;
                            }
                        }
                        if (matchesPattern) {
                            return new byte[0];
                        }
                        data = this.addSubroutine(subroutines, operands, decoded, subsetEncodingEntries, data, i, 2, -1, ((BytesNumber)operands.get(0)).getNumber());
                    }
                }
                if (data.length == 0) {
                    return new byte[0];
                }
                i -= dataLength - data.length;
                operands.clear();
                continue;
            }
            if (cur <= 246) {
                operands.add(new BytesNumber(cur - 139, 1));
                continue;
            }
            if (cur <= 250) {
                operands.add(new BytesNumber((cur - 247) * 256 + (data[i + 1] & 0xFF) + 108, 2));
                ++i;
                continue;
            }
            if (cur <= 254) {
                operands.add(new BytesNumber(-(cur - 251) * 256 - (data[i + 1] & 0xFF) - 108, 2));
                ++i;
                continue;
            }
            if (cur != 255) continue;
            int b1 = data[i + 1] & 0xFF;
            int b2 = data[i + 2] & 0xFF;
            int b3 = data[i + 3] & 0xFF;
            int b4 = data[i + 4] & 0xFF;
            int value = b1 << 24 | b2 << 16 | b3 << 8 | b4;
            operands.add(new BytesNumber(value, 5));
            i += 4;
        }
        return data;
    }

    private int getSubrIndex(int subID) {
        int count = 0;
        for (Integer key : this.uniqueSubs.keySet()) {
            if (key == subID) {
                return count;
            }
            ++count;
        }
        return -1;
    }

    private byte[] addSubroutine(PostscriptParser.PSFixedArray subroutines, List<BytesNumber> operands, byte[] decoded, List<String> subsetEncodingEntries, byte[] data, int i, int opLength, int existingSubrRef, int subrID) {
        if (existingSubrRef == -1) {
            int[] subrData = subroutines.getBinaryEntryByIndex(subrID);
            byte[] subroutine = this.getBinaryEntry(subrData, decoded);
            subroutine = BinaryCoder.decodeBytes(subroutine, 4330, 4);
            if ((subroutine = this.createSubsetCharStrings(decoded, subroutine, subroutines, subsetEncodingEntries)).length == 0) {
                return new byte[0];
            }
            subroutine = BinaryCoder.encodeBytes(subroutine, 4330, 4);
            this.uniqueSubs.put(subrID, subroutine);
        }
        int subRef = existingSubrRef != -1 ? existingSubrRef : this.uniqueSubs.size() - 1;
        data = this.constructNewRefData(i, data, operands, 1, subRef, opLength);
        return data;
    }

    protected ByteArrayOutputStream writeMainSection(byte[] decoded, List<PostscriptParser.PSElement> mainSection, PostscriptParser.PSElement charStrings) throws IOException {
        ByteArrayOutputStream main = new ByteArrayOutputStream();
        PostscriptParser.PSElement subrs = this.getElement("/Subrs", mainSection);
        String rd = this.findVariable(decoded, mainSection, new String[]{"string currentfile exch readstring pop"}, "RD");
        String nd = this.findVariable(decoded, mainSection, new String[]{"def", "noaccess def"}, "noaccess def");
        String np = this.findVariable(decoded, mainSection, new String[]{"put", "noaccess put"}, "noaccess put");
        main.write(decoded, 0, subrs.getStartPoint());
        if (this.subsetSubroutines) {
            this.writeString(this.eol + String.format("/Subrs %d array", this.uniqueSubs.size()), main);
            int count = 0;
            for (Map.Entry<Integer, byte[]> entry : this.uniqueSubs.entrySet()) {
                this.writeString(this.eol + String.format("dup %d %d %s ", count++, entry.getValue().length, rd), main);
                main.write(entry.getValue());
                this.writeString(" " + np, main);
            }
            this.writeString(this.eol + nd, main);
        } else {
            int fullSubrsLength = subrs.getEndPoint() - subrs.getStartPoint();
            main.write(decoded, subrs.getStartPoint(), fullSubrsLength);
        }
        main.write(decoded, subrs.getEndPoint(), charStrings.getStartPoint() - subrs.getEndPoint());
        this.writeString(this.eol + String.format("/CharStrings %d dict dup begin", this.subsetCharStrings.size()), main);
        for (Map.Entry<String, byte[]> entry : this.subsetCharStrings.entrySet()) {
            this.writeString(this.eol + String.format("%s %d %s ", entry.getKey(), entry.getValue().length, rd), main);
            main.write(entry.getValue());
            this.writeString(" " + nd, main);
        }
        this.writeString(this.eol + "end", main);
        main.write(decoded, charStrings.getEndPoint(), decoded.length - charStrings.getEndPoint());
        return main;
    }

    protected String findVariable(byte[] decoded, List<PostscriptParser.PSElement> elements, String[] matches, String fallback) throws UnsupportedEncodingException {
        for (PostscriptParser.PSElement element : elements) {
            if (!(element instanceof PostscriptParser.PSSubroutine)) continue;
            byte[] var = new byte[element.getEndPoint() - element.getStartPoint()];
            System.arraycopy(decoded, element.getStartPoint(), var, 0, element.getEndPoint() - element.getStartPoint());
            String found = this.readVariableContents(new String(var, "ASCII")).trim();
            for (String match : matches) {
                if (!match.equals(found)) continue;
                return element.getOperator().substring(1, element.getOperator().length());
            }
        }
        return fallback;
    }

    String readVariableContents(String variable) {
        int i;
        int level = 0;
        String result = "";
        int start = 0;
        int end = 0;
        boolean reading = false;
        ArrayList<Integer> results = new ArrayList<Integer>();
        for (i = 0; i < variable.length(); ++i) {
            char curChar = variable.charAt(i);
            boolean sectionEnd = false;
            if (curChar == '{') {
                ++level;
                sectionEnd = true;
            } else if (curChar == '}') {
                --level;
                sectionEnd = true;
            } else if (level == 1) {
                if (!reading) {
                    reading = true;
                    start = i;
                }
                end = i;
            }
            if (!sectionEnd || !reading) continue;
            results.add(start);
            results.add(end);
            reading = false;
        }
        for (i = 0; i < results.size(); i += 2) {
            result = result.concat(variable.substring((Integer)results.get(i), (Integer)results.get(i + 1) + 1));
        }
        return result;
    }

    private void addToCharNames(String encodingEntry) {
        int spaceCount = 0;
        int lastSpaceIndex = 0;
        int charIndex = 0;
        String charName = "";
        for (int i = 0; i < encodingEntry.length(); ++i) {
            boolean isSpace;
            boolean bl = isSpace = encodingEntry.charAt(i) == ' ';
            if (isSpace) {
                switch (++spaceCount - 1) {
                    case 1: {
                        charIndex = Integer.parseInt(encodingEntry.substring(lastSpaceIndex + 1, i));
                        break;
                    }
                    case 2: {
                        charName = encodingEntry.substring(lastSpaceIndex + 1, i);
                        break;
                    }
                }
            }
            if (!isSpace) continue;
            lastSpaceIndex = i;
        }
        this.sbfont.mapUsedGlyphName(charIndex, charName);
    }

    protected void writeString(String entry, ByteArrayOutputStream boas) throws IOException {
        byte[] byteEntry = entry.getBytes("ASCII");
        boas.write(byteEntry);
    }

    private byte[] constructNewRefData(int curDataPos, byte[] currentData, List<BytesNumber> operands, int opNum, int curSubsetIndexSize, int operatorLength) {
        int operandsLenth = this.getOperandsLength(operands);
        int startRef = curDataPos - operandsLenth + this.getOpPosition(opNum, operands) + (1 - operatorLength);
        byte[] preBytes = new byte[startRef];
        System.arraycopy(currentData, 0, preBytes, 0, startRef);
        byte[] newRefBytes = this.createNewRef(curSubsetIndexSize, -1);
        byte[] newData = this.concatArray(preBytes, newRefBytes);
        byte[] postBytes = new byte[currentData.length - (startRef + operands.get(opNum - 1).getNumBytes())];
        System.arraycopy(currentData, startRef + operands.get(opNum - 1).getNumBytes(), postBytes, 0, currentData.length - (startRef + operands.get(opNum - 1).getNumBytes()));
        return this.concatArray(newData, postBytes);
    }

    int getOpPosition(int opNum, List<BytesNumber> operands) {
        int byteCount = 0;
        for (int i = 0; i < opNum - 1; ++i) {
            byteCount += operands.get(i).getNumBytes();
        }
        return byteCount;
    }

    int getOperandsLength(List<BytesNumber> operands) {
        int length = 0;
        for (BytesNumber number : operands) {
            length += number.getNumBytes();
        }
        return length;
    }

    private byte[] createNewRef(int newRef, int forceLength) {
        byte[] newRefBytes = forceLength == -1 && newRef <= 107 || forceLength == 1 ? new byte[]{(byte)(newRef + 139)} : (forceLength == -1 && newRef <= 1131 || forceLength == 2 ? new byte[]{newRef <= 363 ? (byte)-9 : (newRef <= 619 ? (byte)-8 : (newRef <= 875 ? (byte)-7 : -6)), (byte)(newRef - 108)} : new byte[]{-1, (byte)(newRef >> 24), (byte)(newRef >> 16), (byte)(newRef >> 8), (byte)newRef});
        return newRefBytes;
    }

    byte[] concatArray(byte[] a, byte[] b) {
        int aLen = a.length;
        int bLen = b.length;
        byte[] c = new byte[aLen + bLen];
        System.arraycopy(a, 0, c, 0, aLen);
        System.arraycopy(b, 0, c, aLen, bLen);
        return c;
    }

    protected byte[] getBinaryEntry(int[] position, byte[] decoded) {
        int start = position[0];
        int finish = position[1];
        byte[] line = new byte[finish - start];
        System.arraycopy(decoded, start, line, 0, finish - start);
        return line;
    }

    protected String getEntryPart(String entry, int part) {
        Scanner s = new Scanner(entry).useDelimiter(" ");
        for (int i = 1; i < part; ++i) {
            s.next();
        }
        return s.next();
    }

    protected PostscriptParser.PSElement getElement(String elementID, List<PostscriptParser.PSElement> elements) {
        for (PostscriptParser.PSElement element : elements) {
            if (!element.getOperator().equals(elementID)) continue;
            return element;
        }
        return null;
    }

    public static class BinaryCoder {
        public static byte[] decodeBytes(byte[] in, int inR, int n) {
            byte[] out = new byte[in.length - n];
            int r = inR;
            int c1 = 52845;
            int c2 = 22719;
            for (int i = 0; i < in.length; ++i) {
                int cypher = in[i] & 0xFF;
                int plain = cypher ^ r >> 8;
                if (i >= n) {
                    out[i - n] = (byte)plain;
                }
                r = (cypher + r) * c1 + c2 & 0xFFFF;
            }
            return out;
        }

        public static byte[] encodeBytes(byte[] in, int inR, int n) {
            byte[] buffer = new byte[in.length + n];
            for (int i = 0; i < n; ++i) {
                buffer[i] = 0;
            }
            int r = inR;
            int c1 = 52845;
            int c2 = 22719;
            System.arraycopy(in, 0, buffer, n, buffer.length - n);
            byte[] out = new byte[buffer.length];
            for (int i = 0; i < buffer.length; ++i) {
                int plain = buffer[i] & 0xFF;
                int cipher = plain ^ r >> 8;
                out[i] = (byte)cipher;
                r = (cipher + r) * c1 + c2 & 0xFFFF;
            }
            return out;
        }
    }

    public static final class BytesNumber {
        private int number;
        private int numBytes;
        private String name;

        public BytesNumber(int number, int numBytes) {
            this.number = number;
            this.numBytes = numBytes;
        }

        public int getNumber() {
            return this.number;
        }

        public int getNumBytes() {
            return this.numBytes;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

