/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui.statusbar;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.gui.BufferOptions;
import org.gjt.sp.jedit.gui.statusbar.StatusWidgetFactory;
import org.gjt.sp.jedit.gui.statusbar.ToolTipLabel;
import org.gjt.sp.jedit.gui.statusbar.Widget;
import org.gjt.sp.jedit.jEdit;

public class FoldWidgetFactory
implements StatusWidgetFactory {
    @Override
    public Widget getWidget(View view) {
        FoldWidget foldWidget = new FoldWidget(view);
        return foldWidget;
    }

    private static class FoldWidget
    implements Widget {
        private final JLabel fold = new ToolTipLabel();
        private final View view;

        public FoldWidget(final View view) {
            this.view = view;
            this.fold.setToolTipText(jEdit.getProperty("view.status.mode-tooltip"));
            this.fold.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    if (mouseEvent.getClickCount() == 2) {
                        new BufferOptions(view, view.getBuffer());
                    }
                }
            });
        }

        @Override
        public JComponent getComponent() {
            return this.fold;
        }

        @Override
        public void update() {
            Buffer buffer = this.view.getBuffer();
            if (buffer.isLoaded()) {
                this.fold.setText((String)this.view.getBuffer().getProperty("folding"));
            }
        }

        @Override
        public void propertiesChanged() {
        }
    }
}

