/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.pluginmgr;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import org.gjt.sp.jedit.EditPlugin;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.PluginJAR;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.pluginmgr.PluginListHandler;
import org.gjt.sp.jedit.pluginmgr.Roster;
import org.gjt.sp.util.IOUtilities;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.StandardUtilities;
import org.gjt.sp.util.Task;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

class PluginList {
    public static final int GZIP_MAGIC_1 = 31;
    public static final int GZIP_MAGIC_2 = 139;
    public static final long MILLISECONDS_PER_MINUTE = 60000L;
    final List<Plugin> plugins = new ArrayList<Plugin>();
    final Map<String, Plugin> pluginHash = new HashMap<String, Plugin>();
    final List<PluginSet> pluginSets = new ArrayList<PluginSet>();
    private final String id = jEdit.getProperty("plugin-manager.mirror.id");
    private String cachedURL;
    private final Task task;
    String gzipURL;

    PluginList(Task task) {
        this.task = task;
        this.readPluginList(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void readPluginList(boolean bl) {
        Object object;
        boolean bl2;
        String string = PluginList.buildMirror(this.id);
        if (string == null) {
            return;
        }
        this.gzipURL = jEdit.getProperty("plugin-manager.export-url");
        this.gzipURL = this.gzipURL + "?mirror=" + string;
        this.gzipURL = this.gzipURL + "&new_url_scheme";
        String string2 = null;
        if (jEdit.getSettingsDirectory() == null) {
            this.cachedURL = this.gzipURL;
        } else {
            string2 = jEdit.getSettingsDirectory() + File.separator + "pluginMgr-Cached.xml.gz";
            this.cachedURL = "file:///" + string2;
        }
        boolean bl3 = bl2 = !this.id.equals(jEdit.getProperty("plugin-manager.mirror.cached-id"));
        if (string2 != null) {
            try {
                long l;
                long l2;
                long l3;
                object = new File(string2);
                if (!((File)object).canRead()) {
                    bl2 = true;
                }
                if ((l3 = (l2 = System.currentTimeMillis()) - ((File)object).lastModified()) > (l = (long)jEdit.getIntegerProperty("plugin-manager.list-cache.minutes", 5) * 60000L)) {
                    Log.log(3, this, "PluginList cached copy too old. Downloading from mirror. ");
                    bl2 = true;
                }
            }
            catch (Exception exception) {
                Log.log(3, this, "No cached copy. Downloading from mirror. ");
                bl2 = true;
            }
        }
        if (bl2 && this.cachedURL != this.gzipURL) {
            this.downloadPluginList();
        }
        object = null;
        InputStream inputStream = null;
        try {
            if (this.cachedURL != this.gzipURL) {
                Log.log(3, this, "Using cached pluginlist");
            }
            inputStream = new URL(this.cachedURL).openStream();
            XMLReader xMLReader = XMLReaderFactory.createXMLReader();
            PluginListHandler pluginListHandler = new PluginListHandler(this, this.cachedURL);
            object = new BufferedInputStream(inputStream);
            if (((InputStream)object).markSupported()) {
                ((InputStream)object).mark(2);
                int n = ((InputStream)object).read();
                int n2 = ((InputStream)object).read();
                ((InputStream)object).reset();
                if (n == 31 && n2 == 139) {
                    object = new GZIPInputStream((InputStream)object);
                }
            }
            InputSource inputSource = new InputSource(new InputStreamReader((InputStream)object, "UTF8"));
            inputSource.setSystemId("jedit.jar");
            xMLReader.setContentHandler(pluginListHandler);
            xMLReader.setDTDHandler(pluginListHandler);
            xMLReader.setEntityResolver(pluginListHandler);
            xMLReader.setErrorHandler(pluginListHandler);
            xMLReader.parse(inputSource);
        }
        catch (Exception exception) {
            block16: {
                try {
                    Log.log(9, this, "readpluginlist: error", exception);
                    if (!this.cachedURL.startsWith("file:///")) break block16;
                    Log.log(1, this, "Unable to read plugin list, deleting cached file and try again");
                    new File(this.cachedURL.substring(8)).delete();
                    if (!bl) break block16;
                    this.plugins.clear();
                    this.pluginHash.clear();
                    this.pluginSets.clear();
                    this.readPluginList(false);
                }
                catch (Throwable throwable) {
                    IOUtilities.closeQuietly((Closeable)object);
                    IOUtilities.closeQuietly(inputStream);
                    throw throwable;
                }
            }
            IOUtilities.closeQuietly((Closeable)object);
            IOUtilities.closeQuietly(inputStream);
        }
        IOUtilities.closeQuietly((Closeable)object);
        IOUtilities.closeQuietly(inputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void downloadPluginList() {
        BufferedInputStream bufferedInputStream = null;
        BufferedOutputStream bufferedOutputStream = null;
        try {
            this.task.setStatus(jEdit.getProperty("plugin-manager.list-download"));
            URL uRL = new URL(this.gzipURL);
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
            if (httpURLConnection.getResponseCode() == 407) {
                GUIUtilities.error(jEdit.getActiveView(), "plugin-manager.list-download.need-password", new Object[0]);
                Log.log(9, this, "CacheRemotePluginList: proxy requires authentication");
            } else if (httpURLConnection.getResponseCode() == 200) {
                InputStream inputStream = httpURLConnection.getInputStream();
                String string = this.cachedURL.replaceFirst("file:///", "");
                bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(string));
                long l = System.currentTimeMillis();
                bufferedInputStream = new BufferedInputStream(inputStream);
                IOUtilities.copyStream(4096, null, (InputStream)bufferedInputStream, (OutputStream)bufferedOutputStream, false);
                jEdit.setProperty("plugin-manager.mirror.cached-id", this.id);
                Log.log(3, this, "Updated cached pluginlist " + (System.currentTimeMillis() - l));
            } else {
                GUIUtilities.error(jEdit.getActiveView(), "plugin-manager.list-download.generic-error", new Object[]{httpURLConnection.getResponseCode(), httpURLConnection.getResponseMessage()});
                Log.log(9, this, "CacheRemotePluginList: HTTP error: " + httpURLConnection.getResponseCode() + httpURLConnection.getResponseMessage());
            }
        }
        catch (UnknownHostException unknownHostException) {
            GUIUtilities.error(jEdit.getActiveView(), "plugin-manager.list-download.disconnected", new Object[]{unknownHostException.getMessage()});
            Log.log(9, this, "CacheRemotePluginList: error", unknownHostException);
        }
        catch (Exception exception) {
            Log.log(9, this, "CacheRemotePluginList: error", exception);
        }
        finally {
            IOUtilities.closeQuietly(bufferedOutputStream);
            IOUtilities.closeQuietly(bufferedInputStream);
        }
    }

    void addPlugin(Plugin plugin) {
        this.plugins.add(plugin);
        this.pluginHash.put(plugin.name, plugin);
    }

    void addPluginSet(PluginSet pluginSet) {
        this.pluginSets.add(pluginSet);
    }

    void finished() {
        for (Plugin plugin : this.plugins) {
            for (int i = 0; i < plugin.branches.size(); ++i) {
                Branch branch = plugin.branches.get(i);
                for (int j = 0; j < branch.deps.size(); ++j) {
                    Dependency dependency = branch.deps.get(j);
                    if (!dependency.what.equals("plugin")) continue;
                    dependency.plugin = this.pluginHash.get(dependency.pluginName);
                }
            }
        }
    }

    void dump() {
        for (Plugin plugin : this.plugins) {
            System.err.println(plugin);
            System.err.println();
        }
    }

    String getMirrorId() {
        return this.id;
    }

    private static String buildMirror(String string) {
        return string != null && !string.equals("NONE") ? string : "default";
    }

    private static String getAutoSelectedMirror() throws IOException {
        HttpURLConnection httpURLConnection = (HttpURLConnection)new URL("http://sourceforge.net/projects/jedit/files/latest/download").openConnection();
        httpURLConnection.setInstanceFollowRedirects(false);
        int n = httpURLConnection.getResponseCode();
        if (n != 302) {
            throw new RuntimeException("Unexpected response: " + n + ": from " + "http://sourceforge.net/projects/jedit/files/latest/download");
        }
        String string = httpURLConnection.getHeaderField("Location");
        if (string == null) {
            throw new RuntimeException("Missing Location header: http://sourceforge.net/projects/jedit/files/latest/download");
        }
        int n2 = string.lastIndexOf("use_mirror=");
        if (n2 == -1) {
            throw new RuntimeException("Mirror prefix \"use_mirror\" was not found in redirected URL: " + string);
        }
        int n3 = n2 + "use_mirror=".length();
        int n4 = string.indexOf(38, n3);
        return n4 != -1 ? string.substring(n3, n4) : string.substring(n3);
    }

    static class Dependency {
        final String what;
        final String from;
        final String to;
        final String pluginName;
        Plugin plugin;

        Dependency(String string, String string2, String string3, String string4) {
            this.what = string;
            this.from = string2;
            this.to = string3;
            this.pluginName = string4;
        }

        boolean isSatisfied() {
            if (this.what.equals("plugin")) {
                for (int i = 0; i < this.plugin.branches.size(); ++i) {
                    String string = this.plugin.getInstalledVersion();
                    if (string == null || this.from != null && StandardUtilities.compareStrings(string, this.from, false) < 0 || this.to != null && StandardUtilities.compareStrings(string, this.to, false) > 0) continue;
                    return true;
                }
                return false;
            }
            if (this.what.equals("jdk")) {
                String string = System.getProperty("java.version").substring(0, 3);
                return !(this.from != null && StandardUtilities.compareStrings(string, this.from, false) < 0 || this.to != null && StandardUtilities.compareStrings(string, this.to, false) > 0);
            }
            if (this.what.equals("jedit")) {
                String string = jEdit.getBuild();
                return !(this.from != null && StandardUtilities.compareStrings(string, this.from, false) < 0 || this.to != null && StandardUtilities.compareStrings(string, this.to, false) > 0);
            }
            Log.log(9, this, "Invalid dependency: " + this.what);
            return false;
        }

        boolean canSatisfy() {
            if (this.isSatisfied()) {
                return true;
            }
            if (this.what.equals("plugin")) {
                return this.plugin.canBeInstalled();
            }
            return false;
        }

        void satisfy(Roster roster, String string, boolean bl) {
            if (this.what.equals("plugin")) {
                String string2 = this.plugin.getInstalledVersion();
                for (int i = 0; i < this.plugin.branches.size(); ++i) {
                    Branch branch = this.plugin.branches.get(i);
                    if (string2 != null && StandardUtilities.compareStrings(string2, branch.version, false) >= 0 || this.from != null && StandardUtilities.compareStrings(branch.version, this.from, false) < 0 || this.to != null && StandardUtilities.compareStrings(branch.version, this.to, false) > 0) continue;
                    this.plugin.install(roster, string, bl, false);
                    return;
                }
            }
        }

        public String toString() {
            return "[what=" + this.what + ",from=" + this.from + ",to=" + this.to + ",plugin=" + this.plugin + ']';
        }
    }

    static class Branch {
        String version;
        String date;
        int downloadSize;
        String download;
        int downloadSourceSize;
        String downloadSource;
        boolean obsolete;
        final List<Dependency> deps = new ArrayList<Dependency>();

        Branch() {
        }

        boolean canSatisfyDependencies() {
            for (Dependency dependency : this.deps) {
                if (dependency.canSatisfy()) continue;
                return false;
            }
            return true;
        }

        void satisfyDependencies(Roster roster, String string, boolean bl) {
            for (Dependency dependency : this.deps) {
                dependency.satisfy(roster, string, bl);
            }
        }

        public String depsToString() {
            StringBuilder stringBuilder = new StringBuilder();
            for (Dependency dependency : this.deps) {
                if (!"plugin".equals(dependency.what) || dependency.pluginName == null) continue;
                stringBuilder.append(dependency.pluginName).append('\n');
            }
            return stringBuilder.toString();
        }

        public String toString() {
            return "[version=" + this.version + ",download=" + this.download + ",obsolete=" + this.obsolete + ",deps=" + this.deps + ']';
        }
    }

    public static class Plugin {
        String jar;
        String name;
        String description;
        String author;
        final List<Branch> branches = new ArrayList<Branch>();
        String installedVersion = null;
        String installedPath = null;
        boolean loaded = false;

        String getInstalledVersion() {
            String[] stringArray;
            this.loaded = false;
            PluginJAR[] pluginJARArray = jEdit.getPluginJARs();
            for (int i = 0; i < pluginJARArray.length; ++i) {
                String object = pluginJARArray[i].getPath();
                if (!MiscUtilities.getFileName(object).equals(this.jar)) continue;
                EditPlugin editPlugin = pluginJARArray[i].getPlugin();
                if (editPlugin != null) {
                    this.installedVersion = jEdit.getProperty("plugin." + editPlugin.getClassName() + ".version");
                    this.loaded = true;
                    return this.installedVersion;
                }
                return null;
            }
            for (String string : stringArray = jEdit.getNotLoadedPluginJARs()) {
                if (!MiscUtilities.getFileName(string).equals(this.jar)) continue;
                try {
                    PluginJAR.PluginCacheEntry iOException = PluginJAR.getPluginCacheEntry(string);
                    if (iOException == null) continue;
                    String string2 = "plugin." + iOException.pluginClass + ".version";
                    this.installedVersion = iOException.cachedProperties.getProperty(string2);
                    Log.log(1, PluginList.class, "found installed but not loaded " + this.jar + " version=" + this.installedVersion);
                    this.installedPath = string;
                    return this.installedVersion;
                }
                catch (IOException iOException) {
                    Log.log(7, "Unable to access cache for " + this.jar, iOException);
                }
            }
            return null;
        }

        String getInstalledPath() {
            if (this.installedPath != null) {
                if (new File(this.installedPath).exists()) {
                    return this.installedPath;
                }
                this.installedPath = null;
            }
            PluginJAR[] pluginJARArray = jEdit.getPluginJARs();
            for (int i = 0; i < pluginJARArray.length; ++i) {
                String string = pluginJARArray[i].getPath();
                if (!MiscUtilities.getFileName(string).equals(this.jar)) continue;
                return string;
            }
            return null;
        }

        Branch getCompatibleBranch() {
            for (Branch branch : this.branches) {
                if (!branch.canSatisfyDependencies()) continue;
                return branch;
            }
            return null;
        }

        boolean canBeInstalled() {
            Branch branch = this.getCompatibleBranch();
            return branch != null && !branch.obsolete && branch.canSatisfyDependencies();
        }

        void install(Roster roster, String string, boolean bl, boolean bl2) {
            String string2 = this.getInstalledPath();
            Branch branch = this.getCompatibleBranch();
            if (branch.obsolete) {
                if (string2 != null) {
                    roster.addRemove(string2);
                }
                return;
            }
            if (this.installedVersion != null && this.installedPath != null && !this.loaded && bl2) {
                roster.addLoad(this.installedPath);
                return;
            }
            if (string2 != null) {
                string = MiscUtilities.getParentOfPath(string2);
            }
            roster.addInstall(string2, bl ? branch.downloadSource : branch.download, string, bl ? branch.downloadSourceSize : branch.downloadSize);
        }

        public String toString() {
            return this.name;
        }
    }

    static class PluginSet {
        String name;
        final List<String> plugins = new ArrayList<String>();

        PluginSet() {
        }

        public String toString() {
            return this.plugins.toString();
        }
    }
}

