/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.textarea;

import java.awt.font.TextLayout;
import java.util.Vector;
import javax.swing.text.TabExpander;
import org.gjt.sp.jedit.textarea.ColumnBlock;
import org.gjt.sp.jedit.textarea.ColumnBlockLine;
import org.gjt.sp.jedit.textarea.TextArea;

public class ElasticTabstopsTabExpander
implements TabExpander {
    TextArea textArea;

    public ElasticTabstopsTabExpander(TextArea textArea) {
        this.textArea = textArea;
    }

    @Override
    public float nextTabStop(float f, int n) {
        float f2 = 0.0f;
        if (this.textArea.buffer.getBooleanProperty("elasticTabstops") && this.textArea.buffer.getColumnBlock() != null) {
            int n2 = this.textArea.buffer.getLineOfOffset(n);
            f2 = this.getTabSize(this.textArea.buffer.getColumnBlock().getColumnBlock(n2, n), n2);
            if (f2 < 0.0f) {
                throw new IllegalArgumentException("Unaccounted tab at line " + this.textArea.buffer.getLineOfOffset(n) + " at index " + n);
            }
        }
        return f + (f2 += this.textArea.tabSize);
    }

    private float getTabSize(ColumnBlock columnBlock, int n) {
        float f = -5.0f;
        if (columnBlock != null) {
            Vector<ColumnBlockLine> vector = columnBlock.getLines();
            if (columnBlock.areTabSizesDirty()) {
                float f2 = -1.0f;
                for (int i = 0; i < vector.size(); ++i) {
                    ColumnBlockLine columnBlockLine = vector.elementAt(i);
                    int n2 = columnBlockLine.getColumnStartIndex() + this.textArea.buffer.getLineStartOffset(columnBlockLine.getLine());
                    String string = this.textArea.buffer.getText(n2, columnBlockLine.getColumnEndIndex() - columnBlockLine.getColumnStartIndex());
                    float f3 = 0.0f;
                    if (string.length() != 0) {
                        TextLayout textLayout = new TextLayout(string, this.textArea.painter.getFont(), this.textArea.painter.getFontRenderContext());
                        f3 = textLayout.getAdvance();
                    }
                    columnBlockLine.lineLength = f3;
                    if (!(f2 < 0.0f) && !(columnBlockLine.lineLength > f2)) continue;
                    f2 = columnBlockLine.lineLength;
                }
                columnBlock.columnBlockWidth = f2;
                columnBlock.setTabSizeDirtyStatus(false, false);
            }
            f = columnBlock.columnBlockWidth - vector.get((int)(n - columnBlock.startLine)).lineLength;
        }
        return f;
    }
}

