/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.textarea;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.font.FontRenderContext;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.JComponent;
import javax.swing.text.TabExpander;
import org.gjt.sp.jedit.Debug;
import org.gjt.sp.jedit.buffer.IndentFoldHandler;
import org.gjt.sp.jedit.buffer.JEditBuffer;
import org.gjt.sp.jedit.syntax.Chunk;
import org.gjt.sp.jedit.syntax.DefaultTokenHandler;
import org.gjt.sp.jedit.syntax.SyntaxStyle;
import org.gjt.sp.jedit.syntax.Token;
import org.gjt.sp.jedit.textarea.AntiAlias;
import org.gjt.sp.jedit.textarea.ChunkCache;
import org.gjt.sp.jedit.textarea.ExtensionManager;
import org.gjt.sp.jedit.textarea.Selection;
import org.gjt.sp.jedit.textarea.StructureMatcher;
import org.gjt.sp.jedit.textarea.TextArea;
import org.gjt.sp.jedit.textarea.TextAreaExtension;
import org.gjt.sp.util.Log;

public class TextAreaPainter
extends JComponent
implements TabExpander {
    public static final int LOWEST_LAYER = Integer.MIN_VALUE;
    public static final int BACKGROUND_LAYER = -60;
    public static final int LINE_BACKGROUND_LAYER = -50;
    public static final int BELOW_SELECTION_LAYER = -40;
    public static final int SELECTION_LAYER = -30;
    public static final int WRAP_GUIDE_LAYER = -20;
    public static final int BELOW_MOST_EXTENSIONS_LAYER = -10;
    public static final int DEFAULT_LAYER = 0;
    public static final int BLOCK_CARET_LAYER = 50;
    public static final int BRACKET_HIGHLIGHT_LAYER = 100;
    public static final int TEXT_LAYER = 200;
    public static final int CARET_LAYER = 300;
    public static final int HIGHEST_LAYER = Integer.MAX_VALUE;
    TextArea textArea;
    SyntaxStyle[] styles;
    Color caretColor;
    Color selectionColor;
    Color multipleSelectionColor;
    Color lineHighlightColor;
    Color structureHighlightColor;
    Color eolMarkerColor;
    String eolMarkerChar;
    Color wrapGuideColor;
    SyntaxStyle[] foldLineStyle;
    boolean blockCaret;
    boolean thickCaret;
    boolean lineHighlight;
    boolean structureHighlight;
    boolean eolMarkers;
    boolean wrapGuide;
    AntiAlias antiAlias;
    boolean fracFontMetrics;
    RenderingHints renderingHints;
    boolean selectionFg;
    Color selectionFgColor;
    FontMetrics fm;
    int extraLineSpacing;
    private final ExtensionManager extensionMgr;
    private final PaintCaret caretExtension;
    private FontRenderContext fontRenderContext;
    private Cursor hiddenCursor;
    private boolean defaultCursor = true;

    @Override
    public void setBounds(int n, int n2, int n3, int n4) {
        if (n == this.getX() && n2 == this.getY() && n3 == this.getWidth() && (n4 == this.getHeight() || n4 == this.getHeight() + 1)) {
            return;
        }
        super.setBounds(n, n2, n3, n4);
        this.textArea.recalculateVisibleLines();
        if (!this.textArea.getBuffer().isLoading()) {
            this.textArea.recalculateLastPhysicalLine();
        }
        this.textArea.propertiesChanged();
        this.textArea.updateMaxHorizontalScrollWidth();
        this.textArea.scrollBarsInitialized = true;
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.hiddenCursor = this.getToolkit().createCustomCursor(this.getGraphicsConfiguration().createCompatibleImage(16, 16, 2), new Point(0, 0), "Hidden");
    }

    @Override
    public void setCursor(Cursor cursor) {
        this.defaultCursor = cursor == this.hiddenCursor || cursor.getType() == 2;
        super.setCursor(cursor);
    }

    public void resetCursor() {
        this.defaultCursor = true;
    }

    void showCursor() {
        if (this.defaultCursor) {
            this.setCursor(Cursor.getPredefinedCursor(2));
        }
    }

    void hideCursor() {
        if (this.defaultCursor) {
            this.setCursor(this.hiddenCursor);
        }
    }

    @Override
    public boolean getFocusTraversalKeysEnabled() {
        return false;
    }

    public final SyntaxStyle[] getStyles() {
        return this.styles;
    }

    public final void setStyles(SyntaxStyle[] syntaxStyleArray) {
        this.styles = syntaxStyleArray;
        syntaxStyleArray[0] = new SyntaxStyle(this.getForeground(), null, this.getFont());
        this.textArea.chunkCache.reset();
        this.repaint();
    }

    public final Color getCaretColor() {
        return this.caretColor;
    }

    public final void setCaretColor(Color color) {
        this.caretColor = color;
        if (this.textArea.getBuffer() != null) {
            this.textArea.invalidateLine(this.textArea.getCaretLine());
        }
    }

    public final Color getSelectionColor() {
        return this.selectionColor;
    }

    public final void setSelectionColor(Color color) {
        this.selectionColor = color;
        this.textArea.repaint();
    }

    public final Color getMultipleSelectionColor() {
        return this.multipleSelectionColor;
    }

    public final void setMultipleSelectionColor(Color color) {
        this.multipleSelectionColor = color;
        this.textArea.repaint();
    }

    public final Color getLineHighlightColor() {
        return this.lineHighlightColor;
    }

    public final void setLineHighlightColor(Color color) {
        this.lineHighlightColor = color;
        if (this.textArea.getBuffer() != null) {
            this.textArea.invalidateLine(this.textArea.getCaretLine());
        }
    }

    public final boolean isLineHighlightEnabled() {
        return this.lineHighlight;
    }

    public final void setLineHighlightEnabled(boolean bl) {
        this.lineHighlight = bl;
        this.textArea.repaint();
    }

    public final Color getSelectionFgColor() {
        return this.selectionFgColor;
    }

    public final void setSelectionFgColor(Color color) {
        this.selectionFgColor = color;
        if (this.isSelectionFgColorEnabled()) {
            this.textArea.repaint();
        }
    }

    public final boolean isSelectionFgColorEnabled() {
        return this.selectionFg;
    }

    public final void setSelectionFgColorEnabled(boolean bl) {
        this.selectionFg = bl;
        this.textArea.repaint();
    }

    public final Color getStructureHighlightColor() {
        return this.structureHighlightColor;
    }

    public final void setStructureHighlightColor(Color color) {
        this.structureHighlightColor = color;
        this.textArea.invalidateStructureMatch();
    }

    public final boolean isStructureHighlightEnabled() {
        return this.structureHighlight;
    }

    public final void setStructureHighlightEnabled(boolean bl) {
        this.structureHighlight = bl;
        this.textArea.invalidateStructureMatch();
    }

    public final boolean isBlockCaretEnabled() {
        return this.blockCaret;
    }

    public final void setBlockCaretEnabled(boolean bl) {
        this.blockCaret = bl;
        this.extensionMgr.removeExtension(this.caretExtension);
        if (bl) {
            this.addExtension(50, this.caretExtension);
        } else {
            this.addExtension(300, this.caretExtension);
        }
        if (this.textArea.getBuffer() != null) {
            this.textArea.invalidateLine(this.textArea.getCaretLine());
        }
    }

    public final boolean isThickCaretEnabled() {
        return this.thickCaret;
    }

    public final void setThickCaretEnabled(boolean bl) {
        this.thickCaret = bl;
        if (this.textArea.getBuffer() != null) {
            this.textArea.invalidateLine(this.textArea.getCaretLine());
        }
    }

    public String getEOLMarkerChar() {
        return this.eolMarkerChar;
    }

    public void setEOLMarkerChar(String string) {
        this.eolMarkerChar = string;
    }

    public final Color getEOLMarkerColor() {
        return this.eolMarkerColor;
    }

    public final void setEOLMarkerColor(Color color) {
        this.eolMarkerColor = color;
        this.repaint();
    }

    public final boolean getEOLMarkersPainted() {
        return this.eolMarkers;
    }

    public final void setEOLMarkersPainted(boolean bl) {
        this.eolMarkers = bl;
        this.repaint();
    }

    public final Color getWrapGuideColor() {
        return this.wrapGuideColor;
    }

    public final void setWrapGuideColor(Color color) {
        this.wrapGuideColor = color;
        this.repaint();
    }

    public final boolean isWrapGuidePainted() {
        return this.wrapGuide;
    }

    public final void setWrapGuidePainted(boolean bl) {
        this.wrapGuide = bl;
        this.repaint();
    }

    public final SyntaxStyle[] getFoldLineStyle() {
        return this.foldLineStyle;
    }

    public final void setFoldLineStyle(SyntaxStyle[] syntaxStyleArray) {
        this.foldLineStyle = syntaxStyleArray;
        this.textArea.chunkCache.reset();
        this.repaint();
    }

    public void setAntiAlias(AntiAlias antiAlias) {
        this.antiAlias = antiAlias;
        this.updateRenderingHints();
    }

    public AntiAlias getAntiAlias() {
        return this.antiAlias;
    }

    public void setFractionalFontMetricsEnabled(boolean bl) {
        this.fracFontMetrics = bl;
        this.updateRenderingHints();
    }

    public boolean isFractionalFontMetricsEnabled() {
        return this.fracFontMetrics;
    }

    public FontRenderContext getFontRenderContext() {
        return this.fontRenderContext;
    }

    public void addExtension(TextAreaExtension textAreaExtension) {
        this.extensionMgr.addExtension(0, textAreaExtension);
        this.repaint();
    }

    public void addExtension(int n, TextAreaExtension textAreaExtension) {
        this.extensionMgr.addExtension(n, textAreaExtension);
        this.repaint();
    }

    public void removeExtension(TextAreaExtension textAreaExtension) {
        this.extensionMgr.removeExtension(textAreaExtension);
        this.repaint();
    }

    public TextAreaExtension[] getExtensions() {
        return this.extensionMgr.getExtensions();
    }

    @Override
    public String getToolTipText(MouseEvent mouseEvent) {
        if (this.textArea.getBuffer().isLoading()) {
            return null;
        }
        return this.extensionMgr.getToolTipText(mouseEvent.getX(), mouseEvent.getY());
    }

    public FontMetrics getFontMetrics() {
        return this.fm;
    }

    public int getLineHeight() {
        return this.fm.getHeight() + this.extraLineSpacing;
    }

    public int getFontHeight() {
        return this.fm.getHeight();
    }

    public int getLineExtraSpacing() {
        return this.extraLineSpacing;
    }

    public void setLineExtraSpacing(int n) {
        this.extraLineSpacing = n;
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        this.fm = this.getFontMetrics(font);
        this.textArea.recalculateVisibleLines();
        if (this.textArea.getBuffer() != null && !this.textArea.getBuffer().isLoading()) {
            this.textArea.recalculateLastPhysicalLine();
        }
    }

    public float getStringWidth(String string) {
        if (this.textArea.charWidth != 0) {
            return this.textArea.charWidth * string.length();
        }
        return (float)this.getFont().getStringBounds(string, this.getFontRenderContext()).getWidth();
    }

    public RenderingHints getRenderingHints() {
        return this.renderingHints;
    }

    @Override
    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    @Override
    public void paint(Graphics graphics) {
        assert (graphics instanceof Graphics2D);
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHints(this.renderingHints);
        this.fontRenderContext = graphics2D.getFontRenderContext();
        Rectangle rectangle = graphics2D.getClipBounds();
        int n = this.getLineHeight();
        int n2 = this.getFontHeight();
        if (n == 0 || this.textArea.getBuffer().isLoading()) {
            graphics2D.setColor(this.getBackground());
            graphics2D.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        } else {
            long l = System.nanoTime();
            int n3 = rectangle.y / n;
            int n4 = (rectangle.y + rectangle.height - 1) / n;
            graphics2D.setColor(this.getBackground());
            graphics2D.setFont(this.getFont());
            l = System.nanoTime() - l;
            long l2 = System.nanoTime();
            int n5 = n4 - n3 + 1;
            int n6 = n3 * n;
            graphics2D.fillRect(0, n6, this.getWidth(), n5 * n);
            this.extensionMgr.paintScreenLineRange(this.textArea, graphics2D, n3, n4, n6, n);
            l2 = System.nanoTime() - l2;
            if (Debug.PAINT_TIMER && n5 >= 1) {
                Log.log(1, this, "repainting " + n5 + " lines took " + l + "/" + l2 + " ns");
            }
        }
        this.textArea.updateMaxHorizontalScrollWidth();
    }

    @Override
    public float nextTabStop(float f, int n) {
        int n2 = (int)(f / this.textArea.tabSize);
        return (float)(n2 + 1) * this.textArea.tabSize;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dimension = new Dimension();
        char[] cArray = new char[80];
        for (int i = 0; i < cArray.length; ++i) {
            cArray[i] = 32;
        }
        dimension.width = (int)this.getStringWidth(new String(cArray));
        dimension.height = this.getLineHeight() * 25;
        return dimension;
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    TextAreaPainter(TextArea textArea) {
        this.enableEvents(28L);
        this.textArea = textArea;
        this.antiAlias = new AntiAlias(0);
        this.extensionMgr = new ExtensionManager();
        this.eolMarkerChar = "\u00b7";
        this.setAutoscrolls(true);
        this.setOpaque(true);
        this.setRequestFocusEnabled(false);
        this.setDoubleBuffered(false);
        this.setCursor(Cursor.getPredefinedCursor(2));
        this.fontRenderContext = new FontRenderContext(null, false, false);
        this.addExtension(-50, new PaintLineBackground());
        this.addExtension(-30, new PaintSelection());
        this.addExtension(-20, new PaintWrapGuide());
        this.addExtension(100, new StructureMatcher.Highlight(textArea));
        this.addExtension(200, new PaintText());
        this.addExtension(200, new PaintSelectionText());
        this.caretExtension = new PaintCaret();
        this.extraLineSpacing = 0;
    }

    private void updateRenderingHints() {
        HashMap<RenderingHints.Key, Object> hashMap = new HashMap<RenderingHints.Key, Object>();
        hashMap.put(RenderingHints.KEY_FRACTIONALMETRICS, this.fracFontMetrics ? RenderingHints.VALUE_FRACTIONALMETRICS_ON : RenderingHints.VALUE_FRACTIONALMETRICS_OFF);
        hashMap.put(RenderingHints.KEY_TEXT_ANTIALIASING, this.antiAlias.renderHint());
        if (this.antiAlias.val() == 0) {
            hashMap.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            this.fontRenderContext = new FontRenderContext(null, this.antiAlias.val() > 0, this.fracFontMetrics);
        } else if (this.antiAlias.val() > 1) {
            Object object = this.fracFontMetrics ? RenderingHints.VALUE_FRACTIONALMETRICS_ON : RenderingHints.VALUE_FRACTIONALMETRICS_OFF;
            this.fontRenderContext = new FontRenderContext(null, this.antiAlias.renderHint(), object);
        } else {
            hashMap.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            hashMap.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            hashMap.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            this.fontRenderContext = new FontRenderContext(null, this.antiAlias.val() > 0, this.fracFontMetrics);
        }
        this.renderingHints = new RenderingHints(hashMap);
    }

    private class PaintCaret
    extends TextAreaExtension {
        private PaintCaret() {
        }

        @Override
        public void paintValidLine(Graphics2D graphics2D, int n, int n2, int n3, int n4, int n5) {
            if (!TextAreaPainter.this.textArea.isCaretVisible()) {
                return;
            }
            int n6 = TextAreaPainter.this.textArea.getCaretPosition();
            if (n6 < n3 || n6 >= n4) {
                return;
            }
            int n7 = n6 - TextAreaPainter.this.textArea.getLineStartOffset(n2);
            TextAreaPainter.this.textArea.offsetToXY(n2, n7, TextAreaPainter.this.textArea.offsetXY);
            int n8 = TextAreaPainter.this.textArea.offsetXY.x;
            int n9 = TextAreaPainter.this.getLineHeight();
            int n10 = Math.min(n9, TextAreaPainter.this.getFontHeight());
            int n11 = Math.max(n9 - n10, 0);
            graphics2D.setColor(TextAreaPainter.this.caretColor);
            if (TextAreaPainter.this.textArea.isOverwriteEnabled()) {
                if (TextAreaPainter.this.thickCaret) {
                    graphics2D.fillRect(n8, n5 + n9 - 4, TextAreaPainter.this.textArea.charWidth, 3);
                } else {
                    graphics2D.drawLine(n8, n5 + n9 - 1, n8 + TextAreaPainter.this.textArea.charWidth, n5 + n9 - 1);
                }
            } else if (TextAreaPainter.this.blockCaret) {
                graphics2D.drawRect(n8, n5 + n11, TextAreaPainter.this.textArea.charWidth - 1, n10 - 1);
            } else if (TextAreaPainter.this.thickCaret) {
                graphics2D.fillRect(n8, n5 + n11, 3, n10 - 1);
            } else {
                graphics2D.drawLine(n8, n5 + n11, n8, n5 + n11 + n10 - 1);
            }
        }
    }

    private class PaintText
    extends TextAreaExtension {
        private PaintText() {
        }

        @Override
        public void paintValidLine(Graphics2D graphics2D, int n, int n2, int n3, int n4, int n5) {
            int n6;
            ChunkCache.LineInfo lineInfo = TextAreaPainter.this.textArea.chunkCache.getLineInfo(n);
            Font font = TextAreaPainter.this.getFont();
            Color color = TextAreaPainter.this.getForeground();
            graphics2D.setFont(font);
            graphics2D.setColor(color);
            int n7 = n6 = TextAreaPainter.this.textArea.getHorizontalOffset();
            float f = n5 + TextAreaPainter.this.getLineHeight() - (TextAreaPainter.this.fm.getLeading() + 1) - TextAreaPainter.this.fm.getDescent();
            if (lineInfo.chunks != null) {
                n6 = (int)((float)n6 + Chunk.paintChunkList(lineInfo.chunks, graphics2D, TextAreaPainter.this.textArea.getHorizontalOffset(), f, !Debug.DISABLE_GLYPH_VECTOR));
            }
            JEditBuffer jEditBuffer = TextAreaPainter.this.textArea.getBuffer();
            if (!lineInfo.lastSubregion) {
                graphics2D.setFont(font);
                graphics2D.setColor(TextAreaPainter.this.eolMarkerColor);
                graphics2D.drawString(":", (float)Math.max(n6, TextAreaPainter.this.textArea.getHorizontalOffset() + TextAreaPainter.this.textArea.wrapMargin + TextAreaPainter.this.textArea.charWidth), f);
                n6 += TextAreaPainter.this.textArea.charWidth;
            } else if (n2 < jEditBuffer.getLineCount() - 1 && jEditBuffer.isFoldStart(n2) && !TextAreaPainter.this.textArea.displayManager.isLineVisible(n2 + 1)) {
                int n8 = jEditBuffer.getFoldLevel(n2 + 1);
                if (jEditBuffer.getFoldHandler() instanceof IndentFoldHandler) {
                    n8 = Math.max(1, n8 / jEditBuffer.getIndentSize());
                }
                if (n8 > 3) {
                    n8 = 0;
                }
                SyntaxStyle syntaxStyle = TextAreaPainter.this.foldLineStyle[n8];
                Font font2 = syntaxStyle.getFont();
                graphics2D.setFont(font2);
                graphics2D.setColor(syntaxStyle.getForegroundColor());
                int n9 = n + 1;
                int n10 = n9 < TextAreaPainter.this.textArea.getVisibleLines() ? TextAreaPainter.this.textArea.chunkCache.getLineInfo((int)n9).physicalLine : TextAreaPainter.this.textArea.displayManager.getNextVisibleLine(n2);
                if (n10 == -1) {
                    n10 = TextAreaPainter.this.textArea.getLineCount();
                }
                int n11 = n10 - n2 - 1;
                String string = " [" + n11 + " lines]";
                float f2 = TextAreaPainter.this.getStringWidth(string);
                graphics2D.drawString(string, (float)n6, f);
                n6 = (int)((float)n6 + f2);
            } else if (TextAreaPainter.this.eolMarkers) {
                graphics2D.setFont(font);
                graphics2D.setColor(TextAreaPainter.this.eolMarkerColor);
                graphics2D.drawString(TextAreaPainter.this.eolMarkerChar, (float)n6, f);
                n6 += TextAreaPainter.this.textArea.charWidth;
            }
            lineInfo.width = n6 - n7;
        }
    }

    private class PaintWrapGuide
    extends TextAreaExtension {
        private PaintWrapGuide() {
        }

        @Override
        public void paintScreenLineRange(Graphics2D graphics2D, int n, int n2, int[] nArray, int[] nArray2, int[] nArray3, int n3, int n4) {
            if (TextAreaPainter.this.textArea.wrapMargin != 0 && !TextAreaPainter.this.textArea.wrapToWidth && TextAreaPainter.this.isWrapGuidePainted()) {
                graphics2D.setColor(TextAreaPainter.this.getWrapGuideColor());
                int n5 = TextAreaPainter.this.textArea.getHorizontalOffset() + TextAreaPainter.this.textArea.wrapMargin;
                graphics2D.drawLine(n5, n3, n5, n3 + (n2 - n + 1) * n4);
            }
        }

        @Override
        public String getToolTipText(int n, int n2) {
            int n3;
            if (TextAreaPainter.this.textArea.wrapMargin != 0 && !TextAreaPainter.this.textArea.wrapToWidth && TextAreaPainter.this.isWrapGuidePainted() && Math.abs(n - (n3 = TextAreaPainter.this.textArea.wrapMargin + TextAreaPainter.this.textArea.getHorizontalOffset())) < 5) {
                return String.valueOf(TextAreaPainter.this.textArea.getBuffer().getProperty("maxLineLen"));
            }
            return null;
        }
    }

    private class PaintSelectionText
    extends TextAreaExtension {
        private float indent;
        private boolean indentFound = false;

        private PaintSelectionText() {
        }

        @Override
        public void paintValidLine(Graphics2D graphics2D, int n, int n2, int n3, int n4, int n5) {
            if (TextAreaPainter.this.textArea.getSelectionCount() == 0) {
                return;
            }
            if (!TextAreaPainter.this.isSelectionFgColorEnabled() || TextAreaPainter.this.getSelectionFgColor() == null) {
                return;
            }
            Iterator<Selection> iterator = TextAreaPainter.this.textArea.getSelectionIterator();
            while (iterator.hasNext()) {
                Selection selection = iterator.next();
                this.paintSelection(graphics2D, n, n2, n5, selection);
            }
        }

        private void paintSelection(Graphics2D graphics2D, int n, int n2, int n3, Selection selection) {
            int n4;
            int n5;
            if (n2 < selection.getStartLine() || n2 > selection.getEndLine()) {
                return;
            }
            float f = this.indent = (float)TextAreaPainter.this.textArea.getHorizontalOffset();
            float f2 = n3 + TextAreaPainter.this.getLineHeight() - (TextAreaPainter.this.fm.getLeading() + 1) - TextAreaPainter.this.fm.getDescent();
            DefaultTokenHandler defaultTokenHandler = new DefaultTokenHandler();
            TextAreaPainter.this.textArea.getBuffer().markTokens(n2, defaultTokenHandler);
            Token token = defaultTokenHandler.getTokens();
            int n6 = TextAreaPainter.this.textArea.getLineStartOffset(n2);
            if (selection instanceof Selection.Rect) {
                Selection.Rect rect = (Selection.Rect)selection;
                n5 = rect.getStart(TextAreaPainter.this.textArea.getBuffer(), n2);
                n4 = rect.getEnd(TextAreaPainter.this.textArea.getBuffer(), n2);
            } else {
                n5 = selection.getStart() > n6 ? selection.getStart() : n6;
                n4 = selection.getEnd();
            }
            int n7 = TextAreaPainter.this.textArea.getScreenLineStartOffset(n);
            int n8 = TextAreaPainter.this.textArea.getScreenLineEndOffset(n);
            if (n7 > n5) {
                n5 = n7;
            }
            if (n8 < n4) {
                n4 = n8;
            }
            this.indentFound = false;
            int n9 = n6;
            while (token.id != 127) {
                int n10 = n9 + token.length;
                String string = null;
                SyntaxStyle syntaxStyle = TextAreaPainter.this.styles[token.id];
                if (n10 > n5) {
                    if (n9 >= n4) break;
                    if (syntaxStyle != null) {
                        int n11;
                        graphics2D.setFont(syntaxStyle.getFont());
                        graphics2D.setColor(TextAreaPainter.this.getSelectionFgColor());
                        if (n5 > n9) {
                            n11 = n5;
                            f = this.nextX(f, syntaxStyle, string, n9, n5);
                        } else {
                            n11 = n9;
                        }
                        int n12 = n4 > n10 ? n10 : n4;
                        string = TextAreaPainter.this.textArea.getText(n11, n12 - n11);
                        graphics2D.drawString(string, f, f2);
                        f = this.nextX(f, syntaxStyle, string, n11, n12);
                    }
                }
                if (string == null) {
                    f = this.nextX(f, syntaxStyle, null, n9, n10);
                }
                n9 = n10;
                token = token.next;
                if (n9 != n7) continue;
                f = this.indent;
            }
        }

        float nextX(float f, SyntaxStyle syntaxStyle, String string, int n, int n2) {
            if (string == null) {
                string = TextAreaPainter.this.textArea.getText(n, n2 - n);
            }
            if (string.equals("\t")) {
                int n3 = TextAreaPainter.this.textArea.getHorizontalOffset();
                f = TextAreaPainter.this.nextTabStop(f - (float)n3, n2) + (float)n3;
            } else {
                if (!this.indentFound && !string.equals(" ")) {
                    this.indentFound = true;
                    this.indent = f;
                }
                Font font = syntaxStyle != null ? syntaxStyle.getFont() : TextAreaPainter.this.getFont();
                f = (float)((double)f + font.getStringBounds(string, TextAreaPainter.this.getFontRenderContext()).getWidth());
            }
            return f;
        }
    }

    private class PaintSelection
    extends TextAreaExtension {
        private PaintSelection() {
        }

        @Override
        public void paintValidLine(Graphics2D graphics2D, int n, int n2, int n3, int n4, int n5) {
            if (TextAreaPainter.this.textArea.getSelectionCount() == 0) {
                return;
            }
            graphics2D.setColor(TextAreaPainter.this.textArea.isMultipleSelectionEnabled() ? TextAreaPainter.this.getMultipleSelectionColor() : TextAreaPainter.this.getSelectionColor());
            Iterator<Selection> iterator = TextAreaPainter.this.textArea.getSelectionIterator();
            while (iterator.hasNext()) {
                Selection selection = iterator.next();
                this.paintSelection(graphics2D, n, n2, n5, selection);
            }
        }

        private void paintSelection(Graphics2D graphics2D, int n, int n2, int n3, Selection selection) {
            int[] nArray = TextAreaPainter.this.textArea.selectionManager.getSelectionStartAndEnd(n, n2, selection);
            if (nArray == null) {
                return;
            }
            int n4 = nArray[0];
            int n5 = nArray[1];
            graphics2D.fillRect(n4, n3, n5 - n4, TextAreaPainter.this.getLineHeight());
        }
    }

    private class PaintLineBackground
    extends TextAreaExtension {
        private PaintLineBackground() {
        }

        private boolean shouldPaintLineHighlight(int n, int n2, int n3) {
            if (!TextAreaPainter.this.isLineHighlightEnabled() || n < n2 || n >= n3) {
                return false;
            }
            int n4 = TextAreaPainter.this.textArea.getSelectionCount();
            if (n4 == 1) {
                Selection selection = TextAreaPainter.this.textArea.getSelection(0);
                return selection.getStartLine() == selection.getEndLine();
            }
            return n4 == 0;
        }

        @Override
        public void paintValidLine(Graphics2D graphics2D, int n, int n2, int n3, int n4, int n5) {
            Color color;
            boolean bl;
            int n6;
            TextArea textArea = TextAreaPainter.this.textArea;
            JEditBuffer jEditBuffer = textArea.getBuffer();
            boolean bl2 = n2 < jEditBuffer.getLineCount() - 1 && jEditBuffer.isFoldStart(n2) && !textArea.displayManager.isLineVisible(n2 + 1);
            SyntaxStyle syntaxStyle = null;
            if (bl2) {
                n6 = jEditBuffer.getFoldLevel(n2 + 1);
                if (jEditBuffer.getFoldHandler() instanceof IndentFoldHandler) {
                    n6 = Math.max(1, n6 / jEditBuffer.getIndentSize());
                }
                if (n6 > 3) {
                    n6 = 0;
                }
                syntaxStyle = TextAreaPainter.this.foldLineStyle[n6];
            }
            if (bl = this.shouldPaintLineHighlight(n6 = textArea.getCaretPosition(), n3, n4)) {
                color = TextAreaPainter.this.lineHighlightColor;
            } else if (bl2) {
                color = syntaxStyle.getBackgroundColor();
                if (color == null) {
                    color = TextAreaPainter.this.getBackground();
                }
            } else {
                color = TextAreaPainter.this.getBackground();
            }
            if (bl || bl2) {
                graphics2D.setColor(color);
                graphics2D.fillRect(0, n5, TextAreaPainter.this.getWidth(), TextAreaPainter.this.getLineHeight());
            }
            ChunkCache.LineInfo lineInfo = textArea.chunkCache.getLineInfo(n);
            if (lineInfo.chunks != null) {
                float f = n5 + TextAreaPainter.this.getLineHeight() - (TextAreaPainter.this.fm.getLeading() + 1) - TextAreaPainter.this.fm.getDescent();
                Chunk.paintChunkBackgrounds(lineInfo.chunks, graphics2D, textArea.getHorizontalOffset(), f, TextAreaPainter.this.getLineHeight());
            }
        }
    }
}

